/*
 * Decompiled with CFR 0.152.
 */
package com.fullonad.utill;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class PlaySounds
implements PlayerListener {
    public static final String Format_Type_AMR = "audio/amr";
    public static final String Format_Type_MP3 = "audio/mpeg";
    VolumeControl Volume;
    long mDuration;
    private PlaySounds mPlayAudioSound;
    private int mAudio_File_Id;
    String mFile_Resource_Path;
    private CallBack mCallBack;
    Player mPlayer = null;

    public PlaySounds(CallBack callback) {
        this.mCallBack = callback;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && this.mCallBack != null) {
            this.mCallBack.FileEndReachOfMedia(this.mAudio_File_Id);
        }
    }

    public Player PlaySample(String filename, boolean aIsLoopingOn, int PlayerNumber, String fileformat) {
        Object player = null;
        boolean execute = true;
        if (this.mFile_Resource_Path != null) {
            execute = this.mFile_Resource_Path.compareTo(filename) != 0;
        }
        if (execute) {
            this.stopAll();
            this.mFile_Resource_Path = filename;
            this.mAudio_File_Id = PlayerNumber;
            InputStream stream = this.getClass().getResourceAsStream("/res/" + filename);
            try {
                this.mPlayer = Manager.createPlayer((InputStream)stream, (String)fileformat);
                if (aIsLoopingOn) {
                    this.mPlayer.setLoopCount(100);
                }
                this.mPlayer.realize();
                this.mPlayer.addPlayerListener((PlayerListener)this);
                this.mPlayer.start();
                this.mDuration = this.mPlayer.getDuration() / 1000000L;
            }
            catch (Exception ex) {}
        } else if (this.mPlayer != null) {
            try {
                this.mPlayer.setMediaTime(0L);
                this.mPlayer.start();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
        return this.mPlayer;
    }

    private static synchronized void stop(Player player) {
        if (player.getState() == 400) {
            try {
                player.stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
        player.deallocate();
        player.close();
        player = null;
    }

    public void stopAll() {
        if (this.mPlayer != null) {
            PlaySounds.stop(this.mPlayer);
            this.mPlayer = null;
            this.mFile_Resource_Path = null;
        }
    }

    public static interface CallBack {
        public void FileEndReachOfMedia(int var1);
    }
}

