/*
 * Decompiled with CFR 0.152.
 */
package com.fullonad.utill;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Button {
    private Image mImagePressed;
    private Image mImageTemp;
    private int mButtonId;
    private ButtonCallback mCallBack;
    private int mButtonXCordi;
    private int mButtonYCordi;
    private boolean mbuttonBGShow = false;
    private int mBackgroundFillColor = 65280;

    public Button(Image pressImage, int xCordi, int ycordi, int buttonId, ButtonCallback callback) {
        this.mButtonXCordi = xCordi;
        this.mButtonYCordi = ycordi;
        this.mButtonId = buttonId;
        this.mCallBack = callback;
        this.mImageTemp = this.mImagePressed = pressImage;
    }

    public boolean pointerPressed(int xCordi, int yCordi) {
        if (xCordi > this.mButtonXCordi && xCordi < this.mButtonXCordi + this.mImageTemp.getWidth() && yCordi > this.mButtonYCordi && yCordi < this.mButtonYCordi + this.mImageTemp.getHeight()) {
            this.mImageTemp = this.pressingEffect(this.mImageTemp);
            this.mCallBack.callRepaint(this.mButtonXCordi, this.mButtonYCordi, this.mButtonXCordi + this.mImagePressed.getWidth(), this.mButtonYCordi + this.mImagePressed.getHeight());
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(300L);
                        Button.this.mImageTemp = Button.this.mImagePressed;
                        Button.this.mCallBack.buttonClicked(Button.this.mButtonId);
                        Button.this.mCallBack.callRepaint(Button.this.mButtonXCordi, Button.this.mButtonYCordi, Button.this.mButtonXCordi + Button.this.mImagePressed.getWidth(), Button.this.mButtonYCordi + Button.this.mImagePressed.getHeight());
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        g.drawImage(this.mImageTemp, this.mButtonXCordi, this.mButtonYCordi, 0);
    }

    public void SetCordinate(int aXCordi, int aYCordi) {
        this.mButtonXCordi = aXCordi;
        this.mButtonYCordi = aYCordi;
    }

    public void setImage(Image image) {
        this.mImageTemp = image;
        this.mImagePressed = image;
    }

    public int getWidth() {
        return this.mImagePressed.getWidth();
    }

    public int getHeight() {
        return this.mImagePressed.getHeight();
    }

    public int getX() {
        return this.mButtonXCordi;
    }

    public int getY() {
        return this.mButtonYCordi;
    }

    private Image pressingEffect(Image image) {
        int[] imageArray = new int[image.getWidth() * image.getHeight()];
        image.getRGB(imageArray, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        for (int i = 0; i < imageArray.length; ++i) {
            int alpha = imageArray[i] >> 24 & 0xFF;
            if (alpha == 0) continue;
            imageArray[i] = 0x4F000000 | imageArray[i] & 0xFFFFFF;
        }
        return Image.createRGBImage((int[])imageArray, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    public static interface ButtonCallback {
        public void callRepaint(int var1, int var2, int var3, int var4);

        public void buttonClicked(int var1);
    }
}

