/*
 * Decompiled with CFR 0.152.
 */
package com.fullonad.main;

import com.fullonad.general.AppFun;
import com.fullonad.main.MainMidlet;
import com.fullonad.utill.Button;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyCanvas
extends Canvas
implements Runnable,
Button.ButtonCallback,
MainMidlet.Callback {
    private Image img_Empty = null;
    private Image img_Low = null;
    private Image img_Fill = null;
    private Image img_Bg = null;
    private int x;
    private int y;
    private int result;
    private Thread thread = null;
    String BATTERY_LEVEL;
    private Button btn_About;
    private Button mBackButton;
    Font f = Font.getFont((int)32, (int)1, (int)0);

    public MyCanvas() {
        this.setFullScreenMode(true);
        try {
            this.img_Empty = Image.createImage((String)"/res/blank.png");
            this.img_Low = Image.createImage((String)"/res/low.png");
            this.img_Fill = Image.createImage((String)"/res/fill.png");
            this.img_Bg = Image.createImage((String)"/res/main/bg.png");
            this.x = (this.getWidth() - this.img_Empty.getWidth()) / 2;
            this.y = (this.getHeight() - this.img_Empty.getHeight()) / 2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.btn_About = new Button(AppFun.createImage("button/info.png"), 5, 10, 0, this);
        this.btn_About.SetCordinate(5, this.getHeight() - this.btn_About.getHeight() - 5);
        this.mBackButton = new Button(AppFun.createImage("button/back.png"), 10, 10, 1, this);
        this.mBackButton.SetCordinate(this.getWidth() - (this.mBackButton.getWidth() + 5), this.getHeight() - (this.mBackButton.getHeight() + 5));
        this.thread = new Thread(this);
        this.thread.start();
        if (MainMidlet.ASHA_501) {
            this.AddBackButton();
        }
    }

    private void AddBackButton() {
        Command mBack = new Command("Back", 2, 0);
        this.addCommand(mBack);
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                MainMidlet.mMidlet.Close();
            }
        });
    }

    protected void showNotify() {
        super.showNotify();
        MainMidlet.mMidlet.registerForUP(this);
        MainMidlet.mMidlet.unregisterDown();
    }

    protected void paint(Graphics g) {
        g.drawImage(this.img_Bg, 0, 0, 0);
        if (this.result <= 1) {
            g.drawImage(this.img_Low, (this.getWidth() - this.img_Low.getWidth()) / 2, this.y + this.img_Empty.getHeight() - 10 - this.img_Low.getHeight(), 0);
        } else {
            for (int i = 0; i < this.result; ++i) {
                g.drawImage(this.img_Fill, (this.getWidth() - this.img_Fill.getWidth()) / 2, this.y + this.img_Empty.getHeight() - 30 - (this.img_Fill.getHeight() + 1) * i, 0);
            }
        }
        g.drawImage(this.img_Empty, this.x, this.y, 0);
        this.btn_About.paint(g);
        if (!MainMidlet.ASHA_501) {
            this.mBackButton.paint(g);
        }
        g.setColor(0xFFFFFF);
        g.setFont(this.f);
        if (this.BATTERY_LEVEL != null) {
            g.drawString(this.BATTERY_LEVEL, (this.getWidth() - g.getFont().stringWidth(this.BATTERY_LEVEL)) / 2, this.y + this.img_Empty.getHeight(), 0);
        }
        MainMidlet.mMidlet.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.btn_About.pointerPressed(x, y);
        if (!MainMidlet.ASHA_501) {
            this.mBackButton.pointerPressed(x, y);
        }
        MainMidlet.mMidlet.adClicked(x, y);
    }

    public void run() {
        while (true) {
            this.BATTERY_LEVEL = System.getProperty("com.nokia.mid.batterylevel");
            String str = this.BATTERY_LEVEL.replace('%', ' ');
            int level = Integer.parseInt(str.trim());
            this.result = Math.abs(level / 10);
            this.repaint();
            System.out.println("Hello World");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.repaint();
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint(xcordi, ycordi, width, height);
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                MainMidlet.mMidlet.startAbout();
                break;
            }
            case 1: {
                MainMidlet.mMidlet.Close();
            }
        }
    }
}

