/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MetaDataControl;

public class PlayerThread
extends Thread
implements PlayerListener {
    InputStream is = null;
    String type = null;
    Player player = null;
    String fileName = null;
    PlayerThreadInvoker invoker = null;

    public PlayerThread(PlayerThreadInvoker invoker, String filename) {
        this.invoker = invoker;
        this.fileName = filename;
    }

    public PlayerThread(PlayerThreadInvoker invoker, InputStream is, String type) {
        this.invoker = invoker;
        this.is = is;
        this.type = type;
    }

    public void run() {
        try {
            this.player = this.fileName == null ? Manager.createPlayer((InputStream)this.is, (String)this.type) : Manager.createPlayer((String)this.fileName);
            this.player.addPlayerListener((PlayerListener)this);
            this.player.prefetch();
            this.player.realize();
            this.player.start();
        }
        catch (Throwable e) {
            this.invoker.playerError("ERR" + e.getMessage());
        }
    }

    public void close() {
        try {
            this.player.close();
            this.invoker.playerStopped();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equalsIgnoreCase("started")) {
            this.invoker.playerStarted();
            MetaDataControl mc = (MetaDataControl)player.getControl("MetaDataControl");
            this.invoker.setMetaDataControl(mc);
        }
        if (event.equalsIgnoreCase("endOfMedia")) {
            player.close();
            this.invoker.playerStopped();
        }
    }
}

