/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.amms.EffectModule;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.control.audioeffect.EqualizerControl;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class FileBrowsingCanvas
extends Canvas
implements FileActionInvoker,
PlayerThreadInvoker,
PhotoThreadInvoker,
FileThreadInvoker,
Runnable {
    MusicPlayer midlet;
    private final int WIDTH;
    private final int HEIGHT;
    private Image folderImage;
    private Image fileImage;
    private Image downArrowImage;
    private Image upArrowImage;
    private Image pauseImage;
    private Image playImage;
    private Font small_Font = Font.getFont((int)0, (int)0, (int)8);
    private Font medium_Font = Font.getFont((int)0, (int)0, (int)0);
    private int font_medium_Height;
    private int font_small_Height;
    private int font_medium_Width;
    private int font_small_Width;
    private int text_button_Width;
    private int box_Width;
    private int box_Height;
    private int visibleTopIndex;
    private int visibleBottomIndex;
    private int visibleBottomIndex_START;
    private int dirIndex = 0;
    private String currentDir = "/";
    private Vector dirList = new Vector();
    private int dirSize = 0;
    private Thread thread = null;
    private boolean stopped = false;
    private PlayerThread playerThread = null;
    private PhotoThread photoThread = null;
    private FileThread fileThread = null;
    private boolean playingAudio = false;
    private boolean playingPhoto = false;
    private boolean dirIndexIsAudio = false;
    private boolean dirIndexIsPhoto = false;
    private boolean dirIndexIsDirectory = false;
    protected FileAction fileAction = null;
    private boolean pulsado = false;
    private static boolean pause = false;
    private static boolean playContinuo = false;
    private static boolean directoryPlayNext = true;
    private static boolean esPrimeraVez = false;
    private static boolean saliendo = false;
    private static String ficheroActual;
    private static int volumenActual;
    private static long duracion;
    private static String error;
    private static String errorPhoto;
    private static String ficheroAEliminar;
    private static String directoryPlaying;
    private static String ficheroCaratula;
    private Image imagenCargada;
    private static String[] metaKeys;
    private static String[] metaInfo;
    private static String[] presets;
    private static int modoActual;
    private static int modoAnterior;
    private EqualizerControl equalizer;
    private EffectModule effectModule = null;
    private String errorEq = "";
    private int eqBass = 50;
    private int eqTreble = 50;
    private int eqMaxBand;
    private int eqMinBand;
    private int eqActualBand;
    Image play16;
    Image pause16;
    Image next16;
    Image volUp16;
    Image volDown16;
    Image prev16;
    int tickerTextPos = 0;
    int volCounter;

    public FileBrowsingCanvas(MusicPlayer midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.fileAction = new FileAction(this);
        this.WIDTH = this.getWidth();
        this.HEIGHT = this.getHeight();
        this.box_Width = this.WIDTH - 20;
        this.box_Height = 20;
        this.setProperties();
        this.loadProgramImages();
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.play16 = Image.createImage((String)"/res/play16.png");
            this.volUp16 = Image.createImage((String)"/res/vol_up16.png");
            this.next16 = Image.createImage((String)"/res/next16.png");
            this.pause16 = Image.createImage((String)"/res/pause16.png");
            this.volDown16 = Image.createImage((Image)this.volUp16, (int)0, (int)0, (int)16, (int)16, (int)3);
            this.prev16 = Image.createImage((Image)this.next16, (int)0, (int)0, (int)16, (int)16, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Thread(new Runnable(){

            public void run() {
                FileBrowsingCanvas.this.fileAction.getDirContent(FileBrowsingCanvas.this.currentDir);
            }
        }).start();
    }

    public void run() {
        while (!this.stopped) {
            this.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    public void paint(Graphics g) {
        g.setColor(3501008);
        g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
        g.setColor(0xFFFFFF);
        g.setFont(this.medium_Font);
        switch (modoActual) {
            case 1: {
                this.paintAudio(g);
                break;
            }
            case 2: 
            case 6: {
                this.paintPhoto(g);
                break;
            }
            case 3: 
            case 7: {
                this.paintLoading(g);
                break;
            }
            case 4: {
                this.paintDeleting(g);
                break;
            }
            case 5: {
                this.paintInfo(g);
                break;
            }
            case 8: {
                this.paintEcualizador(g);
                break;
            }
            default: {
                this.paintBrowser(g);
            }
        }
        g.setColor(0xFFFFFF);
        g.drawString("Music Player", this.WIDTH / 2, 0, 17);
        g.drawLine(0, this.font_medium_Height, this.WIDTH, this.font_medium_Height);
        g.drawLine(0, this.HEIGHT - this.font_medium_Height, this.WIDTH, this.HEIGHT - this.font_medium_Height);
        g.drawString("Exit", this.WIDTH, this.HEIGHT, 40);
    }

    public void paintBrowser(Graphics g) {
        int lastIndex = this.visibleBottomIndex < this.dirSize ? this.visibleBottomIndex : this.dirSize;
        int j = 1;
        g.drawString(this.currentDir, 1, this.font_medium_Height, 0);
        for (int i = this.visibleTopIndex; i < lastIndex; ++i) {
            String fichero = "";
            try {
                fichero = (String)this.dirList.elementAt(i);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.dirIndex == i) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, this.font_medium_Height + 2 + (j + 1) * this.font_small_Height, this.WIDTH, this.font_medium_Height - 4);
                g.setColor(3501008);
            }
            if (this.isDirectory(fichero)) {
                g.drawImage(this.folderImage, 0, this.font_medium_Height + (j + 1) * this.font_small_Height + this.folderImage.getHeight() / 2 - 1, 0);
            } else {
                g.drawImage(this.fileImage, 0, this.font_medium_Height + (j + 1) * this.font_small_Height + this.folderImage.getHeight() / 2 - 1, 0);
            }
            try {
                if (this.dirIndex == i) {
                    g.setColor(3501008);
                } else {
                    g.setColor(0xFFFFFF);
                }
                g.drawString(fichero, 17, this.font_medium_Height + (j + 1) * this.font_small_Height, 0);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++j;
        }
        g.setColor(0xCCCCCC);
        if (this.visibleBottomIndex < this.dirSize) {
            g.drawImage(this.downArrowImage, this.WIDTH - 30, this.HEIGHT - this.font_medium_Height - 10, 0);
        }
        if (this.visibleTopIndex > 0) {
            g.drawImage(this.upArrowImage, this.WIDTH - 30, this.font_medium_Height + this.font_small_Height + 5, 0);
        }
        g.setColor(0xFFFFFF);
        if (this.dirIndexIsDirectory) {
            g.drawString("Open", 0, this.HEIGHT, 36);
        } else if (this.dirIndexIsAudio) {
            g.drawString("Play", 0, this.HEIGHT, 36);
        } else if (this.dirIndexIsPhoto) {
            g.drawString("Ver", 0, this.HEIGHT, 36);
        }
    }

    public void paintAudio(Graphics g) {
        int indice = 0;
        if (error != null && !error.equals("")) {
            g.drawString("An error has occurred: ", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
            g.drawString(error, 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
            g.setColor(0xFFFFFF);
            g.drawString("Stop", 0, this.HEIGHT, 36);
            return;
        }
        long tiempo = 0L;
        try {
            tiempo = this.playerThread.player.getMediaTime() / 1000000L;
        }
        catch (Exception e) {
            // empty catch block
        }
        int max = this.WIDTH - 25;
        long longitud = 0L;
        if (duracion != 0L) {
            longitud = tiempo * (long)(max - 3) / duracion;
        }
        g.drawString(this.currentDir, 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        StringBuffer sb = new StringBuffer(ficheroActual + " ");
        if (metaKeys != null) {
            for (int i = 0; i < metaInfo.length; ++i) {
                sb.append(metaInfo[i] + " ");
            }
        }
        String ticketrText = sb.toString();
        int strWidth = Font.getDefaultFont().stringWidth(ticketrText);
        if (strWidth > this.getWidth() - 5) {
            g.drawString(ticketrText, this.tickerTextPos, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
            --this.tickerTextPos;
            if (this.tickerTextPos + strWidth < 5) {
                this.tickerTextPos = this.getWidth() - 5;
            }
        } else {
            g.drawString(ficheroActual, 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        }
        g.drawString(this.long2time(tiempo), 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString(this.long2time(duracion), this.WIDTH, this.font_medium_Height + indice * this.font_medium_Height, 40);
        int y = 3 + this.font_medium_Height + indice++ * this.font_medium_Height;
        g.drawRect(8, y, max, 10);
        g.fillRect(10, y + 2, (int)longitud, 7);
        g.drawString("Volume: " + volumenActual + " %", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.setColor(0xFFFFFF);
        if (this.playingAudio) {
            g.drawString("Stop", 0, this.HEIGHT, 36);
        } else {
            g.drawString("Play", 0, this.HEIGHT, 36);
        }
        this.paintMenu(g);
    }

    private void paintMenu(Graphics g) {
        int OFFSET_FROM_BUTTON = 90;
        int CIRCLE_DIAMETER = 60;
        g.drawImage(this.volUp16, this.getWidth() / 2, this.getHeight() - 90, 3);
        g.drawImage(this.volDown16, this.getWidth() / 2, this.getHeight() - 90 + 60, 3);
        if (pause) {
            g.drawImage(this.play16, this.getWidth() / 2, this.getHeight() - 90 + 30, 3);
        } else {
            g.drawImage(this.pause16, this.getWidth() / 2, this.getHeight() - 90 + 30, 3);
        }
        g.drawImage(this.next16, this.getWidth() / 2 + 30, this.getHeight() - 90 + 30, 3);
        g.drawImage(this.prev16, this.getWidth() / 2 - 30, this.getHeight() - 90 + 30, 3);
    }

    public void paintPhoto(Graphics g) {
        if (errorPhoto != null && !errorPhoto.equals("")) {
            int indice = 0;
            g.drawString("An error has occurred: ", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
            g.drawString(errorPhoto, 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
            g.setColor(0xFFFFFF);
            g.drawString("Stop", 0, this.HEIGHT, 36);
        } else if (this.imagenCargada != null) {
            g.drawImage(this.imagenCargada, this.WIDTH / 2, this.HEIGHT / 2, 3);
            g.setColor(0xFFFFFF);
            g.drawString("Stop", 0, this.HEIGHT, 36);
        }
    }

    public void paintLoading(Graphics g) {
        try {
            g.setColor(0xFFFFFF);
            g.drawString("Loading...", this.WIDTH / 2, this.HEIGHT / 2, 33);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintDeleting(Graphics g) {
        int indice = 0;
        String fichero = (String)this.dirList.elementAt(this.dirIndex);
        if (fichero.equals("..")) {
            fichero = this.currentDir;
        }
        g.drawString(this.currentDir, 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("Delete the file:", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString(fichero, 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        int n = ++indice;
        g.drawString("OK key or 5 shot", 5, this.font_medium_Height + n * this.font_medium_Height, 0);
        int n2 = ++indice;
        ++indice;
        g.drawString("Cancel: Stop or 0", 5, this.font_medium_Height + n2 * this.font_medium_Height, 0);
        g.setColor(0xFFFFFF);
        g.drawString("Stop", 0, this.HEIGHT, 36);
    }

    public void paintInfo(Graphics g) {
        int indice = 1;
        g.drawString("Info", this.WIDTH / 2, this.font_medium_Height + indice++ * this.font_medium_Height, 33);
        g.drawString("Supported files:", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("- Audio:", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("MP3, AMR, WAV, MID,", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("WMA, WMA9, M4A and MP4", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("- Foto:", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("jpg, png, GIF, BMP", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        int n = ++indice;
        g.drawString("More info:", 5, this.font_medium_Height + n * this.font_medium_Height, 0);
        int n2 = ++indice;
        ++indice;
        g.drawString("sandi.creatives@gmail.com", 5, this.font_medium_Height + n2 * this.font_medium_Height, 0);
        g.setColor(0xFFFFFF);
        g.drawString("Stop", 0, this.HEIGHT, 36);
    }

    public void paintEcualizador(Graphics g) {
        int indice = 1;
        g.drawString("Ecualizador", this.WIDTH / 2, this.font_medium_Height + indice++ * this.font_medium_Height, 33);
        g.drawString("Bass: " + this.eqBass + " %", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        g.drawString("Treble: " + this.eqTreble + " %", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        ++indice;
        if (this.equalizer == null) {
            g.drawString("Ecualizador no soportado.", 5, this.font_medium_Height + indice++ * this.font_medium_Height, 0);
        }
        g.drawString("Stop", 0, this.HEIGHT, 36);
    }

    public void keyPressed(int key) {
        switch (key) {
            case -1: 
            case 50: {
                if (modoActual == 8) {
                    this.modificarEcualizador(0, 10);
                    break;
                }
                if (this.playingAudio) {
                    this.cambiarVolumen(10);
                    break;
                }
                if (modoActual == 2) break;
                this.listaArriba();
                break;
            }
            case -2: 
            case 56: {
                if (modoActual == 8) {
                    this.modificarEcualizador(0, -10);
                    break;
                }
                if (this.playingAudio) {
                    this.cambiarVolumen(-10);
                    break;
                }
                if (modoActual == 2) break;
                this.listaAbajo();
                break;
            }
            case -5: 
            case 53: {
                if (modoActual == 4) break;
                if (modoActual == 6) {
                    this.stopPhoto();
                    break;
                }
                if (modoActual == 8) {
                    this.ecualizador();
                    break;
                }
                if (this.dirIndexIsAudio) {
                    if (!this.playingAudio) {
                        playContinuo = true;
                        this.loadAudio();
                        break;
                    }
                    this.pauseAudio(false);
                    break;
                }
                if (this.dirIndexIsPhoto) {
                    if (!this.playingPhoto) {
                        this.loadPhoto();
                        break;
                    }
                    this.stopPhoto();
                    break;
                }
                if (this.dirIndexIsDirectory) {
                    directoryPlayNext = true;
                    this.traverse();
                    break;
                }
                if (modoActual != 5) break;
                this.cambiarInfo();
                break;
            }
            case -7: {
                this.salir();
                break;
            }
            case 49: {
                this.desplazarArriba(true);
                break;
            }
            case 57: {
                this.desplazarArriba(false);
                break;
            }
            case 42: {
                this.minimizar();
                break;
            }
            case 35: {
                this.cambiarInfo();
            }
        }
        this.pulsado = false;
    }

    protected void keyRepeated(int key) {
        if (this.playingAudio && modoActual != 8) {
            switch (key) {
                case -1: 
                case 50: {
                    this.cambiarVolumen(10);
                    break;
                }
                case -2: 
                case 56: {
                    this.cambiarVolumen(-10);
                    break;
                }
                case -3: 
                case 52: {
                    long tiempo = this.playerThread.player.getMediaTime() - 10000000L;
                    try {
                        this.playerThread.player.stop();
                        this.playerThread.player.setMediaTime(tiempo);
                        if (tiempo > 0L) break;
                        this.pauseAudio(true);
                    }
                    catch (MediaException e) {
                        this.keyPressed(key);
                    }
                    break;
                }
                case -4: 
                case 54: {
                    long tiempoAux = this.playerThread.player.getMediaTime() + 10000000L;
                    try {
                        this.playerThread.player.stop();
                        long tmp = this.playerThread.player.setMediaTime(tiempoAux);
                        break;
                    }
                    catch (MediaException e) {
                        this.keyPressed(key);
                    }
                }
            }
            this.pulsado = true;
        } else {
            this.keyPressed(key);
        }
    }

    protected void keyReleased(int keyCode) {
        switch (keyCode) {
            case -3: 
            case 52: {
                if (modoActual == 1) {
                    if (this.pulsado) {
                        if (pause) break;
                        try {
                            this.playerThread.player.start();
                        }
                        catch (MediaException e) {}
                        break;
                    }
                    if (!this.playingAudio) break;
                    if (directoryPlaying != null) {
                        directoryPlayNext = false;
                    } else if (this.listaArriba() && this.dirIndexIsAudio) {
                        this.listaArriba();
                    } else {
                        playContinuo = false;
                    }
                    this.stopAudio();
                    break;
                }
                if (modoActual != 8) break;
                this.modificarEcualizador(1, -10);
                break;
            }
            case -4: 
            case 54: {
                if (modoActual == 1) {
                    if (this.pulsado) {
                        if (pause) break;
                        try {
                            this.playerThread.player.start();
                        }
                        catch (MediaException mediaException) {}
                        break;
                    }
                    if (!this.playingAudio) break;
                    if (directoryPlaying != null) {
                        directoryPlayNext = true;
                    } else if (!this.dirIndexIsAudio) {
                        playContinuo = false;
                    }
                    this.stopAudio();
                    break;
                }
                if (modoActual != 8) break;
                this.modificarEcualizador(1, 10);
                break;
            }
            case 48: {
                this.menuDelete();
                break;
            }
            case -5: 
            case 53: {
                if (modoActual != 4) break;
                this.deleteFile();
                break;
            }
            case -6: {
                if (modoActual == 4) {
                    this.cancelDelete();
                    break;
                }
                if (modoActual == 5) {
                    this.cambiarInfo();
                    break;
                }
                if (modoActual == 6) {
                    this.stopPhoto();
                    break;
                }
                if (modoActual == 8) {
                    this.ecualizador();
                    break;
                }
                if (this.dirIndexIsAudio) {
                    playContinuo = false;
                    if (!this.playingAudio) {
                        this.loadAudio();
                        break;
                    }
                    directoryPlaying = null;
                    this.stopAudio();
                    break;
                }
                if (this.dirIndexIsPhoto) {
                    if (!this.playingPhoto) {
                        this.loadPhoto();
                        break;
                    }
                    this.stopPhoto();
                    break;
                }
                if (!this.dirIndexIsDirectory) break;
                this.traverse();
                break;
            }
            case 51: {
                if (!this.playingAudio && modoActual != 0) break;
                this.loadCaratula();
                break;
            }
            case 55: {
                this.ecualizador();
                break;
            }
            case -11: {
                this.volver();
            }
        }
        this.pulsado = false;
    }

    private void cargarTipoFichero() {
        String ficheroSeleccionado = (String)this.dirList.elementAt(this.dirIndex);
        this.dirIndexIsAudio = this.isAudioFile(ficheroSeleccionado);
        this.dirIndexIsPhoto = this.isPhotoFile(ficheroSeleccionado);
        this.dirIndexIsDirectory = this.isDirectory(ficheroSeleccionado);
    }

    public void updateDirList(Enumeration e, boolean isRoot) {
        if (e == null) {
            return;
        }
        this.dirList.removeAllElements();
        this.visibleTopIndex = 0;
        this.visibleBottomIndex = this.visibleBottomIndex_START;
        this.dirIndex = 0;
        if (!isRoot) {
            this.dirList.addElement("..");
        } else {
            this.currentDir = "/";
        }
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!this.isDirectory(s) && !this.isAudioFile(s)) continue;
            this.dirList.addElement(s);
        }
        this.bubble(this.dirList);
        this.dirSize = this.dirList.size();
        this.fileSelected(ficheroActual);
        this.setCaratula();
        if (esPrimeraVez) {
            esPrimeraVez = false;
            if (this.dirIndexIsAudio && (directoryPlaying != null || playContinuo)) {
                this.loadAudio();
                return;
            }
        }
        if (directoryPlaying != null) {
            if (!directoryPlayNext) {
                directoryPlayNext = this.listaArriba();
                if (this.currentDir.equals(directoryPlaying) && this.dirIndex == 0) {
                    directoryPlaying = null;
                    this.traverse();
                    return;
                }
                this.listaArriba();
            }
            this.playDirectory();
        }
    }

    private void playDirectory() {
        boolean seguir = false;
        int cuantos = 0;
        if (directoryPlayNext) {
            while (!seguir && this.listaAbajo()) {
                ++cuantos;
                seguir = this.dirIndexIsAudio || this.dirIndexIsDirectory;
            }
        } else {
            while (!seguir && this.listaArriba()) {
                ++cuantos;
                seguir = this.dirIndexIsAudio || this.dirIndexIsDirectory;
            }
        }
        if (this.dirIndex > 0 && seguir) {
            directoryPlayNext = true;
            if (this.dirIndexIsAudio) {
                this.loadAudio();
            } else if (this.dirIndexIsDirectory) {
                this.traverse();
            }
        } else {
            this.dirIndex = 0;
            this.traverse();
        }
    }

    private void menuDelete() {
        if (modoActual == 4) {
            this.cancelDelete();
        } else {
            ficheroAEliminar = (String)this.dirList.elementAt(this.dirIndex);
            this.setModoAnterior();
            modoActual = 4;
        }
    }

    private void deleteFile() {
        String choosenFile;
        boolean parar = false;
        if (ficheroAEliminar.equals("..")) {
            choosenFile = "file://" + this.currentDir;
            this.traverse();
            parar = true;
        } else {
            choosenFile = "file://" + this.currentDir + ficheroAEliminar;
            String ficheroSeleccionado = (String)this.dirList.elementAt(this.dirIndex);
            parar = ficheroSeleccionado.equals(ficheroAEliminar);
        }
        if (parar) {
            if (modoAnterior == 1) {
                saliendo = true;
                this.stopAudio();
            } else if (modoAnterior == 2) {
                this.stopPhoto();
            }
        }
        this.fileThread = new FileThread(this, choosenFile);
        this.fileThread.start();
    }

    private void cancelDelete() {
        modoActual = modoAnterior;
    }

    public void fileDeleted() {
        this.dirList.removeElementAt(this.dirIndex);
        if (this.dirIndex >= this.dirList.size()) {
            --this.dirIndex;
        }
        this.dirSize = this.dirList.size();
        this.cargarTipoFichero();
        this.fileThread.close();
        this.fileThread = null;
        saliendo = false;
        if (modoAnterior == 1 && this.dirIndexIsAudio) {
            this.loadAudio();
        } else if (modoAnterior == 2 && this.dirIndexIsPhoto) {
            this.loadPhoto();
        } else {
            modoActual = 0;
        }
        modoAnterior = 0;
    }

    private void fileSelected(String fichero) {
        String ficheroSeleccionado = null;
        this.dirIndex = this.dirSize - 1;
        while (this.dirIndex > 0 && !(ficheroSeleccionado = (String)this.dirList.elementAt(this.dirIndex)).equalsIgnoreCase(fichero)) {
            --this.dirIndex;
        }
        if (this.dirIndex >= this.visibleBottomIndex_START) {
            this.visibleBottomIndex = this.dirIndex + 1;
            this.visibleTopIndex = this.visibleBottomIndex - this.visibleBottomIndex_START;
        }
        this.cargarTipoFichero();
    }

    private void traverse() {
        String choosenDir = (String)this.dirList.elementAt(this.dirIndex);
        if (choosenDir.equals("..")) {
            int i = this.currentDir.lastIndexOf(47, this.currentDir.length() - 2);
            if (i != -1) {
                ficheroActual = this.currentDir.substring(i + 1);
                this.currentDir = this.currentDir.substring(0, i + 1);
            } else {
                this.currentDir = "/";
                ficheroActual = "";
            }
            if (directoryPlaying != null && this.currentDir.length() < directoryPlaying.length()) {
                directoryPlaying = null;
            }
            new Thread(new Runnable(){

                public void run() {
                    FileBrowsingCanvas.this.fileAction.getDirContent(FileBrowsingCanvas.this.currentDir);
                }
            }).start();
        } else if (this.isDirectory(choosenDir)) {
            this.currentDir = this.currentDir + choosenDir;
            new Thread(new Runnable(){

                public void run() {
                    FileBrowsingCanvas.this.fileAction.getDirContent(FileBrowsingCanvas.this.currentDir);
                }
            }).start();
        }
    }

    private boolean listaArriba() {
        if (this.dirIndex == 0) {
            return false;
        }
        if (this.visibleTopIndex == 0) {
            --this.dirIndex;
        } else {
            --this.dirIndex;
            --this.visibleTopIndex;
            --this.visibleBottomIndex;
        }
        this.cargarTipoFichero();
        return true;
    }

    private boolean listaAbajo() {
        if (this.dirIndex >= this.dirList.size() - 1) {
            return false;
        }
        if (this.visibleBottomIndex > this.dirIndex + 1) {
            ++this.dirIndex;
        } else {
            ++this.dirIndex;
            ++this.visibleBottomIndex;
            ++this.visibleTopIndex;
        }
        this.cargarTipoFichero();
        return true;
    }

    private boolean isDirectory(String palabra) {
        return palabra.endsWith("/") || palabra.equals("..");
    }

    private boolean esMayor(String a2, String b) {
        boolean dirA = this.isDirectory(a2);
        boolean dirB = this.isDirectory(b);
        String palabraA = a2.toLowerCase();
        String palabraB = b.toLowerCase();
        if (a2.equals("..")) {
            return false;
        }
        if (b.equals("..")) {
            return true;
        }
        if (dirA && dirB || !dirA && !dirB) {
            return palabraA.compareTo(palabraB) > 0;
        }
        return dirB;
    }

    private void desplazarArriba(boolean arriba) {
        if (modoActual == 0) {
            this.dirIndex = arriba ? 0 : this.dirSize - 1;
            String ficheroActual = (String)this.dirList.elementAt(this.dirIndex);
            this.fileSelected(ficheroActual);
        }
    }

    private void loadAudio() {
        error = null;
        ficheroActual = (String)this.dirList.elementAt(this.dirIndex);
        String choosenAudio = "file://" + this.currentDir + ficheroActual;
        this.playerThread = null;
        System.gc();
        this.playerThread = new PlayerThread(this, choosenAudio);
        this.playerThread.start();
        this.playingAudio = true;
        pause = false;
        duracion = 0L;
        if (modoActual != 6 && modoActual != 7) {
            modoActual = 1;
        }
    }

    public void playerStarted() {
        VolumeControl vc = (VolumeControl)this.playerThread.player.getControl("VolumeControl");
        if (vc != null) {
            int cv = vc.getLevel();
            this.setVolume(vc, volumenActual);
        }
        duracion = this.playerThread.player.getDuration() / 1000000L;
        this.errorEq = "";
        try {
            this.effectModule = GlobalManager.createEffectModule();
            this.effectModule.addPlayer(this.playerThread.player);
        }
        catch (Exception e) {
            this.errorEq = e.getMessage();
        }
        if (this.effectModule != null) {
            this.equalizer = (EqualizerControl)this.effectModule.getControl("javax.microedition.amms.control.audioeffect.EqualizerControl");
            if (this.equalizer != null) {
                this.equalizer.setEnabled(true);
                this.equalizer.setBass(this.eqBass);
                this.equalizer.setTreble(this.eqTreble);
            }
        } else {
            this.equalizer = (EqualizerControl)this.playerThread.player.getControl("javax.microedition.media.control.audioeffect.EqualizerControl");
        }
    }

    private void stopAudio() {
        if (modoActual != 6 && modoActual != 7) {
            modoActual = 0;
        }
        this.playingAudio = false;
        this.playerThread.close();
        if (!this.playingAudio) {
            this.playerThread = null;
        }
        System.gc();
    }

    public void playerStopped() {
        if (!saliendo) {
            this.playingAudio = false;
            metaKeys = null;
            metaInfo = null;
            if (modoActual != 6 && modoActual != 7) {
                modoActual = 0;
            }
            if (directoryPlaying != null) {
                this.playDirectory();
            } else if (playContinuo) {
                if (this.listaAbajo()) {
                    if (this.dirIndexIsAudio) {
                        this.loadAudio();
                    } else if (this.dirIndexIsPhoto) {
                        this.loadPhoto();
                    }
                } else {
                    playContinuo = false;
                }
            }
        }
    }

    private void pauseAudio(boolean forzar) {
        if (forzar || !pause) {
            try {
                this.playerThread.player.stop();
            }
            catch (MediaException e) {
                // empty catch block
            }
            pause = true;
        } else {
            try {
                this.playerThread.player.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            pause = false;
        }
    }

    private void cambiarVolumen(int volumen) {
        this.changeVolume(volumen);
    }

    private int setVolume(VolumeControl vc, int vol) {
        if (vol == 0 || vol == 10) {
            if (vol == 10) {
                return vc.setLevel(0);
            }
            if (vol == 0) {
                return vc.setLevel(10);
            }
        } else {
            return vc.setLevel(vol);
        }
        return 0;
    }

    private void changeVolume(int vol) {
        if (this.volCounter + vol > 100 || this.volCounter + vol < 0) {
            return;
        }
        VolumeControl vc = (VolumeControl)this.playerThread.player.getControl("VolumeControl");
        if (vc != null) {
            this.volCounter += vol;
            this.setVolume(vc, this.volCounter);
            volumenActual = this.volCounter;
        }
    }

    public void setMetaDataControl(MetaDataControl mcd) {
        if (mcd == null) {
            return;
        }
        metaKeys = mcd.getKeys();
        metaInfo = new String[metaKeys.length];
        for (int i = 0; i < metaKeys.length; ++i) {
            FileBrowsingCanvas.metaInfo[i] = mcd.getKeyValue(metaKeys[i]);
        }
        this.box_Height = (metaKeys.length + 2) * this.font_small_Height;
    }

    public void playerError(String error) {
        FileBrowsingCanvas.error = error;
    }

    private boolean isAudioFile(String im) {
        int length = im.length() - 4;
        if (length < 1) {
            return false;
        }
        String s = im.substring(length);
        if (s.equalsIgnoreCase(".mp3")) {
            return true;
        }
        if (s.equalsIgnoreCase(".wav")) {
            return true;
        }
        if (s.equalsIgnoreCase(".mid")) {
            return true;
        }
        return s.equalsIgnoreCase(".amr");
    }

    private void ecualizador() {
        if (modoActual == 8) {
            modoActual = this.playingAudio ? 1 : 0;
        } else if (this.playingAudio) {
            modoActual = 8;
        }
    }

    private void modificarEcualizador(int opcion, int valor) {
        if (this.playingAudio && this.equalizer != null) {
            switch (opcion) {
                case 0: {
                    this.eqBass += valor;
                    if (this.eqBass > 100) {
                        this.eqBass = 100;
                        break;
                    }
                    if (this.eqBass >= 0) break;
                    this.eqBass = 0;
                    break;
                }
                case 1: {
                    this.eqTreble += valor;
                    if (this.eqTreble > 100) {
                        this.eqTreble = 100;
                        break;
                    }
                    if (this.eqTreble >= 0) break;
                    this.eqTreble = 0;
                    break;
                }
            }
            this.equalizer.setBass(this.eqBass);
            this.equalizer.setTreble(this.eqTreble);
        }
    }

    private void loadPhoto() {
        if (modoActual == 6) {
            this.stopPhoto();
        }
        modoActual = 3;
        error = null;
        ficheroActual = (String)this.dirList.elementAt(this.dirIndex);
        String choosenAudio = "file://" + this.currentDir + ficheroActual;
        this.photoThread = new PhotoThread(this, choosenAudio, this.WIDTH, this.HEIGHT - 2 * this.font_medium_Height);
        this.photoThread.start();
    }

    private void stopPhoto() {
        this.playingPhoto = false;
        this.imagenCargada = null;
        this.photoThread.close();
        this.photoThread = null;
        modoActual = modoActual == 6 ? (this.playingAudio ? 1 : 0) : 0;
    }

    public void photoStarted() {
        this.imagenCargada = this.photoThread.image;
        this.playingPhoto = true;
        modoActual = modoActual == 7 ? 6 : 2;
    }

    public void photoError(String error) {
        errorPhoto = error;
        this.playingPhoto = true;
        modoActual = modoActual == 7 ? 6 : 2;
    }

    private boolean isPhotoFile(String im) {
        return false;
    }

    private void setCaratula() {
        String fichero;
        if (this.dirSize > 0 && this.isPhotoFile(fichero = (String)this.dirList.elementAt(this.dirSize - 1))) {
            ficheroCaratula = "file://" + this.currentDir + fichero;
            UtilRMS.setData(UtilRMS.RMS_FICHERO_CARATULA, ficheroCaratula);
        }
    }

    private void loadCaratula() {
        if (modoActual == 6) {
            this.stopPhoto();
        } else if (ficheroCaratula != null && !ficheroCaratula.equals("")) {
            error = null;
            modoActual = 7;
            this.photoThread = new PhotoThread(this, ficheroCaratula, this.WIDTH, this.HEIGHT - 2 * this.font_medium_Height);
            this.photoThread.start();
        }
    }

    private void cambiarInfo() {
        if (modoActual == 5) {
            modoActual = modoAnterior;
        } else {
            this.setModoAnterior();
            modoActual = 5;
        }
    }

    private void setProperties() {
        String sVolumen;
        this.font_medium_Height = this.medium_Font.getHeight();
        this.font_small_Height = this.small_Font.getHeight();
        this.font_medium_Width = this.medium_Font.charWidth('w');
        this.font_small_Width = this.small_Font.charWidth('w');
        this.text_button_Width = this.font_medium_Width * 4;
        this.visibleTopIndex = 0;
        this.visibleBottomIndex = this.visibleBottomIndex_START = (this.HEIGHT - this.font_medium_Height * 4) / this.font_small_Height;
        this.currentDir = UtilRMS.getData(UtilRMS.RMS_RUTA_ACTUAL);
        if (this.currentDir == null || this.currentDir.length() < 1) {
            this.currentDir = "/";
        }
        volumenActual = (sVolumen = UtilRMS.getData(UtilRMS.RMS_VOLUMEN_ACTUAL)) == null || sVolumen.length() < 1 ? 50 : Integer.valueOf(sVolumen);
        this.volCounter = volumenActual;
        ficheroActual = UtilRMS.getData(UtilRMS.RMS_FICHERO_ACTUAL);
        directoryPlaying = UtilRMS.getData(UtilRMS.RMS_DIRECTORIO_PLAY);
        if (directoryPlaying != null && !"".equals(directoryPlaying)) {
            directoryPlayNext = true;
        } else {
            directoryPlaying = null;
        }
        String sContinuo = UtilRMS.getData(UtilRMS.RMS_REPRODUCE_CONTINUO);
        playContinuo = "S".equals(sContinuo);
        ficheroCaratula = UtilRMS.getData(UtilRMS.RMS_FICHERO_CARATULA);
        esPrimeraVez = true;
        modoActual = 0;
    }

    private void loadProgramImages() {
        try {
            this.folderImage = Image.createImage((String)"/res/folder.jpg");
            this.fileImage = Image.createImage((String)"/res/file.png");
            this.downArrowImage = Image.createImage((String)"/res/downArrow.png");
            this.upArrowImage = Image.createImage((String)"/res/upArrow.png");
            this.playImage = Image.createImage((String)"/res/play.png");
            this.pauseImage = Image.createImage((String)"/res/pause.png");
        }
        catch (Exception e) {
            System.out.println("LoadProgramImages:" + e.toString());
        }
    }

    public void guardarDatos() {
        UtilRMS.setData(UtilRMS.RMS_VOLUMEN_ACTUAL, volumenActual + "");
        if (ficheroActual != null && !"".equals(ficheroActual)) {
            UtilRMS.setData(UtilRMS.RMS_FICHERO_ACTUAL, ficheroActual);
        } else {
            UtilRMS.setData(UtilRMS.RMS_FICHERO_ACTUAL, "");
        }
        if (directoryPlaying != null && !"".equals(directoryPlaying)) {
            UtilRMS.setData(UtilRMS.RMS_DIRECTORIO_PLAY, directoryPlaying);
        } else {
            UtilRMS.setData(UtilRMS.RMS_DIRECTORIO_PLAY, "");
        }
        if (playContinuo) {
            UtilRMS.setData(UtilRMS.RMS_REPRODUCE_CONTINUO, "S");
        } else {
            UtilRMS.setData(UtilRMS.RMS_REPRODUCE_CONTINUO, "N");
        }
    }

    public void pause() {
        saliendo = true;
        this.guardarDatos();
        if (this.playerThread != null) {
            try {
                this.playerThread.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.photoThread != null) {
            try {
                this.photoThread.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stopped = true;
    }

    public void salir() {
        saliendo = true;
        this.guardarDatos();
        if (this.playerThread != null) {
            try {
                this.playerThread.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.photoThread != null) {
            try {
                this.photoThread.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stopped = true;
        this.midlet.destroyApp(false);
    }

    private void volver() {
        switch (modoActual) {
            case 1: {
                playContinuo = false;
                directoryPlaying = null;
                this.stopAudio();
                break;
            }
            case 0: {
                this.dirIndex = 0;
                this.traverse();
                break;
            }
            case 4: {
                this.cancelDelete();
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 2: 
            case 6: {
                this.stopPhoto();
                break;
            }
            case 5: {
                this.cambiarInfo();
            }
        }
    }

    private void setModoAnterior() {
        if (modoActual != 4 && modoActual != 5 && modoActual != 7 && modoActual != 3) {
            modoAnterior = modoActual;
        }
    }

    private void minimizar() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent(null);
    }

    private void bubble(Vector a2) {
        for (int i = 1; i < a2.size(); ++i) {
            for (int j = 0; j < a2.size() - 1; ++j) {
                if (!this.esMayor((String)a2.elementAt(j), (String)a2.elementAt(j + 1))) continue;
                Object temp = a2.elementAt(j);
                a2.setElementAt(a2.elementAt(j + 1), j);
                a2.setElementAt(temp, j + 1);
            }
        }
    }

    private String long2time(long tiempo) {
        long seg = 0L;
        long min = 0L;
        seg = tiempo % 60L;
        min = (tiempo - seg) / 60L;
        String sMin = "" + min;
        String sSeg = "" + seg;
        if (sMin.length() < 2) {
            sMin = "0" + sMin;
        }
        if (sSeg.length() < 2) {
            sSeg = "0" + sSeg;
        }
        return sMin + ":" + sSeg;
    }

    static {
        duracion = 0L;
        modoActual = 0;
        modoAnterior = 0;
    }
}

