/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PhotoThread
extends Thread {
    Image image = null;
    String fileName = null;
    PhotoThreadInvoker invoker = null;
    int width;
    int height;

    public PhotoThread(PhotoThreadInvoker invoker, String filename, int width, int height) {
        this.invoker = invoker;
        this.fileName = filename;
        this.width = width;
        this.height = height;
    }

    public void run() {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this.fileName);
            InputStream fis = fc.openInputStream();
            int length = (int)fc.fileSize();
            byte[] b = new byte[length];
            fis.read(b);
            fis.close();
            fc.close();
            this.image = this.scaleImage(Image.createImage((byte[])b, (int)0, (int)length));
            this.invoker.photoStarted();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            this.invoker.photoError(e.toString());
        }
    }

    public void close() {
        try {
            this.image = null;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public Image scaleImage(Image image) {
        double thumbHeight;
        int sourceHeight;
        double divH;
        double thumbWidth;
        int sourceWidth = image.getWidth();
        double divW = (double)sourceWidth / (thumbWidth = (double)this.width);
        double factor = divW > (divH = (double)(sourceHeight = image.getHeight()) / (thumbHeight = (double)this.height)) ? divW : divH;
        int smallWidth = (int)((double)sourceWidth / factor);
        int smallHeight = (int)((double)sourceHeight / factor);
        Image small = Image.createImage((int)smallWidth, (int)smallHeight);
        Graphics g = small.getGraphics();
        for (int y = 0; y < smallHeight; ++y) {
            for (int x = 0; x < smallWidth; ++x) {
                g.setClip(x, y, 1, 1);
                int dx = x * sourceWidth / smallWidth;
                int dy = y * sourceHeight / smallHeight;
                g.drawImage(image, x - dx, y - dy, 20);
            }
        }
        Image scaledDownImage = Image.createImage((Image)small);
        return scaledDownImage;
    }
}

