/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.StreamManipulator;
import multime.MultiME;

class OutputWindow {
    public int WINDOW_SIZE = 32768;
    public int WINDOW_MASK = this.WINDOW_SIZE - 1;
    public byte[] window = null;
    public int window_end = 0;
    public int window_filled = 0;

    OutputWindow() {
    }

    public void write(int n) {
        if (this.window_filled++ == this.WINDOW_SIZE) {
            throw new IllegalStateException("Window full");
        }
        this.window[this.window_end++] = (byte)n;
        this.window_end &= this.WINDOW_MASK;
    }

    public final void slowRepeat(int n, int n2, int n3) {
        while (n2-- > 0) {
            this.window[this.window_end++] = this.window[n++];
            this.window_end &= this.WINDOW_MASK;
            n &= this.WINDOW_MASK;
        }
    }

    public int copyStored(StreamManipulator streamManipulator, int n) {
        int n2;
        int n3;
        if ((n = Math.min(Math.min(n, this.WINDOW_SIZE - this.window_filled), streamManipulator.getAvailableBytes())) > (n3 = this.WINDOW_SIZE - this.window_end)) {
            n2 = streamManipulator.copyBytes(this.window, this.window_end, n3);
            if (n2 == n3) {
                n2 += streamManipulator.copyBytes(this.window, 0, n - n3);
            }
        } else {
            n2 = streamManipulator.copyBytes(this.window, this.window_end, n);
        }
        this.window_end = this.window_end + n2 & this.WINDOW_MASK;
        this.window_filled += n2;
        return n2;
    }

    public void copyDict(byte[] byArray, int n, int n2) {
        if (this.window_filled > 0) {
            throw new IllegalStateException();
        }
        if (n2 > this.WINDOW_SIZE) {
            n += n2 - this.WINDOW_SIZE;
            n2 = this.WINDOW_SIZE;
        }
        System.arraycopy(byArray, n, this.window, 0, n2);
        this.window_end = n2 & this.WINDOW_MASK;
    }

    public int getFreeSpace() {
        return this.WINDOW_SIZE - this.window_filled;
    }

    public int getAvailable() {
        return this.window_filled;
    }

    public int copyOutput(byte[] byArray, int n, int n2) {
        int n3 = this.window_end;
        if (n2 > this.window_filled) {
            n2 = this.window_filled;
        } else {
            n3 = this.window_end - this.window_filled + n2 & this.WINDOW_MASK;
        }
        int n4 = n2;
        int n5 = n2 - n3;
        if (n5 > 0) {
            System.arraycopy(this.window, this.WINDOW_SIZE - n5, byArray, n, n5);
            n += n5;
            n2 = n3;
        }
        System.arraycopy(this.window, n3 - n2, byArray, n, n2);
        this.window_filled -= n4;
        if (this.window_filled < 0) {
            throw new IllegalStateException();
        }
        return n4;
    }

    public void reset() {
        this.window_end = 0;
        this.window_filled = 0;
    }

    static {
        MultiME.classLoaded("jazzlib.OutputWindow");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("jazzlib.OutputWindow");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

