/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.TiledLayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import multime.MultiME;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private static final int INVERTED_AXES = 4;
    private static final int X_FLIP = 2;
    private static final int Y_FLIP = 1;
    private static final int ALPHA_BITMASK = -16777216;
    Image sourceImage;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int dRefX;
    int dRefY;
    int collisionRectX;
    int collisionRectY;
    int collisionRectWidth;
    int collisionRectHeight;
    int t_currentTransformation;

    public Sprite(Image image) {
        super(image.getWidth(), image.getHeight());
        this.initializeFrames(image, image.getWidth(), image.getHeight(), false);
        this.initCollisionRectBounds();
    }

    public Sprite(Image image, int n, int n2) {
        super(n, n2);
        if (n < 1 || n2 < 1 || image.getWidth() % n != 0 || image.getHeight() % n2 != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(image, n, n2, false);
        this.initCollisionRectBounds();
    }

    public Sprite(Sprite sprite) {
        super(sprite == null ? 0 : sprite.getWidth(), sprite == null ? 0 : sprite.getHeight());
        if (sprite == null) {
            throw new NullPointerException();
        }
        this.sourceImage = Image.createImage((Image)sprite.sourceImage);
        this.numberFrames = sprite.numberFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        System.arraycopy(sprite.frameCoordsX, 0, this.frameCoordsX, 0, sprite.getRawFrameCount());
        System.arraycopy(sprite.frameCoordsY, 0, this.frameCoordsY, 0, sprite.getRawFrameCount());
        this.x = sprite.getX();
        this.y = sprite.getY();
        this.dRefX = sprite.dRefX;
        this.dRefY = sprite.dRefY;
        this.collisionRectX = sprite.collisionRectX;
        this.collisionRectY = sprite.collisionRectY;
        this.collisionRectWidth = sprite.collisionRectWidth;
        this.collisionRectHeight = sprite.collisionRectHeight;
        this.srcFrameWidth = sprite.srcFrameWidth;
        this.srcFrameHeight = sprite.srcFrameHeight;
        this.setVisible(sprite.isVisible());
        this.frameSequence = new int[sprite.getFrameSequenceLength()];
        this.setFrameSequence(sprite.frameSequence);
        this.setFrame(sprite.getFrame());
        this.setRefPixelPosition(sprite.getRefPixelX(), sprite.getRefPixelY());
    }

    public void defineReferencePixel(int n, int n2) {
        this.dRefX = n;
        this.dRefY = n2;
    }

    public void setRefPixelPosition(int n, int n2) {
        this.x = n - this.dRefX;
        this.y = n2 - this.dRefY;
    }

    public int getRefPixelX() {
        return this.x + this.dRefX;
    }

    public int getRefPixelY() {
        return this.y + this.dRefY;
    }

    public void setFrame(int n) {
        if (n < 0 || n >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = n;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getRawFrameCount() {
        return this.numberFrames;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    public final void paint(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int n = graphics.getClipX();
            int n2 = graphics.getClipY();
            int n3 = graphics.getClipWidth();
            int n4 = graphics.getClipHeight();
            graphics.setClip(this.x, this.y, this.srcFrameWidth, this.srcFrameHeight);
            graphics.drawImage(this.sourceImage, this.x - this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.y - this.frameCoordsY[this.frameSequence[this.sequenceIndex]], 20);
            graphics.setClip(n, n2, n3, n4);
        }
    }

    public void setFrameSequence(int[] nArray) {
        if (nArray == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i2 = 0; i2 < this.numberFrames; ++i2) {
                this.frameSequence[i2] = i2;
            }
            return;
        }
        if (nArray.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            if (nArray[i3] >= 0 && nArray[i3] < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[nArray.length];
        System.arraycopy(nArray, 0, this.frameSequence, 0, nArray.length);
        this.sequenceIndex = 0;
    }

    public void setImage(Image image, int n, int n2) {
        if (n < 1 || n2 < 1 || image.getWidth() % n != 0 || image.getHeight() % n2 != 0) {
            throw new IllegalArgumentException();
        }
        int n3 = image.getWidth() / n * (image.getHeight() / n2);
        boolean bl = true;
        if (n3 < this.numberFrames) {
            bl = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != n || this.srcFrameHeight != n2) {
            int n4 = this.x + this.dRefX;
            int n5 = this.y + this.dRefY;
            this.setWidthImpl(n);
            this.setHeightImpl(n2);
            this.initializeFrames(image, n, n2, bl);
            this.initCollisionRectBounds();
            this.x = n4 - this.dRefX;
            this.y = n5 - this.dRefY;
        } else {
            this.initializeFrames(image, n, n2, bl);
        }
    }

    public void defineCollisionRectangle(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException();
        }
        this.collisionRectX = n;
        this.collisionRectY = n2;
        this.collisionRectWidth = n3;
        this.collisionRectHeight = n4;
    }

    public void setTransform(int n) {
    }

    public final boolean collidesWith(Sprite sprite, boolean bl) {
        if (!sprite.visible || !this.visible) {
            return false;
        }
        int n = sprite.x + sprite.collisionRectX;
        int n2 = sprite.y + sprite.collisionRectY;
        int n3 = n + sprite.collisionRectWidth;
        int n4 = n2 + sprite.collisionRectHeight;
        int n5 = this.x + this.collisionRectX;
        int n6 = this.y + this.collisionRectY;
        int n7 = n5 + this.collisionRectWidth;
        int n8 = n6 + this.collisionRectHeight;
        return this.intersectRect(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public final boolean collidesWith(TiledLayer tiledLayer, boolean bl) {
        if (!tiledLayer.visible || !this.visible) {
            return false;
        }
        int n = tiledLayer.x;
        int n2 = tiledLayer.y;
        int n3 = n + tiledLayer.width;
        int n4 = n2 + tiledLayer.height;
        int n5 = tiledLayer.cellWidth;
        int n6 = tiledLayer.cellHeight;
        int n7 = this.x + this.collisionRectX;
        int n8 = this.y + this.collisionRectY;
        int n9 = n7 + this.collisionRectWidth;
        int n10 = n8 + this.collisionRectHeight;
        int n11 = tiledLayer.columns;
        int n12 = tiledLayer.rows;
        if (!this.intersectRect(n, n2, n3, n4, n7, n8, n9, n10)) {
            return false;
        }
        int n13 = n7 > n ? (n7 - n) / n5 : 0;
        int n14 = n8 > n2 ? (n8 - n2) / n6 : 0;
        int n15 = n9 >= n3 ? n11 - 1 : (n9 - 1 - n) / n5;
        int n16 = n10 >= n4 ? n12 - 1 : (n10 - 1 - n2) / n6;
        for (int i2 = n14; i2 <= n16; ++i2) {
            for (int i3 = n13; i3 <= n15; ++i3) {
                if (tiledLayer.cellMatrix[i2][i3] == 0) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean collidesWith(Image image, int n, int n2, boolean bl) {
        if (!this.visible) {
            return false;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = n + image.getWidth();
        int n6 = n2 + image.getHeight();
        int n7 = this.x + this.collisionRectX;
        int n8 = this.y + this.collisionRectY;
        int n9 = n7 + this.collisionRectWidth;
        int n10 = n8 + this.collisionRectHeight;
        return this.intersectRect(n3, n4, n5, n6, n7, n8, n9, n10);
    }

    private void initializeFrames(Image image, int n, int n2, boolean bl) {
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int n5 = n3 / n;
        int n6 = n4 / n2;
        this.sourceImage = image;
        this.srcFrameWidth = n;
        this.srcFrameHeight = n2;
        this.numberFrames = n5 * n6;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!bl) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int n7 = 0;
        for (int i2 = 0; i2 < n4; i2 += n2) {
            for (int i3 = 0; i3 < n3; i3 += n) {
                this.frameCoordsX[n7] = i3;
                this.frameCoordsY[n7] = i2;
                if (!this.customSequenceDefined) {
                    this.frameSequence[n7] = n7;
                }
                ++n7;
            }
        }
    }

    private void initCollisionRectBounds() {
        this.collisionRectX = 0;
        this.collisionRectY = 0;
        this.collisionRectWidth = this.width;
        this.collisionRectHeight = this.height;
    }

    private boolean intersectRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n5 < n3 && n6 < n4 && n7 > n && n8 > n2;
    }

    static {
        MultiME.classLoaded("com.siemens.mp.color_game.Sprite");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("com.siemens.mp.color_game.Sprite");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

