/*
 * Decompiled with CFR 0.152.
 */
package motorola.xdict;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import motorola.xdict.ExplainScreen;

class ReferList
extends Canvas {
    public static final int DISABLE_FLAG = 0;
    public static final int NORMAL_FLAG = 1;
    public static final int HIDE_FLAG = -1;
    private int pageupFlag = 0;
    private int pagedownFlag = 0;
    private int screenWidth;
    private int screenHeight;
    private final int screenLeft;
    private Font font;
    private int fontHeight;
    private int titleHeight;
    private int charWidth;
    private int listNum;
    private CommandListener cl;
    private Command pressedCmd;
    private Command pageupCmd;
    private Command pagedownCmd;
    private Vector vect;
    private int nSelected = -1;
    public int prevFlag = -1;
    private int buttonHeight;
    private int buttonWidth;

    ReferList(CommandListener cl, Command pressedCmd, Command pageupCmd, Command pagedownCmd) {
        this.screenLeft = 3;
        this.cl = cl;
        this.pressedCmd = pressedCmd;
        this.pageupCmd = pageupCmd;
        this.pagedownCmd = pagedownCmd;
        this.vect = new Vector();
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.font = Font.getDefaultFont();
        this.fontHeight = this.font.getHeight();
        this.titleHeight = ExplainScreen.titleImage.getHeight();
        this.buttonHeight = ExplainScreen.imageButton[0].getHeight();
        this.buttonWidth = ExplainScreen.imageButton[0].getHeight();
        try {
            this.listNum = (this.screenHeight - this.titleHeight) / this.fontHeight;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.prevFlag = 1;
        this.deleteList();
    }

    public int getListNum() {
        return this.listNum;
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.setColor(0);
        g.drawImage(ExplainScreen.titleImage, 0, 0, 20);
        if (this.vect.elementAt(this.listNum - 1).toString().length() == 0) {
            System.out.println("after vect.elementAt");
            this.pagedownFlag = -1;
        } else if (this.pagedownFlag == -1) {
            this.pagedownFlag = 0;
        }
        if (this.prevFlag == 0) {
            this.pageupFlag = -1;
        } else if (this.prevFlag == 1 && this.pageupFlag == -1) {
            this.pageupFlag = 0;
        }
        if (this.prevFlag != -1) {
            g.drawImage(this.getButtonImage(this.pageupFlag, 0), this.screenWidth - this.buttonWidth, this.titleHeight, 20);
            g.drawImage(this.getButtonImage(this.pagedownFlag, 3), this.screenWidth - this.buttonWidth, this.screenHeight - this.buttonHeight, 20);
        }
        if (this.vect != null) {
            int size = this.vect.size();
            int i = 0;
            while (i < size) {
                this.drawList(g, this.vect.elementAt(i).toString(), i);
                ++i;
            }
        }
        System.out.println("size = " + this.vect.size());
    }

    private Image getButtonImage(int flag, int normal) {
        if (flag == 0) {
            return ExplainScreen.imageButton[6 + normal];
        }
        if (flag == 1) {
            return ExplainScreen.imageButton[6 + normal + 1];
        }
        return ExplainScreen.imageButton[6 + normal + 2];
    }

    public void pointerPressed(int x, int y) {
        if (y < this.titleHeight) {
            return;
        }
        if (x > this.screenWidth - this.buttonWidth && x < this.screenWidth) {
            if (y > this.titleHeight && y < this.buttonHeight + this.titleHeight && this.pageupFlag != -1) {
                this.pageupFlag = 1;
            } else if (y > this.screenHeight - this.buttonHeight && y < this.screenHeight && this.pagedownFlag != -1) {
                this.pagedownFlag = 1;
            }
        }
        if (x < this.screenWidth - this.buttonWidth && y > this.titleHeight && y < this.screenHeight) {
            int i = 0;
            while (i < this.listNum) {
                if (y > i * this.fontHeight + this.titleHeight && y < (i + 1) * this.fontHeight + this.titleHeight) {
                    if (this.vect.elementAt(i).toString() == "") {
                        return;
                    }
                    this.nSelected = i;
                    this.repaint(0, i * this.fontHeight + this.titleHeight, this.screenWidth - this.buttonWidth, this.fontHeight);
                    return;
                }
                ++i;
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    protected void pointerReleased(int x, int y) {
        this.repaintButtonImage();
        if (this.nSelected != -1) {
            this.cl.commandAction(this.pressedCmd, (Displayable)this);
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        if (this.vect.elementAt(this.nSelected).toString().length() != 0 || this.vect.elementAt(this.nSelected).toString() != null) {
            return this.nSelected;
        }
        return -1;
    }

    public void setSelectedIndex(int index, boolean flag) {
        if (flag) {
            this.nSelected = index;
        }
    }

    public int size() {
        int i = 0;
        i = 0;
        while (i < this.listNum) {
            if (this.vect.elementAt(i).toString().length() == 0) break;
            ++i;
        }
        return i;
    }

    public void deleteList() {
        if (this.vect != null) {
            this.vect.removeAllElements();
        }
    }

    public void resetList() {
        this.deleteList();
        int i = 0;
        while (i < this.listNum) {
            this.append("");
            ++i;
        }
    }

    private void drawList(Graphics g, String strList, int index) {
        if (index == this.nSelected) {
            g.setColor(128, 128, 128);
            g.fillRect(0, index * this.fontHeight + this.titleHeight, this.screenWidth - this.buttonWidth, this.fontHeight);
        } else {
            g.setColor(255, 255, 255);
            g.fillRect(0, index * this.fontHeight + this.titleHeight, this.screenWidth - this.buttonWidth, this.fontHeight);
        }
        g.setColor(0);
        g.drawString(strList, 3, index * this.fontHeight + this.titleHeight, 20);
        System.out.println(strList);
    }

    public void append(String str) {
        this.vect.addElement(str);
    }

    protected void keyPressed(int key) {
        switch (this.getGameAction(key)) {
            case 1: {
                if (this.pageupFlag == -1) {
                    return;
                }
                this.pageupFlag = 1;
                break;
            }
            case 6: {
                if (this.pagedownFlag == -1) {
                    return;
                }
                this.pagedownFlag = 1;
                break;
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    protected void keyReleased(int key) {
        this.repaintButtonImage();
        if (this.nSelected != -1) {
            this.cl.commandAction(this.pressedCmd, (Displayable)this);
        }
        this.repaint();
    }

    public void repaintScreen() {
        this.repaint();
        this.serviceRepaints();
    }

    private void repaintButtonImage() {
        if (this.pageupFlag == 1) {
            this.pageupFlag = 0;
            this.repaint(this.screenWidth - this.buttonWidth, this.titleHeight, this.buttonWidth, this.buttonHeight);
            this.cl.commandAction(this.pageupCmd, (Displayable)this);
        } else if (this.pagedownFlag == 1) {
            this.pagedownFlag = 0;
            this.repaint(this.screenWidth - this.buttonWidth, this.screenHeight - this.buttonHeight, this.buttonWidth, this.buttonHeight);
            this.cl.commandAction(this.pagedownCmd, (Displayable)this);
        }
    }
}

