/*
 * Decompiled with CFR 0.152.
 */
package motorola.xdict;

class KByteStream {
    public static char[] toCharArray(byte[] byaTemp, int nOff, int nLen) {
        int nSourceLen = byaTemp.length;
        if (nSourceLen < nOff + nLen) {
            return null;
        }
        char[] chaRes = new char[nLen / 2 + nLen % 2];
        int i = 0;
        while (i < nLen) {
            int nTemp;
            if (i % 2 == 0) {
                chaRes[i / 2] = '\u0000';
            }
            if (i % 2 == 0 && i == nLen - 1) {
                nTemp = byaTemp[nOff + i];
                int n = i / 2;
                chaRes[n] = (char)(chaRes[n] | (nTemp &= 0xFF));
            } else {
                chaRes[i / 2] = (char)(chaRes[i / 2] << 8);
                nTemp = byaTemp[nOff + i + (i % 2 == 0 ? 1 : -1)];
                int n = i / 2;
                chaRes[n] = (char)(chaRes[n] | (nTemp &= 0xFF));
            }
            ++i;
        }
        return chaRes;
    }

    public static int toInt(byte[] byaTemp, int nOff, int nLen) {
        if (nLen > 4) {
            nLen = 4;
        }
        if (byaTemp.length < nOff + nLen) {
            return -1;
        }
        int nRes = 0;
        int i = 0;
        while (i < nLen) {
            nRes <<= 8;
            int nTemp = byaTemp[nOff + nLen - 1 - i];
            nRes |= (nTemp &= 0xFF);
            ++i;
        }
        return nRes;
    }

    public static short toShort(byte[] byaTemp, int nOff, int nLen) {
        if (nLen > 2) {
            nLen = 2;
        }
        if (byaTemp.length < nOff + nLen) {
            return -1;
        }
        short sRes = 0;
        int i = 0;
        while (i < nLen) {
            sRes = (short)(sRes << 8);
            int nTemp = byaTemp[nOff + nLen - 1 - i];
            sRes = (short)(sRes | (nTemp &= 0xFF));
            ++i;
        }
        return sRes;
    }

    public static char toChar(byte[] byaTemp, int nOff, int nLen) {
        if (nLen > 2) {
            nLen = -1;
        }
        if (byaTemp.length < nOff + nLen) {
            return '\u0000';
        }
        char chRes = '\u0000';
        int i = 0;
        while (i < nLen) {
            chRes = (char)(chRes << 8);
            int nTemp = byaTemp[nOff + nLen - 1 - i];
            chRes = (char)(chRes | (nTemp &= 0xFF));
            ++i;
        }
        return chRes;
    }

    public static char[] toCharArray(byte[] byaTemp, int nOff) {
        int nSourceLen = byaTemp.length;
        int nLen = nSourceLen - nOff;
        if ((nLen -= nLen % 2) <= 0) {
            return null;
        }
        int i = 0;
        while (i < nLen) {
            if (byaTemp[nOff + i] == 0 && byaTemp[nOff + i + 1] == 0) break;
            i += 2;
        }
        nLen = i;
        char[] chaRes = new char[nLen / 2 + nLen % 2];
        i = 0;
        while (i < nLen) {
            int nTemp;
            if (i % 2 == 0) {
                chaRes[i / 2] = '\u0000';
            }
            if (i % 2 == 0 && i == nLen - 1) {
                nTemp = byaTemp[nOff + i];
                int n = i / 2;
                chaRes[n] = (char)(chaRes[n] | (nTemp &= 0xFF));
            } else {
                chaRes[i / 2] = (char)(chaRes[i / 2] << 8);
                nTemp = byaTemp[nOff + i + (i % 2 == 0 ? 1 : -1)];
                int n = i / 2;
                chaRes[n] = (char)(chaRes[n] | (nTemp &= 0xFF));
            }
            ++i;
        }
        return chaRes;
    }

    public static char[] findPrevWord(byte[] byaTemp, int nOff) {
        int nTemp;
        int nSourceLen = byaTemp.length;
        if (nOff <= 4) {
            return null;
        }
        int nLen = nSourceLen - (nOff -= 4);
        nLen -= nLen % 2;
        if (nLen <= 0 && (nOff = nLen - 2) < 0) {
            return null;
        }
        int nEnd = -1;
        int nStart = -1;
        if (nOff % 2 != 0) {
            --nOff;
        }
        boolean bTemp = true;
        int i = nOff;
        while (i >= 0) {
            nTemp = (byaTemp[i] & 0xFF) + (byaTemp[i + 1] & 0xFF) * 256;
            if (nTemp >= 0 && nTemp < 32 && nEnd != -1 && bTemp) {
                nStart = i + 2;
                break;
            }
            if (byaTemp[i] == 0 && byaTemp[i + 1] == 0 && nEnd == -1) {
                nEnd = i;
            }
            i -= 2;
        }
        if (nEnd == -1 || nStart == -1) {
            return null;
        }
        nLen = nEnd - nStart;
        char[] chaRes = new char[nLen / 2 + nLen % 2];
        i = 0;
        while (i < nLen) {
            if (i % 2 == 0) {
                chaRes[i / 2] = '\u0000';
            }
            if (i % 2 == 0 && i == nLen - 1) {
                nTemp = byaTemp[nStart + i];
                int n = i / 2;
                chaRes[n] = (char)(chaRes[n] | (nTemp &= 0xFF));
            } else {
                chaRes[i / 2] = (char)(chaRes[i / 2] << 8);
                nTemp = byaTemp[nStart + i + (i % 2 == 0 ? 1 : -1)];
                int n = i / 2;
                chaRes[n] = (char)(chaRes[n] | (nTemp &= 0xFF));
            }
            ++i;
        }
        return chaRes;
    }

    KByteStream() {
    }
}

