/*
 * Decompiled with CFR 0.152.
 */
package motorola.xdict;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import motorola.xdict.KViewInfo;
import motorola.xdict.WordLine;

class ExplainScreen
extends Canvas {
    private static char[] phonetic = new char[]{'(', ')', ',', '-', '.', '/', '4', '5', '7', '9', ':', ';', '?', '@', 'A', 'B', 'C', 'E', 'F', 'I', 'J', 'K', 'N', 'P', 'Q', 'R', 'T', 'U', 'V', 'W', 'Z', '[', '\\', '^', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static Image[] phonetImage;
    public static Image[] imageButton;
    private static Image referImage;
    public static Image titleImage;
    private WordLine wordLine;
    private int fontHeight;
    private int en_fontWidth;
    private int cn_fontWidth;
    private Font font = null;
    private Font referTitleFont = null;
    private Font referFont = null;
    public static final int SCREEN_LEFT = 5;
    private static final int LINECHAR_NUM = 60;
    public static final int BUTTON_DISABLE = -1;
    public static final int BUTTON_NORMAL = 0;
    public static final int BUTTON_PRESSED = 1;
    private final String REFER_INFO_TONG;
    private final String REFER_INFO_FAN;
    private int lineupFlag = 0;
    private int linedownFlag = 0;
    private int pageupFlag = 0;
    private int pagedownFlag = 0;
    private int screenWidth;
    private int screenHeight;
    private int nTong = 0;
    private int nFan = 0;
    private int nENExplain = 0;
    private int nCNExplain = 0;
    private KViewInfo[] viewInfo;
    private int viewInfoSize = 0;
    private int viewPoint = 0;
    private Command pointerCmd;
    private CommandListener cl;
    private int g_langFlag;
    private String g_getString;
    private int langF;
    private boolean isPhonet = false;
    private int LINE_NUM;
    private boolean bSelected;
    private int selectX;
    private int selectY;
    private int selectWidth;
    private int titleHeight;
    private int buttonHeight;
    private int buttonWidth;
    private int phoneHeight;
    private int headHeight;
    private int tabWidth;
    private int realLines = -1;

    public static void InitPhoneImage() {
        int len = phonetic.length;
        try {
            phonetImage = new Image[len];
            int i = 0;
            while (i < len) {
                ExplainScreen.phonetImage[i] = Image.createImage((String)("/phonetic/" + (i + 1) + ".PNG"));
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            imageButton = new Image[12];
            ExplainScreen.imageButton[0] = Image.createImage((String)"/button/lineup.PNG");
            ExplainScreen.imageButton[1] = Image.createImage((String)"/button/presslineup.PNG");
            ExplainScreen.imageButton[2] = Image.createImage((String)"/button/unlineup.PNG");
            ExplainScreen.imageButton[3] = Image.createImage((String)"/button/linedown.PNG");
            ExplainScreen.imageButton[4] = Image.createImage((String)"/button/presslinedown.PNG");
            ExplainScreen.imageButton[5] = Image.createImage((String)"/button/unlinedown.PNG");
            ExplainScreen.imageButton[6] = Image.createImage((String)"/button/pageup.PNG");
            ExplainScreen.imageButton[7] = Image.createImage((String)"/button/presspageup.PNG");
            ExplainScreen.imageButton[8] = Image.createImage((String)"/button/unpageup.PNG");
            ExplainScreen.imageButton[9] = Image.createImage((String)"/button/pagedown.PNG");
            ExplainScreen.imageButton[10] = Image.createImage((String)"/button/presspagedown.PNG");
            ExplainScreen.imageButton[11] = Image.createImage((String)"/button/unpagedown.PNG");
            titleImage = Image.createImage((String)"/icons/title.png");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    ExplainScreen(CommandListener cl, Command pointerCmd, WordLine wordLine, Command cmd1, Command cmd2, Command cmd3, Command cmd4, String strPrev) {
        this.REFER_INFO_TONG = "\u540c\u4e49\u8bcd:";
        this.REFER_INFO_FAN = "\u53cd\u4e49\u8bcd:";
        this.cl = cl;
        this.pointerCmd = pointerCmd;
        this.wordLine = wordLine;
        this.addCommand(cmd1);
        this.addCommand(cmd2);
        if (strPrev != null) {
            this.addCommand(cmd3);
        }
        this.addCommand(cmd4);
        this.viewInfo = new KViewInfo[60];
        this.langF = 1;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.font = Font.getDefaultFont();
        this.en_fontWidth = this.font.charWidth('a');
        this.cn_fontWidth = this.font.charWidth('\u4e00');
        this.fontHeight = this.font.getHeight();
        this.referFont = Font.getFont((int)this.font.getFace(), (int)4, (int)this.font.getSize());
        this.referTitleFont = Font.getFont((int)32, (int)1, (int)0);
        this.buttonWidth = imageButton[0].getWidth();
        this.viewInfoSize = this.filterExplain(wordLine.explain);
        if (this.viewInfoSize < 1) {
            System.out.println("explain is null");
            return;
        }
        this.titleHeight = titleImage.getHeight();
        if (wordLine.phone.length() > 0) {
            this.isPhonet = true;
            this.phoneHeight = phonetImage[0].getHeight();
        } else {
            this.phoneHeight = 0;
        }
        if (this.viewInfoSize > (this.screenHeight - this.titleHeight - this.fontHeight - this.phoneHeight) / this.fontHeight) {
            this.buttonHeight = imageButton[0].getHeight();
            this.buttonWidth = imageButton[0].getWidth();
        } else {
            this.buttonHeight = 0;
            this.buttonWidth = 0;
        }
        this.headHeight = this.titleHeight + this.phoneHeight + this.fontHeight;
        this.LINE_NUM = (this.screenHeight - this.headHeight) / this.fontHeight;
        this.tabWidth = (this.screenWidth - this.buttonWidth - 5) / 2;
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.setColor(0);
        this.drawTitle(g);
        g.setColor(188, 73, 18);
        g.drawString(this.wordLine.word, 5, this.titleHeight, 20);
        if (this.isPhonet) {
            this.drawImagePhone(g, this.wordLine.phone);
        }
        g.setClip(0, this.headHeight, this.screenWidth, this.screenHeight - this.headHeight);
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.bSelected) {
            g.setColor(128, 128, 128);
            g.fillRect(this.selectX, this.selectY, this.selectWidth, this.fontHeight);
            this.bSelected = false;
        }
        g.setColor(0);
        this.drawExplain(g, this.wordLine.explain);
        g.setClip(0, 0, this.screenWidth, this.screenHeight);
        if (this.viewPoint == 0) {
            this.lineupFlag = -1;
            if (this.linedownFlag == -1) {
                this.linedownFlag = 0;
            }
            this.pageupFlag = -1;
            if (this.pagedownFlag == -1) {
                this.pagedownFlag = 0;
            }
        } else if (this.viewPoint <= -1 * (this.realLines + 1 - this.LINE_NUM) * this.fontHeight) {
            this.linedownFlag = -1;
            if (this.lineupFlag == -1) {
                this.lineupFlag = 0;
            }
            this.pagedownFlag = -1;
            if (this.pageupFlag == -1) {
                this.pageupFlag = 0;
            }
        } else {
            if (this.lineupFlag == -1) {
                this.lineupFlag = 0;
            }
            if (this.linedownFlag == -1) {
                this.linedownFlag = 0;
            }
            if (this.pageupFlag == -1) {
                this.pageupFlag = 0;
            }
            if (this.pagedownFlag == -1) {
                this.pagedownFlag = 0;
            }
        }
        if (this.realLines + 1 > (this.screenHeight - this.titleHeight - this.phoneHeight - this.fontHeight) / this.fontHeight) {
            g.drawImage(this.getButtonImage(this.pageupFlag, 6), this.screenWidth - this.buttonWidth, this.titleHeight, 20);
            g.drawImage(this.getButtonImage(this.pagedownFlag, 9), this.screenWidth - this.buttonWidth, this.screenHeight - this.buttonHeight, 20);
            g.drawImage(this.getButtonImage(this.lineupFlag, 0), this.screenWidth - this.buttonWidth, this.titleHeight + this.buttonHeight, 20);
            g.drawImage(this.getButtonImage(this.linedownFlag, 3), this.screenWidth - this.buttonWidth, this.screenHeight - 2 * this.buttonHeight, 20);
        }
    }

    private void drawTitle(Graphics g) {
        g.drawImage(titleImage, 0, 0, 20);
    }

    private Image getButtonImage(int flag, int normal) {
        if (flag == 0) {
            return imageButton[normal];
        }
        if (flag == 1) {
            return imageButton[normal + 1];
        }
        return imageButton[normal + 2];
    }

    private void drawImagePhone(Graphics g, String strPhone) {
        try {
            strPhone = "/" + strPhone + "/";
            int wordLen = strPhone.length();
            int phonetLen = phonetic.length;
            int width = 5;
            int i = 0;
            while (i < wordLen) {
                char getChar = strPhone.charAt(i);
                int j = 0;
                while (j < phonetLen) {
                    if (getChar == phonetic[j]) {
                        g.drawImage(phonetImage[j], width, this.titleHeight + this.fontHeight, 20);
                        width += phonetImage[j].getWidth();
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private int filterExplain(String explain) {
        int i = 0;
        int j = 0;
        boolean flag = false;
        int n = 0;
        this.viewInfo[n] = new KViewInfo();
        this.viewInfo[n].nStart = 0;
        boolean nGet = false;
        if (this.isAlpha(this.wordLine.word.charAt(0))) {
            this.langF = 0;
        }
        int fontWidth = 0;
        int lineWidth = 0;
        boolean bFrank = false;
        if (explain.charAt(explain.length() - 1) == ';') {
            explain = explain.substring(0, explain.length() - 1);
        }
        int nTongStart = explain.length();
        int nFanStart = explain.length();
        while (i < explain.length()) {
            fontWidth = this.font.charWidth(explain.charAt(i));
            if (bFrank) {
                j = 0;
                bFrank = false;
            }
            lineWidth += fontWidth;
            if (explain.charAt(i) == '\n' || explain.charAt(i) == ';' && (i > nTongStart || i > nFanStart || this.langF == 1)) {
                this.viewInfo[n].nEnd = i;
                this.viewInfo[n].nWidth = lineWidth - fontWidth;
                lineWidth = 0;
                this.viewInfo[++n] = new KViewInfo();
                if (explain.charAt(i + 1) == ' ') {
                    this.viewInfo[n].nStart = i + 2;
                    bFrank = true;
                } else {
                    this.viewInfo[n].nStart = i + 1;
                }
                flag = true;
            }
            if (explain.charAt(i) == '>' && explain.charAt(i - 1) == '\n') {
                this.nTong = n++;
                nGet = true;
                lineWidth -= fontWidth;
                flag = true;
                this.viewInfo[n] = new KViewInfo();
                this.viewInfo[n].nStart = this.viewInfo[n - 1].nStart;
                ++this.viewInfo[n].nStart;
                nTongStart = i;
            }
            if (explain.charAt(i) == '<' && explain.charAt(i - 1) == '\n') {
                this.nFan = n++;
                nGet = true;
                lineWidth -= fontWidth;
                flag = true;
                this.viewInfo[n] = new KViewInfo();
                this.viewInfo[n].nStart = i + 1;
                nFanStart = i;
            }
            if (explain.charAt(i) == '%' || explain.charAt(i) == '\\') {
                ++this.viewInfo[n].nStart;
                lineWidth -= fontWidth;
                flag = true;
            }
            if (explain.charAt(i) == '*' && explain.charAt(i - 1) == '\n') {
                this.nENExplain = n;
                ++this.viewInfo[n].nStart;
            }
            if (explain.charAt(i) == '|' && explain.charAt(i - 1) == '\n') {
                this.nCNExplain = n;
                ++this.viewInfo[n].nStart;
            }
            if (lineWidth >= this.screenWidth - this.buttonWidth && !nGet && this.langF == 0) {
                this.viewInfo[n].nEnd = i - 1;
                this.viewInfo[n].nWidth = lineWidth - fontWidth;
                lineWidth = 2 * fontWidth;
                this.viewInfo[++n] = new KViewInfo();
                this.viewInfo[n].nStart = i - 1;
                ++i;
                j = 2;
                continue;
            }
            ++i;
            if (flag) {
                flag = false;
                j = 0;
                continue;
            }
            ++j;
        }
        this.viewInfo[n].nEnd = i;
        this.viewInfo[n].nWidth = lineWidth;
        return n + 1;
    }

    private void drawExplain(Graphics g, String explain) {
        boolean flag = false;
        boolean isRefer = false;
        this.realLines = -1;
        int i = 0;
        while (i < this.viewInfoSize) {
            this.viewInfo[i].nLine = ++this.realLines;
            if (this.nTong == i && i != 0) {
                g.setColor(188, 73, 18);
                this.drawReferInfo(g, "\u540c\u4e49\u8bcd:", this.referTitleFont, this.font, i, this.realLines);
                isRefer = true;
                g.setColor(0, 0, 255);
                flag = true;
            } else if (this.nFan == i && i != 0) {
                g.setColor(188, 73, 18);
                this.drawReferInfo(g, "\u53cd\u4e49\u8bcd:", this.referTitleFont, this.font, i, this.realLines);
                if (!isRefer) {
                    isRefer = true;
                }
                g.setColor(0, 130, 132);
            } else {
                if (i == this.nENExplain && i != 0) {
                    g.setColor(0, 130, 132);
                } else if (i == this.nCNExplain && i != 0) {
                    g.setColor(0, 0, 0);
                }
                if (isRefer || this.langF == 1) {
                    g.setFont(this.referFont);
                } else {
                    g.setFont(this.font);
                }
                String strWord = explain.substring(this.viewInfo[i].nStart, this.viewInfo[i].nEnd).trim();
                g.drawString(strWord, 5, this.headHeight + this.fontHeight * this.realLines + this.viewPoint, 20);
                if ((isRefer || this.langF == 1) && this.viewInfo[i].nWidth < this.tabWidth && i < this.viewInfoSize - 1 && i + 1 != this.nFan) {
                    if (this.viewInfo[++i].nWidth < this.tabWidth) {
                        strWord = explain.substring(this.viewInfo[i].nStart, this.viewInfo[i].nEnd).trim();
                        g.drawString(strWord, 5 + this.tabWidth, this.headHeight + this.fontHeight * this.realLines + this.viewPoint, 20);
                        this.viewInfo[i].nLine = this.realLines;
                    } else {
                        --i;
                    }
                }
            }
            ++i;
        }
        g.setColor(0);
    }

    private void drawReferInfo(Graphics g, String strInfo, Font newFont, Font oldFont, int i, int line) {
        g.setFont(newFont);
        g.drawString(strInfo, 5, this.headHeight + this.fontHeight * line + this.viewPoint, 20);
        g.setFont(oldFont);
    }

    protected void pointerPressed(int x, int y) {
        block28: {
            block26: {
                block30: {
                    block29: {
                        block27: {
                            if (x <= this.screenWidth - this.buttonWidth || x >= this.screenWidth) break block26;
                            if (this.realLines + 1 <= (this.screenHeight - this.titleHeight - this.phoneHeight - this.fontHeight) / this.fontHeight) {
                                return;
                            }
                            if (y <= this.titleHeight || y >= this.titleHeight + this.buttonHeight || this.lineupFlag == -1) break block27;
                            this.pageupFlag = 1;
                            this.viewPoint += this.LINE_NUM * this.fontHeight;
                            if (this.viewPoint > 0) {
                                this.viewPoint = 0;
                            }
                            break block28;
                        }
                        if (y <= this.screenHeight - this.buttonHeight || y >= this.screenHeight || this.linedownFlag == -1) break block29;
                        this.pagedownFlag = 1;
                        this.viewPoint -= this.LINE_NUM * this.fontHeight;
                        if (this.viewPoint < -1 * (this.realLines + 1 - this.LINE_NUM) * this.fontHeight) {
                            this.viewPoint = -1 * (this.realLines + 1 - this.LINE_NUM) * this.fontHeight;
                        }
                        break block28;
                    }
                    if (y <= this.titleHeight + this.buttonHeight || y >= this.titleHeight + 2 * this.buttonHeight || this.pageupFlag == -1) break block30;
                    this.lineupFlag = 1;
                    this.viewPoint += this.fontHeight;
                    break block28;
                }
                if (y <= this.screenHeight - 2 * this.buttonHeight || y >= this.screenHeight - this.buttonHeight || this.pagedownFlag == -1) break block28;
                this.linedownFlag = 1;
                this.viewPoint -= this.fontHeight;
                break block28;
            }
            if (y < this.headHeight || this.pointerCmd == null) {
                return;
            }
            int i = 0;
            i = 0;
            while (i < this.realLines + 1) {
                if (y > i * this.fontHeight + this.headHeight && y < (i + 1) * this.fontHeight + this.headHeight) {
                    this.selectY = i * this.fontHeight + this.headHeight;
                    int line = this.viewInfo[i -= this.viewPoint / this.fontHeight].nLine;
                    int l = 0;
                    while (this.viewInfo[i + l].nLine != i) {
                        ++l;
                    }
                    int index = i + l;
                    if (index == this.nTong && this.nTong != 0 || index == this.nFan && this.nFan != 0 || x < 5) {
                        return;
                    }
                    if (this.viewInfo[index].nWidth < x && this.nTong == 0 && this.nFan == 0 && this.langF == 0) {
                        return;
                    }
                    if (this.nTong != 0 && index < this.nTong && this.viewInfo[index].nWidth + 5 < x) {
                        return;
                    }
                    if (this.nTong == 0 && this.nFan != 0 && index < this.nFan && this.viewInfo[index].nWidth + 5 < x) {
                        return;
                    }
                    if (index > this.nTong && this.nTong != 0 || index > this.nFan && this.nFan != 0) {
                        this.g_getString = this.getEnglishWord(x, index);
                        if (this.g_getString == null) {
                            return;
                        }
                        this.cl.commandAction(this.pointerCmd, (Displayable)this);
                        break;
                    }
                    if (this.langF == 1) {
                        this.g_getString = this.getEnglishWord(x, index);
                        if (this.g_getString == null) {
                            return;
                        }
                    } else {
                        this.g_getString = this.wordLine.explain.substring(this.viewInfo[index].nStart, this.viewInfo[index].nEnd);
                        this.g_getString = this.g_getString.trim();
                        int j = 0;
                        int lineWidth = 5;
                        this.selectX = 5;
                        j = 0;
                        while (j < 60) {
                            if (x <= (lineWidth += this.font.charWidth(this.g_getString.charAt(j)))) break;
                            this.selectX = lineWidth;
                            ++j;
                        }
                        if (j >= this.g_getString.length()) {
                            j = this.g_getString.length() - 1;
                        }
                        String strtemp = this.g_getString;
                        this.g_getString = this.g_getString.substring(j, j + 1);
                        System.out.println(this.g_getString);
                        if (this.g_getString.charAt(0) >= '\u4e00') {
                            this.selectWidth = this.font.charWidth(this.g_getString.charAt(0));
                            this.bSelected = true;
                            this.repaint();
                            this.serviceRepaints();
                            this.g_langFlag = 1;
                        } else if (this.isAlpha(this.g_getString.charAt(0))) {
                            int n = j;
                            while (j > 0) {
                                if (!this.isAlpha(strtemp.charAt(j - 1)) && strtemp.charAt(j - 1) != '-') break;
                                this.selectX -= this.font.charWidth(strtemp.charAt(j - 1));
                                --j;
                            }
                            while (n < strtemp.length() - 1) {
                                if (!this.isAlpha(strtemp.charAt(n)) && strtemp.charAt(n) != '-') break;
                                ++n;
                            }
                            if (n != j) {
                                this.g_getString = strtemp.substring(j, n);
                                this.selectWidth = this.font.charsWidth(this.g_getString.toCharArray(), 0, n - j);
                            } else {
                                this.selectWidth = this.font.charWidth(this.g_getString.charAt(0));
                            }
                            System.out.println("getString = " + this.g_getString);
                            this.bSelected = true;
                            this.repaint();
                            this.serviceRepaints();
                            this.g_langFlag = 0;
                        } else {
                            return;
                        }
                    }
                    this.cl.commandAction(this.pointerCmd, (Displayable)this);
                    break;
                }
                ++i;
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    private String getEnglishWord(int x, int index) {
        String strLine = null;
        if (x < this.tabWidth + 5) {
            if (this.viewInfo[index].nWidth + 5 < x) {
                return null;
            }
            strLine = this.wordLine.explain.substring(this.viewInfo[index].nStart, this.viewInfo[index].nEnd);
        } else if (x >= this.tabWidth + 5 && x < this.screenWidth - this.buttonWidth) {
            if (this.viewInfo[index].nWidth > 5 + this.tabWidth) {
                if (x > this.viewInfo[index].nWidth) {
                    return null;
                }
                strLine = this.wordLine.explain.substring(this.viewInfo[index].nStart, this.viewInfo[index].nEnd);
            } else {
                if (index + 1 >= this.viewInfoSize) {
                    return null;
                }
                if (this.viewInfo[index + 1].nWidth + 5 + this.tabWidth < x) {
                    return null;
                }
                if (this.viewInfo[index].nLine != this.viewInfo[index + 1].nLine) {
                    return null;
                }
                strLine = this.wordLine.explain.substring(this.viewInfo[index + 1].nStart, this.viewInfo[index + 1].nEnd);
            }
        }
        strLine = this.getPerWord(strLine.trim(), x, index);
        this.g_langFlag = 0;
        return strLine;
    }

    private String getPerWord(String strLine, int x, int i) {
        int len = strLine.length();
        boolean isDivid = false;
        int l = 0;
        while (l < len) {
            if (strLine.charAt(l) == ' ') {
                isDivid = true;
                break;
            }
            ++l;
        }
        isDivid = false;
        if (isDivid) {
            int m;
            int m2;
            int j = 0;
            int width = 5;
            if (this.viewInfo[i].nWidth > this.tabWidth + 5) {
                m2 = 0;
                while (m2 < len) {
                    if (x <= (width += this.font.charWidth(strLine.charAt(m2)))) {
                        j = m2;
                        break;
                    }
                    ++m2;
                }
            } else {
                if (x > 5 + this.tabWidth) {
                    width += this.tabWidth;
                }
                m2 = 0;
                while (m2 < len) {
                    if (x <= (width += this.font.charWidth(strLine.charAt(m2)))) {
                        j = m2;
                        break;
                    }
                    ++m2;
                }
            }
            int n = j;
            while (j > 0) {
                if (!this.isAlpha(strLine.charAt(j - 1)) && strLine.charAt(j - 1) != '-' && strLine.charAt(j - 1) != '.') break;
                --j;
            }
            while (n < strLine.length()) {
                if (!this.isAlpha(strLine.charAt(n)) && strLine.charAt(n) != '-' && strLine.charAt(n) != '.') break;
                ++n;
            }
            String strtemp = strLine;
            if (n != j) {
                strLine = strLine.substring(j, n);
                m = 0;
                while (m < n - j) {
                    this.selectWidth += this.font.charWidth(strLine.charAt(m));
                    ++m;
                }
            } else {
                strLine = strLine.substring(j, j + 1);
                this.selectWidth = this.font.charWidth(strLine.charAt(0));
            }
            this.selectX = 5;
            if (this.viewInfo[i].nWidth < this.tabWidth + 5 && x > 5 + this.tabWidth) {
                this.selectX += this.tabWidth;
            }
            m = 0;
            while (m < j) {
                this.selectX += this.font.charWidth(strtemp.charAt(m));
                ++m;
            }
        } else if (x > 5 + this.tabWidth) {
            this.selectX = 5 + this.tabWidth;
            this.selectWidth = this.viewInfo[i + 1].nWidth;
        } else {
            this.selectX = 5;
            this.selectWidth = this.viewInfo[i].nWidth;
        }
        this.bSelected = true;
        this.repaint();
        this.serviceRepaints();
        return strLine;
    }

    private boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public int getLanguage() {
        return this.g_langFlag;
    }

    public String getString() {
        return this.g_getString;
    }

    protected void pointerReleased(int x, int y) {
        this.bSelected = false;
        this.repaintButtonImage();
    }

    protected void keyPressed(int key) {
        if (this.realLines + 1 <= (this.screenHeight - this.titleHeight - this.phoneHeight - this.fontHeight) / this.fontHeight) {
            return;
        }
        int keyCode = this.getGameAction(key);
        if (keyCode == 2) {
            if (this.pageupFlag == -1) {
                return;
            }
            this.pageupFlag = 1;
            this.viewPoint += this.LINE_NUM * this.fontHeight;
            if (this.viewPoint > 0) {
                this.viewPoint = 0;
            }
        } else if (keyCode == 5) {
            if (this.pagedownFlag == -1) {
                return;
            }
            this.pagedownFlag = 1;
            this.viewPoint -= this.LINE_NUM * this.fontHeight;
            if (this.viewPoint < -1 * (this.realLines + 1 - this.LINE_NUM) * this.fontHeight) {
                this.viewPoint = -1 * (this.realLines + 1 - this.LINE_NUM) * this.fontHeight;
            }
        } else if (keyCode == 1) {
            if (this.lineupFlag == -1) {
                return;
            }
            this.lineupFlag = 1;
            this.viewPoint += this.fontHeight;
        } else if (keyCode == 6) {
            if (this.linedownFlag == -1) {
                return;
            }
            this.linedownFlag = 1;
            this.viewPoint -= this.fontHeight;
        } else {
            return;
        }
        this.repaint();
        this.serviceRepaints();
    }

    protected void keyReleased(int key) {
        this.repaintButtonImage();
    }

    private void repaintButtonImage() {
        if (this.lineupFlag == 1) {
            this.lineupFlag = 0;
            this.repaint(this.screenWidth - this.buttonWidth, this.titleHeight + this.buttonHeight, this.buttonWidth, this.buttonHeight);
        } else if (this.linedownFlag == 1) {
            this.linedownFlag = 0;
            this.repaint(this.screenWidth - this.buttonWidth, this.screenHeight - 2 * this.buttonHeight, this.buttonWidth, this.buttonHeight);
        } else if (this.pageupFlag == 1) {
            this.pageupFlag = 0;
            this.repaint(this.screenWidth - this.buttonWidth, this.titleHeight, this.buttonWidth, this.buttonHeight);
        } else if (this.pagedownFlag == 1) {
            this.pagedownFlag = 0;
            this.repaint(this.screenWidth - this.buttonWidth, this.screenHeight - this.buttonHeight, this.buttonWidth, this.buttonHeight);
        }
    }
}

