/*
 * Decompiled with CFR 0.152.
 */
package motorola.xdict;

import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import motorola.xdict.ExplainScreen;
import motorola.xdict.HistoryScreen;
import motorola.xdict.ReadInfo;
import motorola.xdict.ReferList;
import motorola.xdict.SearchEngine;
import motorola.xdict.SplashScreen;
import motorola.xdict.WordLine;

public class xdict
extends MIDlet
implements CommandListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private Form mainscreen;
    private ExplainScreen explainscr;
    private ReferList listscreen;
    private HistoryScreen historyScreen;
    private Form helpScreen;
    private Form aboutScreen;
    private Alert alertScreen;
    private SplashScreen splashScreen;
    private Form askScreen;
    private TextField m_inputField;
    private WordLine m_wordLine;
    private SearchEngine m_searchEngine;
    private ReadInfo[] m_readInfo;
    private String m_strPrevWord = null;
    private long m_lWordIndex;
    private int m_nClickFlag = 0;
    private int m_nLangFlag = 0;
    private int m_nListMaxNum = 0;
    private boolean m_bFirstRun = true;
    private Displayable m_dspLast = null;
    public static Command cmdok;
    public static Command cmdexit;
    public static Command cmdclear;
    public static Command cmddatabase;
    public static Command cmdabout;
    public static Command cmdhelp;
    public static Command cmdlist;
    public static Command cmdret;
    public static Command cmdback;
    public static Command cmdmark;
    public static Command cmdpointer;
    public static Command cmddel;
    public static Command cmddelall;
    public static Command cmdyes;
    public static Command cmdno;
    public static Command cmdpageup;
    public static Command cmdpagedown;
    public static final int INPUT_LENGTH = 28;
    public static final int LANG_ENGLISH = 0;
    public static final int LANG_CHINESE = 1;
    private static final String STRING_FIRST_WORD = "a";
    public static final String STRING_TITLE = "\u91d1\u5c71\u8bcd\u9738";
    private static final String STRING_WARNING = "\u60a8\u67e5\u627e\u7684\u8bcd\u6761\u5df2\u7ecf\u8d85\u51fa\u9884\u88c5\u8bcd\u5178\u7684\u6570\u636e\u8303\u56f4\uff0c\u8bf7\u8fd4\u56de\u67e5\u8be2\u754c\u9762.";
    private static final String STRING_SPELLERROR_WARNING = "     \u60a8\u7684\u62fc\u5199\u8f93\u5165\u6709\u8bef,\u8bf7\u68c0\u67e5\u60a8\u7684\u62fc\u5199\u8f93\u5165.";
    private static final String STRING_OVERLONG_WARNING = "\u60a8\u7684\u6c49\u5b57\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u8bcd\u6761\u6700\u5927\u957f\u5ea6\u8303\u56f4,\u8bf7\u91cd\u65b0\u8f93\u5165.";
    private static final String STRING_DELALL_WARNING = "  \u672c\u64cd\u4f5c\u5c06\u4f1a\u5220\u9664\u5168\u90e8\u751f\u8bcd\u672c\u4e2d\u5185\u5bb9\uff0c\u60a8\u786e\u5b9a\u5220\u9664\u5417\uff1f";
    private static final String STRING_DELALLTITLE_WARNING = "\u786e\u8ba4\u5220\u9664\u5168\u90e8\u8bb0\u5f55";
    private static final String STRING_RECORD_WARNING = "\u60a8\u7684\u751f\u8bcd\u672c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u70b9\u51fb\u8f93\u5165\u6846\u8f93\u5165\u9700\u8981\u67e5\u8be2\u7684\u8bcd\u6c47\u3002";
    private static final String STRING_README = "\u70b9\u51fb\"\u8f93\u5165\u6846\"\u8f93\u5165\u8981\u67e5\u8be2\u7684\u8bcd\u6c47\uff0c\u70b9\u51fb\"\u786e\u5b9a\"\u5f00\u59cb\u67e5\u8be2.";

    public xdict() {
        ExplainScreen.InitPhoneImage();
    }

    protected void startApp() {
        if (this.m_bFirstRun) {
            this.InitInputScreen();
            String imageCM = "/icons/download.png";
            String imageKS = "/icons/Logo.png";
            new SplashScreen(this.display, (Displayable)this.mainscreen, imageKS, 1000);
            new InitParam().start();
            this.m_bFirstRun = false;
        }
    }

    protected void pauseApp() {
        this.m_dspLast = this.display.getCurrent();
    }

    protected void destroyApp(boolean unconditional) {
        if (this.m_searchEngine != null) {
            this.m_searchEngine.Close();
        }
        this.notifyDestroyed();
    }

    private int GetLangFlag(String str) {
        this.m_nLangFlag = str.charAt(0) <= 'z' && str.charAt(0) >= 'a' ? 0 : (str.charAt(0) >= '\u00e4' ? 1 : -1);
        return this.m_nLangFlag;
    }

    private void InitInputScreen() {
        cmdok = new Command("\u786e\u5b9a", 4, 1);
        cmdclear = new Command("\u6e05\u7a7a", 4, 2);
        cmddatabase = new Command("\u751f\u8bcd\u672c", 4, 3);
        cmdexit = new Command("\u9000\u51fa", 4, 4);
        cmdabout = new Command("\u5173\u4e8e", 1, 3);
        cmdhelp = new Command("\u5e2e\u52a9", 1, 3);
        this.mainscreen = new Form(STRING_TITLE);
        this.m_inputField = new TextField(null, null, 28, 0);
        this.m_inputField.setMaxSize(20);
        this.mainscreen.append((Item)this.m_inputField);
        this.mainscreen.append(" ");
        this.mainscreen.append(STRING_README);
        this.mainscreen.addCommand(cmdok);
        this.mainscreen.addCommand(cmdclear);
        this.mainscreen.addCommand(cmdhelp);
        this.mainscreen.addCommand(cmdabout);
        this.mainscreen.addCommand(cmddatabase);
        this.mainscreen.addCommand(cmdexit);
        this.mainscreen.setCommandListener((CommandListener)this);
        cmdlist = new Command("\u5217\u8868", 4, 2);
        cmdpageup = new Command("", 1, 2);
        cmdpagedown = new Command("", 1, 2);
        cmdpointer = new Command("", 1, 2);
        cmdret = new Command("\u8fd4\u56de", 2, 1);
        cmdback = new Command("\u56de\u9000", 2, 2);
        cmdmark = new Command("\u52a0\u5165\u751f\u8bcd\u672c", 4, 2);
        cmddel = new Command("\u5220\u9664", 8, 1);
        cmddelall = new Command("\u5220\u9664\u5168\u90e8", 8, 2);
        this.historyScreen = new HistoryScreen();
        this.historyScreen.addCommand(cmdret);
        this.historyScreen.addCommand(cmddel);
        this.historyScreen.addCommand(cmddelall);
        this.historyScreen.setCommandListener(this);
        cmdyes = new Command("\u662f", 4, 1);
        cmdno = new Command("\u5426", 2, 2);
        Image image = null;
        try {
            image = Image.createImage((String)"/icons/error.png");
        }
        catch (Exception exception) {}
        String strTitle = STRING_DELALLTITLE_WARNING;
        String strAlert = STRING_DELALL_WARNING;
        this.alertScreen = new Alert(strTitle, strAlert, image, AlertType.WARNING);
        this.alertScreen.addCommand(cmdyes);
        this.alertScreen.addCommand(cmdno);
        this.alertScreen.setCommandListener((CommandListener)this);
    }

    private void InitListScreen(Command cmd1, Command cmd2) {
        this.listscreen = new ReferList(this, cmdpointer, cmdpageup, cmdpagedown);
        if (cmd1 != null) {
            this.listscreen.addCommand(cmd1);
        }
        if (cmd2 != null) {
            this.listscreen.addCommand(cmd2);
        }
        this.listscreen.setCommandListener(this);
    }

    private int SetListScreen() {
        this.listscreen.deleteList();
        int size = (int)this.m_searchEngine.GetCloseIdxByIndex(this.m_lWordIndex, this.m_nListMaxNum, this.m_readInfo, 1);
        if (size != 0) {
            this.appendListScreen(size);
            this.display.setCurrent((Displayable)this.listscreen);
        }
        return size;
    }

    private void appendListScreen(int size) {
        if (this.m_readInfo != null) {
            if (size <= this.m_nListMaxNum) {
                ++size;
            }
            System.out.println("size = " + size);
            int i = 0;
            while (i < size - 1) {
                this.listscreen.append(this.m_readInfo[i].word);
                System.out.println(this.m_readInfo[i].word);
                ++i;
            }
            if (size - 1 < this.m_nListMaxNum) {
                int j = size - 1;
                while (j < this.m_nListMaxNum) {
                    this.m_readInfo[j].dataLength = 0;
                    this.m_readInfo[j].dataOffset = 0L;
                    this.m_readInfo[j].wordListOffset = 0L;
                    this.m_readInfo[j].word = "";
                    this.listscreen.append(this.m_readInfo[j].word);
                    ++j;
                }
            }
            this.listscreen.repaintScreen();
        }
    }

    private void InitExplainScreen(Command cmd1, Command cmd2, Command cmd3, Command cmd4, String strPrev) {
        this.explainscr = new ExplainScreen(this, cmdpointer, this.m_wordLine, cmd1, cmd2, cmd3, cmd4, strPrev);
        this.explainscr.setCommandListener(this);
        this.display.setCurrent((Displayable)this.explainscr);
    }

    public void commandAction(Command c, Displayable d) {
        String inputstr = null;
        if (d == this.mainscreen) {
            if (c == cmdok) {
                inputstr = this.m_inputField.getString();
                inputstr = inputstr.trim();
                inputstr = inputstr.toLowerCase();
                this.m_nLangFlag = this.GetLangFlag(inputstr);
                if (this.m_nLangFlag == -1) {
                    xdict.ShowAlert(this.display, STRING_TITLE, STRING_SPELLERROR_WARNING);
                    return;
                }
                if (inputstr.length() > 2 && this.m_nLangFlag == 1) {
                    xdict.ShowAlert(this.display, STRING_TITLE, STRING_OVERLONG_WARNING);
                    return;
                }
                this.m_nClickFlag = 1;
                this.openDictFind(inputstr, this.m_nLangFlag);
            } else if (c == cmdexit) {
                this.destroyApp(false);
            } else if (c == cmdclear) {
                this.m_inputField.setString(null);
            } else if (c == cmdhelp) {
                this.showHelpScreen();
            } else if (c == cmdabout) {
                this.showAboutScreen();
            } else if (c == cmddatabase) {
                if (this.historyScreen.updateWordList()) {
                    this.display.setCurrent((Displayable)this.historyScreen);
                } else {
                    xdict.ShowAlert(this.display, STRING_TITLE, STRING_RECORD_WARNING);
                }
            }
        } else if (d == this.explainscr) {
            if (c == cmdlist) {
                this.m_searchEngine.Reset(false);
                this.InitListScreen(cmdret, cmdback);
                this.SetListScreen();
            } else if (c == cmdret) {
                this.ReturnInputScreen(false);
            } else if (c == cmdback) {
                if (this.m_strPrevWord == null) {
                    return;
                }
                int langFlag = this.GetLangFlag(this.m_strPrevWord);
                String strtemp = this.m_strPrevWord;
                this.m_strPrevWord = null;
                this.openDictFind(strtemp, langFlag);
                strtemp = null;
            } else if (c == cmdmark) {
                if (this.historyScreen != null) {
                    int nIndex = this.historyScreen.findWord(this.m_wordLine.word);
                    if (nIndex != -1) {
                        this.historyScreen.deleteOneRecord(nIndex);
                    }
                    this.historyScreen.addWord(this.m_wordLine.word);
                }
            } else if (c == cmdpointer) {
                inputstr = this.explainscr.getString().toLowerCase();
                this.m_nLangFlag = this.GetLangFlag(inputstr);
                System.out.println(inputstr);
                this.m_strPrevWord = this.m_wordLine.word;
                this.m_nClickFlag = 1;
                this.openDictFind(inputstr, this.m_nLangFlag);
            }
        } else if (d == this.listscreen) {
            if (c == cmdret) {
                this.ReturnInputScreen(false);
            } else if (c == cmdback) {
                this.display.setCurrent((Displayable)this.explainscr);
            } else if (c == cmdpointer) {
                this.m_searchEngine.Reset(false);
                int selected = this.listscreen.getSelectedIndex();
                if (selected == -1) {
                    return;
                }
                char[] szExplain = this.m_searchEngine.GetExplainByIndex(this.m_readInfo[selected].dataOffset, this.m_readInfo[selected].dataLength);
                String explain = new String(szExplain);
                this.m_wordLine = this.getWordLine(this.m_readInfo[selected].word, explain, this.m_nLangFlag);
                this.InitExplainScreen(cmdret, cmdlist, cmdback, cmdmark, this.m_strPrevWord);
                System.out.println("after init explain screen");
                szExplain = null;
                this.listscreen.setSelectedIndex(-1, true);
            } else if (c == cmdpageup && this.listscreen.prevFlag != -1) {
                this.listscreen.deleteList();
                this.m_lWordIndex = this.m_readInfo[0].wordListOffset;
                int size = (int)this.m_searchEngine.GetCloseIdxByIndex(this.m_lWordIndex, this.m_nListMaxNum, this.m_readInfo, 0);
                if (size != this.m_nListMaxNum) {
                    this.listscreen.prevFlag = 0;
                    size = this.m_nListMaxNum;
                }
                int i = 0;
                while (i < size) {
                    this.listscreen.append(this.m_readInfo[i].word);
                    ++i;
                }
                this.listscreen.repaintScreen();
                this.m_lWordIndex = this.m_readInfo[0].wordListOffset;
            } else if (c == cmdpagedown && this.listscreen.prevFlag != -1) {
                if (this.listscreen.prevFlag == 0) {
                    this.listscreen.prevFlag = 1;
                }
                this.listscreen.deleteList();
                this.m_lWordIndex = this.m_readInfo[this.m_nListMaxNum - 1].wordListOffset;
                this.m_readInfo[0].dataLength = this.m_readInfo[this.m_nListMaxNum - 1].dataLength;
                int size = (int)this.m_searchEngine.GetCloseIdxByIndex(this.m_lWordIndex, this.m_nListMaxNum, this.m_readInfo, 1);
                this.appendListScreen(size);
            }
        } else if (d == this.historyScreen) {
            if (c == cmdret) {
                this.ReturnInputScreen(false);
            } else if (c == cmddel) {
                int nSelectIndex = this.historyScreen.getSelectedIndex();
                if (nSelectIndex == -1) {
                    return;
                }
                int nIndex = this.historyScreen.findWord(this.historyScreen.getString(nSelectIndex));
                if (nIndex != -1) {
                    this.historyScreen.deleteOneRecord(nIndex);
                }
                nIndex = this.historyScreen.getSelectedIndex();
                this.historyScreen.delete(nSelectIndex);
                if (this.historyScreen.size() <= 0) {
                    this.commandAction(cmdret, (Displayable)this.historyScreen);
                }
            } else if (c == cmddelall) {
                this.display.setCurrent((Displayable)this.alertScreen);
            } else if (c == List.SELECT_COMMAND) {
                String strCurrent = this.historyScreen.getString(this.historyScreen.getSelectedIndex());
                this.m_nLangFlag = this.GetLangFlag(strCurrent);
                this.openDictFind(strCurrent, this.m_nLangFlag);
            }
        } else if (d == this.helpScreen) {
            if (c == cmdret) {
                this.display.setCurrent((Displayable)this.mainscreen);
            }
        } else if (d == this.aboutScreen) {
            if (c == cmdret) {
                this.display.setCurrent((Displayable)this.mainscreen);
            }
        } else if (d == this.askScreen) {
            if (c == cmdret) {
                this.display.setCurrent((Displayable)this.mainscreen);
            }
        } else if (d == this.alertScreen) {
            if (c == cmdyes) {
                this.historyScreen.destroyDataBase();
                this.display.setCurrent((Displayable)this.mainscreen);
            } else if (c == cmdno) {
                this.display.setCurrent((Displayable)this.historyScreen);
            }
        }
    }

    private void openDictFind(String inputstr, int langFlag) {
        String strDictName = SearchEngine.mappingDict(inputstr, langFlag);
        this.m_searchEngine = new SearchEngine(strDictName);
        if (this.m_searchEngine.Open(true) != (long)SearchEngine.EDictNoError) {
            System.out.println("The dictionary is error!");
            return;
        }
        int ret = this.FindWord(inputstr, langFlag);
        if (ret == SearchEngine.EDictNotIndex) {
            this.InitAskScreen();
        } else if (ret == -1) {
            if (this.m_strPrevWord == null) {
                this.InitListScreen(cmdret, null);
            } else {
                this.InitListScreen(cmdret, cmdback);
            }
            int size = this.SetListScreen();
        } else {
            this.InitExplainScreen(cmdret, cmdlist, cmdback, cmdmark, this.m_strPrevWord);
            this.display.setCurrent((Displayable)this.explainscr);
        }
    }

    private void InitAskScreen() {
        this.askScreen = new Form(STRING_TITLE);
        try {
            Image image = Image.createImage((String)"/icons/error.png");
            this.askScreen.append(image);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.askScreen.append(STRING_WARNING);
        this.askScreen.addCommand(cmdret);
        this.askScreen.setCommandListener((CommandListener)this);
        this.m_inputField.setString(null);
        this.display.setCurrent((Displayable)this.askScreen);
    }

    private void ReturnInputScreen(boolean cleanFlag) {
        this.display.setCurrent((Displayable)this.mainscreen);
        this.m_strPrevWord = null;
    }

    private int FindWord(String str, int langFlag) {
        int length;
        char[] szExplain = null;
        this.m_lWordIndex = this.m_searchEngine.GetIndexByStr(str, langFlag);
        if (this.m_lWordIndex == (long)SearchEngine.EDictNotIndex) {
            return SearchEngine.EDictNotIndex;
        }
        if (this.m_lWordIndex < 0L) {
            return -1;
        }
        szExplain = this.m_searchEngine.GetExplainByIndex();
        if (szExplain == null) {
            return -1;
        }
        String explain = new String(szExplain);
        String strTemp = this.m_searchEngine.getString();
        int flag = 0;
        if (this.m_nClickFlag == 1) {
            this.m_nClickFlag = 0;
            flag = -1;
        }
        if (strTemp == null) {
            flag = 0;
            strTemp = str;
        }
        if ((length = explain.indexOf(0)) != explain.length() - 1 && length != -1) {
            explain = explain.substring(0, length + 1);
        }
        this.m_wordLine = this.getWordLine(strTemp, explain, langFlag);
        return flag;
    }

    private WordLine getWordLine(String str, String explain, int langFlag) {
        WordLine wordLine = new WordLine();
        wordLine.word = str;
        explain = explain.trim();
        if (langFlag == 0) {
            int start = explain.indexOf(38);
            if (start != 0) {
                wordLine.phone = "";
                start = -1;
            } else {
                int end = explain.indexOf(10);
                wordLine.phone = explain.substring(start + 1, end - start);
                explain = explain.substring(end + 1);
            }
        }
        wordLine.explain = explain.trim();
        return wordLine;
    }

    public static void ShowAlert(Display display, String strTitle, String strAlert) {
        try {
            Image image = Image.createImage((String)"/icons/error.png");
            Alert alert = new Alert(strTitle, strAlert, image, AlertType.WARNING);
            display.setCurrent((Displayable)alert);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void showHelpScreen() {
        InputStream is = null;
        StringBuffer strHelp = new StringBuffer();
        byte[] byReadTemp = new byte[2];
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/icons/help.txt");
            if (is != null) {
                if (is.read(byReadTemp) != -1) {
                    while (is.read(byReadTemp) != -1) {
                        int nFirstByte = byReadTemp[0] < 0 ? byReadTemp[0] + 256 : byReadTemp[0];
                        int nSecondByte = byReadTemp[1] < 0 ? byReadTemp[1] + 256 : byReadTemp[1];
                        char chrTemp = (char)(nFirstByte + nSecondByte * 256);
                        strHelp.append(chrTemp);
                        byReadTemp[0] = 0;
                        byReadTemp[1] = 0;
                    }
                } else {
                    strHelp.append("\u5e2e\u52a9\u6587\u4ef6\u65e0\u5185\u5bb9\uff01");
                }
            } else {
                strHelp.append("\u627e\u4e0d\u5230\u5e2e\u52a9\u6587\u4ef6.");
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            strHelp.append("\u5e2e\u52a9\u6587\u4ef6\u635f\u574f\u6216\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002");
        }
        this.helpScreen = new Form(STRING_TITLE);
        this.helpScreen.addCommand(cmdret);
        this.helpScreen.setCommandListener((CommandListener)this);
        this.helpScreen.append(strHelp.toString());
        this.display.setCurrent((Displayable)this.helpScreen);
    }

    private void showAboutScreen() {
        this.aboutScreen = new Form(STRING_TITLE);
        this.aboutScreen.addCommand(cmdret);
        this.aboutScreen.setCommandListener((CommandListener)this);
        this.aboutScreen.append((Item)new StringItem("==\u5173\u4e8e\u91d1\u5c71\u8bcd\u9738\u79fb\u52a8\u7248==", null, 0));
        this.aboutScreen.append((Item)new StringItem(" ", null, 0));
        this.aboutScreen.append((Item)new StringItem("\u7248\u672c\uff1a2.2.2", null, 0));
        this.aboutScreen.append((Item)new StringItem("\u91d1\u5c71\u6570\u5b57\u5a31\u4e50\u79d1\u6280\u6709\u9650\u516c\u53f8", null, 0));
        this.aboutScreen.append((Item)new StringItem("\u4e2d\u56fd\u5730\u533a\u72ec\u5bb6\u53d1\u884c", null, 0));
        this.aboutScreen.append((Item)new StringItem("http://www.kingsoft.com", null, 0));
        this.aboutScreen.append((Item)new StringItem("\u5ba2\u670d\u7535\u8bdd\uff1a010-82326868", null, 0));
        this.aboutScreen.append((Item)new StringItem("kms_mbox@kingsoft.com", null, 0));
        this.display.setCurrent((Displayable)this.aboutScreen);
    }

    static /* synthetic */ WordLine access$4(xdict $0) {
        return $0.m_wordLine;
    }

    class InitParam
    extends Thread {
        InitParam() {
            xdict.this.InitListScreen(cmdret, cmdback);
            xdict.this.m_nListMaxNum = xdict.this.listscreen.getListNum();
            xdict.this.m_wordLine = new WordLine();
            xdict.this.m_readInfo = new ReadInfo[xdict.this.m_nListMaxNum];
            int i = 0;
            while (i < xdict.this.m_nListMaxNum) {
                ((xdict)xdict.this).m_readInfo[i] = new ReadInfo();
                ++i;
            }
        }
    }
}

