/*
 * Decompiled with CFR 0.152.
 */
package motorola.xdict;

import javax.microedition.lcdui.List;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

class HistoryScreen
extends List
implements RecordFilter,
RecordComparator {
    public RecordStore recordUserDict = null;
    public static int DATABASE_FREE_SIZE = 102400;
    private RecordEnumeration listEnum = null;
    private RecordEnumeration searchEnum = null;
    private byte[] byaData = new byte[1000];
    private int firstRecord = -1;
    public int[] naIndexs;
    public String strSearchWord = null;

    public HistoryScreen() {
        super("\u751f\u8bcd\u672c", 3);
    }

    public void addWord(String strWord) {
        System.out.println("HistoryScreen>>addWord: word = " + strWord);
        this.openDataBase();
        int sWordLen = strWord.length();
        int nTotalLen = sWordLen * 2;
        while (this.byaData.length < nTotalLen) {
            this.resizeBuffer();
        }
        int nOff = 0;
        int i = 0;
        while (i < sWordLen) {
            char nTemp = strWord.charAt(i);
            this.byaData[nOff] = (byte)(nTemp & 0xFF);
            this.byaData[nOff + 1] = (byte)(nTemp >> 8 & 0xFF);
            nOff += 2;
            ++i;
        }
        int nFree = this.getFreeSize();
        if (nFree < nTotalLen) {
            this.deleteRecord(nTotalLen - nFree);
            nFree = this.getFreeSize();
            if (nFree < nTotalLen) {
                return;
            }
        }
        try {
            this.recordUserDict.addRecord(this.byaData, 0, sWordLen * 2);
        }
        catch (RecordStoreException recordStoreException) {}
    }

    private void openDataBase() {
        block4: {
            if (this.recordUserDict != null) break block4;
            try {
                this.recordUserDict = RecordStore.openRecordStore((String)"userdict", (boolean)true);
            }
            catch (RecordStoreException e) {
                if (this.recordUserDict == null) break block4;
                try {
                    this.recordUserDict.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
                this.recordUserDict = null;
                System.out.println("HistoryScreen>>openDataBase, e: " + e.toString());
            }
        }
    }

    private void resizeBuffer() {
        int nLength = this.byaData.length;
        byte[] byaTemp = new byte[nLength * 2];
        System.arraycopy(this.byaData, 0, byaTemp, 0, nLength);
        this.byaData = byaTemp;
    }

    private int getFreeSize() {
        try {
            int nUsed = this.recordUserDict.getSize();
            int nFree = this.recordUserDict.getSizeAvailable();
            int nRes = DATABASE_FREE_SIZE - nUsed < nFree ? DATABASE_FREE_SIZE - nUsed : nFree;
            return nRes;
        }
        catch (RecordStoreException recordStoreException) {
            return -1;
        }
    }

    private void deleteRecord(int nNeedSize) {
        int nTotal = 0;
        this.openDataBase();
        try {
            int nLastID = this.recordUserDict.getNextRecordID();
            int i = this.firstRecord == -1 ? 1 : this.firstRecord;
            while (i < nLastID) {
                block8: {
                    int nSize = 0;
                    try {
                        nSize = this.recordUserDict.getRecordSize(i);
                    }
                    catch (InvalidRecordIDException invalidRecordIDException) {
                        break block8;
                    }
                    this.firstRecord = i;
                    try {
                        this.recordUserDict.deleteRecord(this.firstRecord);
                    }
                    catch (Exception exception) {}
                    ++this.firstRecord;
                    if ((nTotal += nSize) > nNeedSize) break;
                }
                ++i;
            }
            if (nTotal > 0) {
                this.closeDataBase();
                this.openDataBase();
            }
        }
        catch (RecordStoreException recordStoreException) {}
    }

    public void deleteOneRecord(int nIndex) {
        this.openDataBase();
        try {
            this.recordUserDict.getRecordSize(nIndex);
        }
        catch (Exception exception) {
            return;
        }
        try {
            this.recordUserDict.deleteRecord(nIndex);
        }
        catch (RecordStoreException recordStoreException) {}
        if (nIndex == this.firstRecord) {
            ++this.firstRecord;
        }
        this.closeDataBase();
        this.openDataBase();
    }

    public void destroyDataBase() {
        this.closeDataBase();
        try {
            RecordStore.deleteRecordStore((String)"userdict");
        }
        catch (RecordStoreException e) {
            System.out.println("HistoryScreen>>destroyDataBase, e: " + e.toString());
        }
        this.firstRecord = -1;
    }

    private void closeDataBase() {
        if (this.recordUserDict != null) {
            this.closeListEnu();
            this.closeSearchEnu();
            try {
                this.recordUserDict.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
            this.recordUserDict = null;
        }
    }

    public boolean updateWordList() {
        this.naIndexs = this.listWord();
        this.deleteAll();
        if (this.naIndexs == null) {
            return false;
        }
        int nLength = this.naIndexs.length;
        int i = 0;
        while (i < nLength) {
            this.append(this.getWord(this.naIndexs[i]), null);
            ++i;
        }
        return true;
    }

    public int[] listWord() {
        this.openDataBase();
        this.updateListEnu();
        if (this.listEnum != null) {
            int nNum = this.listEnum.numRecords();
            System.out.println("HistoryScreen>>listWord: record num = " + nNum);
            if (nNum > 0) {
                int[] naList = new int[nNum];
                int i = 0;
                while (i < nNum) {
                    try {
                        naList[i] = this.listEnum.nextRecordId();
                        System.out.println("HistoryScreen>>listWord: naList = " + naList[i]);
                    }
                    catch (RecordStoreException recordStoreException) {
                        naList[i] = -1;
                    }
                    ++i;
                }
                return naList;
            }
        }
        return null;
    }

    public String getWord(int nIndex) {
        StringBuffer strbTemp = new StringBuffer();
        this.openDataBase();
        try {
            int nTotalLen = this.recordUserDict.getRecordSize(nIndex);
            System.out.println("HistoryScreen>>getWord:nTotalLen = " + nTotalLen);
            System.out.println("HistoryScreen>>getWord:byaData.length = " + this.byaData.length);
            while (this.byaData.length < nTotalLen) {
                this.resizeBuffer();
            }
            int sWordLen = nTotalLen / 2;
            this.recordUserDict.getRecord(nIndex, this.byaData, 0);
            int i = 0;
            while (i < sWordLen) {
                char chTemp = (char)((this.byaData[i * 2] & 0xFF) + ((this.byaData[i * 2 + 1] & 0xFF) << 8));
                strbTemp.append(chTemp);
                ++i;
            }
            System.out.println("HistoryScreen>>getWord: word = " + strbTemp.toString());
            return strbTemp.toString();
        }
        catch (RecordStoreException recordStoreException) {
            return null;
        }
    }

    private void updateListEnu() {
        if (this.listEnum == null) {
            try {
                this.listEnum = this.recordUserDict.enumerateRecords(null, null, false);
            }
            catch (RecordStoreException recordStoreException) {}
        } else {
            this.listEnum.rebuild();
        }
    }

    private void closeListEnu() {
        if (this.listEnum != null) {
            this.listEnum.destroy();
            this.listEnum = null;
        }
    }

    public int findWord(String strWord) {
        this.openDataBase();
        this.strSearchWord = strWord;
        this.updateSearchEnu();
        if (this.searchEnum != null && this.searchEnum.numRecords() > 0) {
            try {
                return this.searchEnum.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
            }
        }
        return -1;
    }

    private void updateSearchEnu() {
        if (this.searchEnum == null) {
            try {
                this.searchEnum = this.recordUserDict.enumerateRecords((RecordFilter)this, null, false);
            }
            catch (RecordStoreException recordStoreException) {}
        } else {
            this.searchEnum.rebuild();
            this.searchEnum.reset();
        }
    }

    private void closeSearchEnu() {
        if (this.searchEnum != null) {
            this.searchEnum.destroy();
            this.searchEnum = null;
        }
    }

    public int compare(byte[] byaRec1, byte[] byaRec2) {
        char chTemp;
        StringBuffer strbTemp1 = new StringBuffer();
        StringBuffer strbTemp2 = new StringBuffer();
        int sWordLen = byaRec1.length / 2;
        int i = 0;
        while (i < sWordLen) {
            chTemp = (char)((byaRec1[i * 2] & 0xFF) + ((byaRec1[i * 2 + 1] & 0xFF) << 8));
            strbTemp1.append(chTemp);
            ++i;
        }
        sWordLen = (short)(byaRec2.length / 2);
        i = 0;
        while (i < sWordLen) {
            chTemp = (char)((byaRec2[i * 2] & 0xFF) + ((byaRec2[i * 2 + 1] & 0xFF) << 8));
            strbTemp2.append(chTemp);
            ++i;
        }
        i = strbTemp1.toString().compareTo(strbTemp2.toString());
        if (i < 0) {
            return -1;
        }
        if (i > 0) {
            return 1;
        }
        return 0;
    }

    public boolean matches(byte[] byaRec) {
        if (this.strSearchWord != null) {
            StringBuffer strbTemp = new StringBuffer();
            int sWordLen = byaRec.length / 2;
            int i = 0;
            while (i < sWordLen) {
                char chTemp = (char)((byaRec[i * 2] & 0xFF) + ((byaRec[i * 2 + 1] & 0xFF) << 8));
                strbTemp.append(chTemp);
                ++i;
            }
            return strbTemp.toString().compareTo(this.strSearchWord) == 0;
        }
        return false;
    }
}

