/*
 * Decompiled with CFR 0.152.
 */
package motorola.xdict;

import java.io.InputStream;
import motorola.xdict.KByteStream;
import motorola.xdict.ReadInfo;
import motorola.xdict.XD_DictionaryHeader;
import motorola.xdict.XD_IndexItem;

class SearchEngine {
    public static int EDictNotIndex = -5;
    public static int EDictOutOfMemory = -4;
    public static int EDictBadDatabase = -3;
    public static int EDictNotFound = -2;
    public static int EDictInvalidIndex = -1;
    public static int EDictNoError = 0;
    public static int EDictExactMatch = 0;
    public static int EDictCloseMatch = 1;
    public static int HEADER_LENGTH = 52;
    private boolean m_bDictionaryOpened;
    public InputStream m_hDictionaryFile;
    public XD_DictionaryHeader m_DictionaryHeader;
    public int g_nWordDataOffset;
    public int g_nWordExplainLen;
    private String aPathName = null;
    public String g_getString = null;
    private static String[] strCEList = new String[]{"\u4e00", "\u51c9", "\u53d9", "\u5893", "\u5e94", "\u62e6", "\u671f", "\u704c", "\u7f94", "\u8e29"};

    public SearchEngine(String aPathName) {
        this.aPathName = aPathName;
        this.m_bDictionaryOpened = false;
        this.m_DictionaryHeader = new XD_DictionaryHeader();
    }

    public long Open(boolean ReadFlag) {
        if (this.m_bDictionaryOpened) {
            this.CloseDictionary();
        }
        return this.OpenDictionary(ReadFlag);
    }

    public void Close() {
        this.CloseDictionary();
    }

    public int getWordCount() {
        if (this.m_DictionaryHeader == null) {
            this.m_DictionaryHeader.lWordCount = -1;
        }
        return this.m_DictionaryHeader.lWordCount;
    }

    public int Reset(boolean ReadFlag) {
        if (this.m_hDictionaryFile != null) {
            this.Close();
            if (this.Open(ReadFlag) != (long)EDictNoError) {
                System.out.println("The dictionary is error!");
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private int OpenDictionary(boolean ReadFlag) {
        try {
            this.m_hDictionaryFile = this.getClass().getResourceAsStream(this.aPathName);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return EDictNotFound;
        }
        this.m_bDictionaryOpened = true;
        if (!ReadFlag) {
            return EDictNoError;
        }
        byte[] pBuffer = new byte[HEADER_LENGTH];
        int ErrorCode = this.ReadDictionary(0L, HEADER_LENGTH, pBuffer);
        if (ErrorCode != EDictNoError) {
            this.CloseDictionary();
            return ErrorCode;
        }
        try {
            this.m_DictionaryHeader.lMaxWordLength = KByteStream.toInt(pBuffer, 20, 4);
            this.m_DictionaryHeader.lIndexOffset = KByteStream.toInt(pBuffer, 24, 4);
            this.m_DictionaryHeader.lIndexLength = KByteStream.toInt(pBuffer, 28, 4);
            this.m_DictionaryHeader.lWordListOffset = KByteStream.toInt(pBuffer, 32, 4);
            this.m_DictionaryHeader.lWordListLength = KByteStream.toInt(pBuffer, 36, 4);
            this.m_DictionaryHeader.lDataOffset = KByteStream.toInt(pBuffer, 40, 4);
            this.m_DictionaryHeader.lDataLength = KByteStream.toInt(pBuffer, 44, 4);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return EDictNoError;
    }

    public byte[] ReadDictIndex() {
        if (!this.m_bDictionaryOpened) {
            return null;
        }
        int IndexLen = this.m_DictionaryHeader.lWordListOffset - this.m_DictionaryHeader.lIndexOffset;
        byte[] WordIndexList = new byte[IndexLen];
        if (WordIndexList == null) {
            return null;
        }
        long ErrorCode = this.ReadDictionary(this.m_DictionaryHeader.lIndexOffset, IndexLen, WordIndexList);
        if (ErrorCode != (long)EDictNoError) {
            return null;
        }
        this.Close();
        this.Reset(false);
        return WordIndexList;
    }

    private int ReadDictionary(long nOffset, long nLength, byte[] pBuffer) {
        if (this.m_bDictionaryOpened) {
            try {
                if (nOffset != 0L) {
                    this.Reset(false);
                    this.m_hDictionaryFile.skip(nOffset);
                }
                this.m_hDictionaryFile.read(pBuffer, 0, (int)nLength);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            return EDictNoError;
        }
        return EDictBadDatabase;
    }

    private void CloseDictionary() {
        if (this.m_bDictionaryOpened) {
            try {
                if (this.m_hDictionaryFile != null) {
                    this.m_hDictionaryFile.close();
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        this.m_bDictionaryOpened = false;
    }

    public long GetIndexByStr(String aSearchStr, int langFlag) {
        int nWordOffset;
        boolean bFound;
        block22: {
            if (!this.m_bDictionaryOpened) {
                return EDictBadDatabase;
            }
            int len = aSearchStr.length();
            XD_IndexItem Index = new XD_IndexItem();
            char[] szWord = aSearchStr.toCharArray();
            switch (len) {
                case 0: {
                    Index.wIndex[0] = '\u0000';
                    Index.wIndex[1] = '\u0000';
                    break;
                }
                case 1: {
                    Index.wIndex[0] = szWord[0];
                    Index.wIndex[1] = '\u0000';
                    break;
                }
                default: {
                    Index.wIndex[0] = szWord[0];
                    Index.wIndex[1] = szWord[1];
                }
            }
            byte[] buffer = this.ReadDictIndex();
            int nDataLength = buffer.length;
            int IndexNum = nDataLength / 8 - 1;
            int wordListOffset = 0;
            int wordListLen = 0;
            int dwOffset1 = 0;
            int dwOffset2 = 0;
            bFound = false;
            int dwOffset3 = 0;
            int wordListLenNext = 0;
            int i = 0;
            while (i < IndexNum) {
                char[] word = KByteStream.toCharArray(buffer, i * 8, 4);
                if (word[0] >= Index.wIndex[0] && word[1] >= Index.wIndex[1]) {
                    dwOffset1 = KByteStream.toInt(buffer, i * 8 + 4, 4);
                    dwOffset2 = KByteStream.toInt(buffer, (i + 1) * 8 + 4, 4);
                    wordListOffset = this.m_DictionaryHeader.lWordListOffset + dwOffset1;
                    wordListLen = dwOffset2 - dwOffset1;
                    bFound = true;
                    if (langFlag != 1) break;
                    dwOffset3 = KByteStream.toInt(buffer, (i + 2) * 8 + 4, 4);
                    wordListLenNext = dwOffset3 - dwOffset2;
                    break;
                }
                if ((word[0] < Index.wIndex[0] || word[1] < Index.wIndex[1]) && i == IndexNum - 1) break;
                ++i;
            }
            if (!bFound) {
                return EDictNotIndex;
            }
            byte[] pDataBuffer = new byte[wordListLen];
            long nErrorCode = this.ReadDictionary(wordListOffset, wordListLen, pDataBuffer);
            if (nErrorCode != (long)EDictNoError) {
                return EDictBadDatabase;
            }
            int nWordIndexOffset = 0;
            int NextWordDataOffset = 0;
            nWordOffset = wordListOffset;
            String getWord = null;
            bFound = false;
            while (true) {
                char[] word = KByteStream.toCharArray(pDataBuffer, nWordIndexOffset);
                nWordIndexOffset += word.length * 2 + 2;
                if (langFlag == 1) {
                    int length = szWord.length >= word.length ? word.length : szWord.length;
                    int i2 = 0;
                    while (i2 < length) {
                        if (word[i2] < szWord[i2]) break;
                        bFound = true;
                        ++i2;
                    }
                    if (!bFound) {
                        nWordIndexOffset += 4;
                        continue;
                    }
                    if (new String(word).compareTo(new String(szWord)) > 0) {
                        this.g_getString = new String(word);
                    }
                    nWordOffset += nWordIndexOffset - (word.length * 2 + 2);
                    this.g_nWordDataOffset = KByteStream.toInt(pDataBuffer, nWordIndexOffset, 4);
                    if ((nWordIndexOffset += 4) >= pDataBuffer.length) {
                        pDataBuffer = new byte[wordListLenNext];
                        nErrorCode = this.ReadDictionary(wordListOffset + wordListLen, wordListLenNext, pDataBuffer);
                        if (nErrorCode != (long)EDictNoError) {
                            return EDictBadDatabase;
                        }
                        nWordIndexOffset = 0;
                        word = KByteStream.toCharArray(pDataBuffer, nWordIndexOffset);
                        NextWordDataOffset = KByteStream.toInt(pDataBuffer, nWordIndexOffset += word.length * 2 + 2, 4);
                        this.g_nWordExplainLen = NextWordDataOffset - this.g_nWordDataOffset;
                        this.g_nWordDataOffset += this.m_DictionaryHeader.lDataOffset;
                    } else {
                        this.g_getString = new String(word);
                        this.g_nWordExplainLen = 256;
                        this.g_nWordDataOffset += this.m_DictionaryHeader.lDataOffset;
                    }
                    break block22;
                }
                getWord = new String(word);
                if (getWord.compareTo(aSearchStr) >= 0) {
                    if (getWord.compareTo(aSearchStr) > 0) {
                        this.g_getString = getWord;
                    }
                    bFound = true;
                    nWordOffset += nWordIndexOffset - (word.length * 2 + 2);
                    this.g_nWordDataOffset = KByteStream.toInt(pDataBuffer, nWordIndexOffset, 4);
                    if (wordListLen == (nWordIndexOffset += 4)) {
                        this.g_nWordExplainLen = 256;
                    } else {
                        word = KByteStream.toCharArray(pDataBuffer, nWordIndexOffset);
                        NextWordDataOffset = KByteStream.toInt(pDataBuffer, nWordIndexOffset += word.length * 2 + 2, 4);
                        this.g_nWordExplainLen = NextWordDataOffset - this.g_nWordDataOffset;
                    }
                    this.g_nWordDataOffset += this.m_DictionaryHeader.lDataOffset;
                    break block22;
                }
                if (wordListLen == (nWordIndexOffset += 4)) break;
            }
            this.g_getString = getWord;
            bFound = true;
            this.g_nWordExplainLen = 256;
            this.g_nWordDataOffset += this.m_DictionaryHeader.lDataOffset;
        }
        if (bFound) {
            return nWordOffset;
        }
        return EDictNotFound;
    }

    public String getString() {
        return this.g_getString;
    }

    public long GetCloseIdxByIndex(long aIndex, int aNum, ReadInfo[] readInfo, int dirct) {
        int i;
        block30: {
            byte[] pWordListBuffer;
            int OldWordDataOffset;
            int WordDataOffset;
            long nLength;
            block31: {
                byte[] pWordListBuffer2;
                this.Reset(false);
                if (!this.m_bDictionaryOpened) {
                    return EDictBadDatabase;
                }
                if (aIndex < 0L || aIndex >= (long)this.m_DictionaryHeader.lDataOffset) {
                    return EDictInvalidIndex;
                }
                nLength = (aNum + 1) * (this.m_DictionaryHeader.lMaxWordLength + 3) * 2;
                i = 0;
                WordDataOffset = 0;
                OldWordDataOffset = 0;
                if (dirct != 1) break block31;
                long nOffset = aIndex - (long)this.m_DictionaryHeader.lWordListOffset;
                if (nLength + aIndex > (long)this.m_DictionaryHeader.lWordListLength) {
                    nLength = (long)this.m_DictionaryHeader.lWordListLength - nOffset;
                }
                if ((pWordListBuffer2 = new byte[(int)nLength]) == null) {
                    return EDictOutOfMemory;
                }
                long nErrorCode = this.ReadDictionary(aIndex, nLength, pWordListBuffer2);
                if (nErrorCode != (long)EDictNoError) {
                    return nErrorCode;
                }
                int pWordPointer = 0;
                i = 0;
                while (i <= aNum) {
                    char[] word;
                    if (i != aNum) {
                        readInfo[i].wordListOffset = nOffset + (long)pWordPointer + (long)this.m_DictionaryHeader.lWordListOffset;
                    }
                    if ((word = KByteStream.toCharArray(pWordListBuffer2, pWordPointer)).length == 0) {
                        readInfo[i - 1].dataLength = 256;
                    } else {
                        if (i != aNum) {
                            readInfo[i].word = new String(word);
                        }
                        WordDataOffset = KByteStream.toInt(pWordListBuffer2, pWordPointer += word.length * 2 + 2, 4);
                        if (i > 0) {
                            readInfo[i - 1].dataLength = WordDataOffset - OldWordDataOffset;
                        }
                        OldWordDataOffset = WordDataOffset;
                        if ((pWordPointer += 4) >= 1 && (long)pWordPointer < nLength) {
                            if (i != aNum) {
                                readInfo[i].dataOffset = WordDataOffset + this.m_DictionaryHeader.lDataOffset;
                            }
                            ++i;
                            continue;
                        }
                    }
                    break block30;
                }
                break block30;
            }
            if (dirct != 0) break block30;
            long nOffset = aIndex - (long)this.m_DictionaryHeader.lWordListOffset - nLength;
            if (nOffset < 0L) {
                nOffset = 0L;
            }
            if ((pWordListBuffer = new byte[(int)nLength]) == null) {
                return EDictOutOfMemory;
            }
            long nErrorCode = this.ReadDictionary(nOffset + (long)this.m_DictionaryHeader.lWordListOffset, nLength, pWordListBuffer);
            if (nErrorCode != (long)EDictNoError) {
                return nErrorCode;
            }
            if (nOffset == 0L) {
                int pWordPointer = 0;
                i = 0;
                while (i <= aNum) {
                    char[] word;
                    if (i != aNum) {
                        readInfo[i].wordListOffset = pWordPointer + this.m_DictionaryHeader.lWordListOffset;
                    }
                    if ((word = KByteStream.toCharArray(pWordListBuffer, pWordPointer)).length == 0) {
                        readInfo[i].dataLength = 256;
                    } else {
                        if (i != aNum) {
                            readInfo[i].word = new String(word);
                        }
                        WordDataOffset = KByteStream.toInt(pWordListBuffer, pWordPointer += word.length * 2 + 2, 4);
                        if (i > 0) {
                            readInfo[i - 1].dataLength = WordDataOffset - OldWordDataOffset;
                        }
                        OldWordDataOffset = WordDataOffset;
                        if ((pWordPointer += 4) >= 1 && (long)pWordPointer < nLength) {
                            if (i != aNum) {
                                readInfo[i].dataOffset = WordDataOffset + this.m_DictionaryHeader.lDataOffset;
                            }
                            ++i;
                            continue;
                        }
                    }
                    break;
                }
            } else {
                int pWordPointer = (int)nLength;
                i = 0;
                while (i < aNum) {
                    readInfo[aNum - i - 1].wordListOffset = aIndex + (long)pWordPointer - nLength;
                    char[] word = KByteStream.findPrevWord(pWordListBuffer, pWordPointer);
                    pWordPointer -= 4;
                    if (word.length == 0) {
                        readInfo[aNum - i - 1].dataLength = 256;
                    } else {
                        readInfo[aNum - i - 1].word = new String(word);
                        WordDataOffset = KByteStream.toInt(pWordListBuffer, pWordPointer, 4);
                        readInfo[aNum - i - 1].dataLength = i == 0 ? (int)(readInfo[0].dataOffset - (long)WordDataOffset) - this.m_DictionaryHeader.lDataOffset : OldWordDataOffset - WordDataOffset;
                        OldWordDataOffset = WordDataOffset;
                        if ((pWordPointer -= word.length * 2 + 2) >= 1 && (long)pWordPointer < nLength) {
                            readInfo[aNum - i - 1].dataOffset = WordDataOffset + this.m_DictionaryHeader.lDataOffset;
                            ++i;
                            continue;
                        }
                    }
                    break;
                }
            }
        }
        return i;
    }

    public char[] GetExplainByIndex() {
        byte[] pDataPointer;
        if (this.g_nWordExplainLen == 0) {
            this.g_nWordExplainLen = 256;
        }
        if ((pDataPointer = new byte[this.g_nWordExplainLen]) == null) {
            return null;
        }
        long ErrorCode = this.ReadDictionary(this.g_nWordDataOffset, this.g_nWordExplainLen, pDataPointer);
        if (ErrorCode != (long)EDictNoError) {
            return null;
        }
        return KByteStream.toCharArray(pDataPointer, 0, this.g_nWordExplainLen);
    }

    public char[] GetExplainByIndex(long aIndex, int wordExplainLen) {
        byte[] pDataPointer = new byte[wordExplainLen];
        System.out.println(wordExplainLen);
        if (pDataPointer == null) {
            return null;
        }
        long ErrorCode = this.ReadDictionary(aIndex, wordExplainLen, pDataPointer);
        System.out.println(ErrorCode);
        if (ErrorCode != (long)EDictNoError) {
            return null;
        }
        return KByteStream.toCharArray(pDataPointer, 0, wordExplainLen);
    }

    public static String mappingDict(String str, int langFlag) {
        StringBuffer strDictName = new StringBuffer();
        if (langFlag == 0) {
            strDictName.append("/ec/");
            str = str.trim();
            strDictName.append(str.charAt(0));
            strDictName.append("_ec.DIC");
        } else {
            strDictName.append("/ce/");
            int size = strCEList.length;
            int i = 0;
            i = 0;
            while (i < size) {
                if (i == size - 1 || str.compareTo(strCEList[i]) >= 0 && str.compareTo(strCEList[i + 1]) < 0) break;
                ++i;
            }
            strDictName.append(i + 1);
            strDictName.append("_ce.DIC");
        }
        System.out.println(strDictName.toString());
        return strDictName.toString();
    }
}

