if(!window.widget) {
	/*
	window.innerWidth = 240;
	window.innerHeight = 320;
	window.addEventListener(
		"resize",
		function() {
			if(window.innerWidth != 240) {
				window.innerWidth = 240;
			}
			if(window.innerHeight != 320) {
				window.innerHeight = 320;
			}
		},
		false
	);
	*/
	
	
	/**
	 * Widget simulation
	 */
	function getIdentifier() {
		/*
		xml = document.implementation.createDocument("", "", null);
		xml.async = false;
		xml.load("info.plist");
		
		var keys = xml.getElementsByTagName("key");
		for(var i = 0; i < keys.length; i++) {
			var key = keys[i];
			
			if(key.firstChild.nodeValue == "Identifier") {
				var value = key.nextSibling;
				while(value && value.nodeType != Node.ELEMENT_NODE) {
					value = value.nextSibling;
				}
				if(value && value.firstChild) {
					return value.firstChild.nodeValue;
				}
			}
		}
		*/
		
		return "";
	}
	
	window.widget = {
		openURL: function(url) {
			window.open(url);
		},
		setPreferenceForKey: function(value, key, expire) {
			key = escape(key);
			value = escape(value);
			
			var date = new Date();
			if (expire=='') {
				date.setFullYear(date.getFullYear() + 1);
			}
			else {
				date.setTime(date.getTime() + expire*1000);
			}
			var partSize = 1024;
			
			var expireDate = new Date();
			expireDate.setTime(expireDate.getTime() - 1);
			
			var index = 0;
			var part;
			while(true) {
				part = value.substr(partSize * index, partSize);
				var partKey = key;
				if(index > 0) {
					partKey = partKey + "#" + index;
				}
				
				if(part.length > 0) {
					document.cookie = partKey + "=" + part + "; expires=" + date.toGMTString();
				}
				else {
					document.cookie = partKey + "=; expires=" + expireDate.toGMTString();
					return;
				}
				
				index++;
			}
		},
		preferenceForKey: function(key) {
			key = escape(key);
			
			var result = "";
			var index = 0;
			while(true) {
				var partKey = key;
				if(index > 0) {
					partKey = partKey + "#" + index;
				}
				
				var matcher = document.cookie.match(partKey + "=(.*?)(?:;|$)");
				if(matcher) {
					result = result + unescape(matcher[1]);
				}
				else {
					if(index > 0) {
						return unescape(result);
					}
					else {
						return;
					}
				}
				
				index++;
			}
		},
		prepareForTransition: function(name) {},
		performTransition: function() {},
		setNavigationEnabled: function(enabled) {},
		openApplication: function(uid, params) {
			alert("widget.openApplication(" + uid +", " + params + ")");
		},
		setDisplayLandscape: function() {},
		setDisplayPortrait: function() {},
		identifier: getIdentifier(),
		onshow: null,
		onhide: null,
		isrotationsupported: false,
		isSimulated: true
	};
	
	
	/**
	 * Menu simulation
	 */
	var MenuItem = window.MenuItem = function(label, id) {
		if(label) {
			this.__label = label;
		}
		if(id) {
			this.__id = id;
		}
		this.__enabled = true;
		this.__children = [];
	}
	MenuItem.prototype = {
		append: function(child) {
			var children = this.__children;
			for(var i = 0; i < children.length; i++) {
				if(child == children[i]) {
					return;
				}
			}
			children.push(child);
		},
		remove: function(child) {
			var children = this.__children;
			for(var i = 0; i < children.length; i++) {
				if(child == children[i]) {
					children.splice(i, 1);
					return;
				}
			}
		},
		setDimmed: function(dimmed) {
			this.__enabled = !dimmed;
		},
		onSelect: null
	};
	
	window.menu = {
		__visible: false,
		__children: [],
		append: function(menuItem) {
			if(!(menuItem && menuItem instanceof MenuItem)) {
				return;
			}
			
			var children = this.__children;
			for(var i = 0; i < children.length; i++) {
				if(menuItem == children[i]) {
					return;
				}
			}
			children.push(menuItem);
		},
		remove: function(menuItem) {
			var children = this.__children;
			for(var i = 0; i < children.length; i++) {
				if(menuItem == children[i]) {
					children.splice(i, 1);
					return;
				}
			}
		},
		getMenuItemById: function(id) {
			var children = this.__children;
			for(var i = 0; i < children.length; i++) {
				var menuItem = children[i];
				if(menuItem.__id == id) {
					return menuItem;
				}
			}
			return;
		},
		getMenuItemByName: function(name) {
			var children = this.__children;
			for(var i = 0; i < children.length; i++) {
				var menuItem = children[i];
				if(menuItem.__label == name) {
					return menuItem;
				}
			}
			return;
		},
		setRightSoftkeyLabel: function(name, callback) {
			if(!name || name == "") {
				name = "Exit";
			}
			rightSoftMenu.innerHTML = "";
			rightSoftMenu.appendChild(document.createTextNode(name));
			
			if(typeof callback == "function") {
				rightSoftMenu.onclick = callback;
			}
			else {
				rightSoftMenu.onclick = function() {
					window.close();
				};
			}
		},
		showSoftkeys: function() {
			this.__visible = true;
		},
		hideSoftkeys: function() {
			this.__visible = false;
		},
		clear: function() {
			this.__children = [];
		},
		onShow: null
	}
	
	function showPopupMenu(menuItems) {
		menuPane.setItems(menuItems);
		menuPane.style.display = "";
	}
	
	function hidePopupMenu() {
		menuPane.innerHTML = "";
		menuPane.style.display = "none";
	}
	
	var menuBar = document.createElement("div");
	with(menuBar.style) {
		background = "navy";
		display = "none";
		position = "fixed";
		right = "0px";
		bottom = "0px";
		left = "0px";
		zIndex = "9999";
	}
	window.addEventListener(
		"load",
		function() {
			document.body.appendChild(menuBar);
		},
		false
	)
	
	var exitMenuItem = new MenuItem("Exit");
	exitMenuItem.onSelect = function() {
		window.close();
	}
	
	var leftSoftMenu = document.createElement("div");
	leftSoftMenu.onclick = function(event) {
		var options = menu.__children.slice(0);
		options.push(exitMenuItem);
		showPopupMenu(options);
		event.cancelBubble = true;
	};
	with(leftSoftMenu) {
		innerHTML = "Options";
		with(style) {
			color = "white";
			cssFloat = "left";
			cursor = "pointer";
			fontSize = "14px";
			fontWeight = "bold";
			padding = "2px 8px 2px 8px";
		}
	}
	menuBar.appendChild(leftSoftMenu);
	
	var rightSoftMenu = document.createElement("div");
	rightSoftMenu.onclick = function(event) {
		window.close();
	};
	with(rightSoftMenu) {
		innerHTML = "Exit";
		with(style) {
			color = "white";
			cssFloat = "right";
			cursor = "pointer";
			fontSize = "14px";
			fontWeight = "bold";
			padding = "2px 8px 2px 8px";
		}
	}
	menuBar.appendChild(rightSoftMenu);
	
	var menuPane = document.createElement("div");
	with(menuPane.style) {
		display = "none";
		border = "medium outset black";
		background = "silver";
		position = "fixed";
		bottom = "0px";
		left = "0px";
		width = "60%";
		zIndex = "9999";
		maxHeight = "60%";
		overflowX = "hidden";
		overflowY = "auto";
		padding = "2px 8px 2px 8px";
	}
	menuPane.setItems = function(menuItems) {
		menuPane.innerHTML = "";
		for(var i = 0; i < menuItems.length; i++) {
			var menuItem = menuItems[i];
			var label = document.createElement("div");
			with(label.style) {
				color = menuItem.__enabled ? "black" : "gray";
				cursor = "pointer";
				fontSize = "14px";
				fontWeight = "bold";
				height = "20px";
				lineHeight = "20px";
				overflow = "hidden";
			}
			label.menuItem = menuItem;
			label.appendChild(
				document.createTextNode(
					(menuItem.__children.length > 0 ? ">>" : "") + menuItem.__label
				)
			);
			if(menuItem.__enabled) {
				label.onclick = function() {
					hidePopupMenu();
					var menuItem = this.menuItem;
					var children = menuItem.__children;
					if(children.length > 0) {
						showPopupMenu(children);
					}
					else {
						var onSelect = menuItem.onSelect;
						onSelect && onSelect(menuItem.__id);
					}
				};
			}
			menuPane.appendChild(label);
		}
	}
	window.addEventListener(
		"load",
		function() {
			document.body.appendChild(menuPane);
		},
		false
	)
	
	
	window.addEventListener(
		"mousemove",
		function(event) {
			if(event.clientY >= window.innerHeight - 20) {
				if(menuPane.style.display == "none") {
					menuBar.style.display = "";
				}
			}
			else {
				menuBar.style.display = "none";
			}
		},
		false
	);
	window.addEventListener(
		"click",
		function(event) {
			hidePopupMenu();
		},
		false
	);
	/*
	menuBar.addEventListener(
		"mouseout",
		function(event) {
			if(event.target == this) {
				menuBar.style.display = "none";
			}
		},
		false
	);
	*/
	menuPane.addEventListener(
		"click",
		function(event) {
			event.cancelBubble = true;
		},
		false
	);
	/*
	menuPane.addEventListener(
		"mouseout",
		function(event) {
			if(event.target == this) {
				hidePopupMenu();
			}
		},
		false
	)
	*/
}

