﻿WidSets.local = {
	menu_widsets: "Widget选项",
	menu_about: "关于",
	menu_about_service: "关于Widget",
	menu_getmore: "获得更多Widget",
	menu_share: "分享此Widget",
	menu_reload: "重载Widget",
	menu_register: "注册服务",
	menu_registered_info: "注册信息",
	menu_help: "帮助",
	menu_exit: "AExit",

	btn_ok: "确定",
	btn_cancel: "取消",
	btn_back: "返回",
	btn_exit: "退出",
	btn_accept: "接受",
	btn_reject: "反对",
	btn_register: "注册",
	btn_login: "登录",
	btn_verify: "校验",
	btn_continue: "继续",
	disclaimer: "\
在使用Widget服务过程中会产生GPRS流量费用。\
具体详情请咨询当地移动运营商。<br/><br/>\
在您使用Widget服务前，您必须接受\
<a href=\"javascript:openPage(&quot;tos-zh_Hans.html&quot;);\">服务条款</a>。<br/>\
同时请查看<a href=\"javascript:openPage(&quot;privacy-zh_Hans.html&quot;);\">隐私\
政策</a>。",

	login_ask_header: "登录",
	login_captcha: "如要匿名使用，请输入校验图片中的字母。",
	login_captcha_retry: "输入的字母与校验图片中的不符合，请重试。",
	login_timeout_header: "登录超时",
	login_timeout_msg: "服务器暂时未响应。",
	login_timeout_wait: "确定",
	login_timeout_offline: "离线使用",
	login_canceled_header: "取消联网",
	login_canceled_msg: "此Widget需要访问网络。请重新启动Widget。",
	login_widget_expired: "<h3>Widget过期</h3><p>此Widget不再有效，将关闭。</p>",
	login_widget_disabled: "<h3>Widget过期</h3><p>此Widget不再有效，将关闭。</p>",

	login_header: "登录到Widget",
	login_content: "用您已有的帐号登录Widget服务。",
	login_content_retry: "用户名和密码不符合，请重试。",
	login_content_invalid_pref: "Widget中的账号信息不再有效，请输入您当前的用户名和密码。",
	login_username: "用户名",
	login_password: "密码",
	login_devmode_not_regd: "开发者模式的帐号还没有注册。",

	login_api_old: "此Widget已过期，不再被支持。",
	login_server_error: "服务现在中断。",

	tos_header: "服务条款",

	share_header: "分享此Widget",
	share_content: "输入您朋友的手机号，我们将给他发送一条含有Widget安装路径的短信。",
	share_name: "您的姓名:",
	share_phonenumber: "手机号:",
	share_share: "分享",
	share_in_progress: "分享Widget...",
	share_header_success: "Widget已分享!",
	share_header_failure: "Widget无法分享",
	share_error_200: "Widget分享成功。",
	share_error_400: "请输入您的姓名以分享此Widget。",
	share_error_404: "在服务器上没有找到此Widget。",
	share_error_502: "发送短信失败，请稍后重试。",
	share_error_506: "会话已过期。",

	newversion_header: "更新Widget",
	newversion_mandatory_content: "发现有此Widget的新版本。要想继续使用，您必须升级。",
	newversion_content: "发现有此Widget的新版本，您想现在就安装吗?",
	newversion_update: "更新",
	newversion_cancel: "以后",
	newversion_exit: "退出",

	reginfo_header: "注册信息",
	reginfo_uid: "用户名",
	reginfo_pwd: "密码",
	reload_widget: "重载Widget",

	about_msg: "Widget是基于Web Runtime (WRT)的轻量级应用程序，它方便快捷地把互联网内容及服务呈现在手机上，带给用户个性化的手机互联网体验。<br/><br/>了解更多：<br/>partner@cn.widsets.com"
};

function openPage(pageFile) {
	var request = new XMLHttpRequest();
	request.onreadystatechange = function() {
		if(request.readyState == 4) {
			new Page(request.responseText).push();
		}
	}
	request.open("get", pageFile, true);
	request.send(null);
	
	function Page(html) {
		var self = this;
		
		var root = document.createElement("div");
		root.id = "tosDiv";
		with(root.style) {
			position = "absolute";
			top = "0px";
			right = "0px";
			left = "0px";
			minHeight = "100%";
			background = "white";
			zIndex = "6000";
		}
		root.innerHTML = html;
		
		this.push = function() {
			document.body.appendChild(root);
			menu.clear();
			menu.setRightSoftkeyLabel(
				WidSets.i18n("btn_back"),
				function() {
					self.pop();
				}
			);
			menu.showSoftkeys();
			widget.setNavigationEnabled(true);
		}
		
		this.pop = function() {
			menu.clear();
			document.body.removeChild(root);
			//widget.setNavigationEnabled(WidSets.openPanel ? false : WidSets.navigationEnabled);
			widget.setNavigationEnabled(WidSets.openPanel ? true : WidSets.navigationEnabled);
			/*
			if(WidSets.openPanel)
			{
				widget.setNavigationEnabled(WidSets.isN86Run);
			}
			else
				widget.setNavigationEnabled(WidSets.navigationEnabled);
				*/
			if(WidSets.initialized) {
				WidSets.invalidateMenu();
			}
			WidSets.resetRightSoftkeyLabel();
			if(openPanel = WidSets.openPanel) {
				var ctl = openPanel.controls[openPanel.selectedControl];
				WidSets.focus(ctl);
			}
		}
	}
}
