﻿/* ==========================================================================
 *  Name        : api.js
 *  Part of     : WidSets JavaScript API
 *  Build       : 2008-11-17T09:41:01
 *
 *  Copyright (c) 2006-2008 Nokia Corporation.
 *  This material, including documentation and any related computer
 *  programs, is protected by copyright controlled by Nokia Corporation.
 * ======================================================================= */


document.write("\
<style type=\"text/css\">\
#wsdlg {overflow:auto;color:#fff; background:url(widsets/assets/bkg_black.png); z-index:5000; position:fixed; top:0; left:0; width:100%; height:100%;}\
#wsdlg_frame {position: fixed; left:0px;bottom:2px; text-align:center; width:100%; z-index: 101}\
#wsdlg_frame table {width:100%; border-collapse:collapse; margin:auto; padding:0; border-width:0}\
#wsdlg_frame .tl {width:8px; height:8px; background:url(widsets/assets/dialog_corners.png) no-repeat top left}\
#wsdlg_frame .t {height:8px; background:url(widsets/assets/dialog_h_edge.png) repeat-x top center}\
#wsdlg_frame .tr {width:8px; height:8px; background:url(widsets/assets/dialog_corners.png) no-repeat top right}\
#wsdlg_frame .ml {width:8px; background:url(widsets/assets/dialog_v_edge.png) repeat-y top left}\
#wsdlg_frame .c { background:#FFF url(widsets/assets/dialog_bg.png) repeat-x; color: #000; text-align:center}\
#wsdlg_frame .mr {width:8px; height:8px; background:url(widsets/assets/dialog_v_edge.png) repeat-y top right}\
#wsdlg_frame .bl {width:8px; height:8px; background:url(widsets/assets/dialog_corners.png) no-repeat bottom left}\
#wsdlg_frame .b {height:8px; background:url(widsets/assets/dialog_h_edge.png) repeat-x bottom center}\
#wsdlg_frame .br {width:8px; height:8px; background:url(widsets/assets/dialog_corners.png) no-repeat bottom right}\
#wsdlg_frame td.error {background:#FFF5EB url(widsets/assets/error_icon.png) no-repeat 4px 4px; color:#F26D28; padding: 4px 4px 2px 20px}\
#wsdlg_vscroller {width:0px; background:#FFF url(widsets/assets/dialog_bg.png) no-repeat top left; vertical-align: top; padding: 0; margin:0}\
#wsdlg_vscroller > div {background:url(widsets/assets/dialog_sb_bg.png) repeat-y top left}\
#wsdlg_vscroller > div > div {width:8px; height:4px; background:url(widsets/assets/dialog_sb_top.png) no-repeat bottom left}\
#wsdlg_vscroller > div > div + div {width:8px; background:url(widsets/assets/dialog_sb_thumb.png) repeat-y top left}\
#wsdlg_vscroller > div > div + div + div {width:8px; height:4px; background:url(widsets/assets/dialog_sb_end.png) no-repeat top left}\
#wsdlg_content form, #wsdlg_content td {padding: 0; margin: 0}\
#wsdlg_content h3 {font-size:14px; font-weight:bold;margin: 0 0 6px 0; color:#000}\
#wsdlg.big #wsdlg_content h3 {font-size:24px}\
#wsdlg_content p {margin: 6px 0 0 0; font-size:12px; font-weight:normal; word-break: break-all}\
#wsdlg.big #wsdlg_content p {font-size:20px}\
#wsdlg_content a {color: #000; text-decoration:underline}\
#wsdlg_content strong {padding-right: 2px}\
#wsdlg_content a.active,\
#wsdlg_content a:hover {color:#FFF; background:#0d92e3; text-decoration:none}\
#wsdlg_content input {height:12px; width:100%; border:solid 1px #000; margin:1px; background-color:#FFF; color:#000}\
#wsdlg.big #wsdlg_content input {height:20px}\
#wsdlg_content input.error {border:solid 1px #F26D28; background:#FFF5EB url(widsets/assets/error_textfield.png) no-repeat center right}\
#wsdlg_content input.active {border:solid 2px #0d92e3; margin:1px; color:#000}\
#wsdlg_content input.checkbox {border-color: transparent}\
#wsdlg_content input.checkbox.active {border-color: #0d92e3}\
#wsdlg_content table {width:100%}\
#wsdlg.big #wsdlg_content th,\
#wsdlg.big #wsdlg_content td {font-size:20px}\
#wsdlg_controls {margin: 0; padding: 3px 0 0 0;}\
#wsdlg_controls a {color:#FFF; background:#000 url(widsets/assets/button_passive.png) repeat-x center center;\
 padding:4px 4px 2px 4px; margin:0 4px 0 0; border:solid 2px #5f5f5f; text-decoration:none}\
#wsdlg_controls a.active,\
#wsdlg_controls a:hover {background-image:url(widsets/assets/button_active.png); border:solid 2px #0d92e3}\
</style>\
");
if(typeof widget == "undefined") {
	document.write("<script type=\"text/javascript\" src=\"widsets/browser_emulation.js\"></script>");
}
document.write("<script type=\"text/javascript\" src=\"widsets_text_strings.js\"></script>");
document.write("<script type=\"text/javascript\" src=\"widsets/config.js\"></script>");


Function.prototype.ws_bind = function(object) {
	var __method = this;
	return function(event,att1,att2,att3) {
		var evt = event || window.event;
		if(evt && evt.srcElement) {
			evt.target = evt.srcElement;
		}
		return __method.call(object, evt, att1, att2, att3);
	}
};


var WidSets = new function() {
	this.developerMode = false;
	this.keys = null;
	this.allowOfflineUse = false;
	this.apiVersion = "1.0.8";
	this.proxy = null;
	this.sessionID = "";
	this.folder = "";
	this.local = {};
	this.apiURL = "http://www.widsets.com/wsapi/";
	this.mobiURL = "http://widsets.mobi/";
	this.openPanel = null;
	this.sysinfo = null;
	//this.navigationEnabled = false;
	this.userAgent = navigator.userAgent.toLowerCase();
	this.navigationEnabled = true;//(this.userAgent.indexOf("nokian86")==-1)?false:true;
	this.initialized = false;
	this.offline = true;
	this.imagesToPreload = [
		"widsets/assets/bkg_black.png",
		"widsets/assets/dialog_bg.png",
		"widsets/assets/dialog_corners.png",
		"widsets/assets/dialog_v_edge.png",
		"widsets/assets/dialog_h_edge.png",
		"widsets/assets/button_active.png",
		"widsets/assets/loading_animation.gif"
	];
	this.onInitialize = null;
	this.onCreateMenu = null;
	this.onDialogOpened = null;
	this.onDialogClosed = null;
	this.onShowAbout = null;
	this.onShowHelp = null;
	
	this.tryInvokeCallback = function(callback) {
		if(typeof callback == "function") {
			try{
				callback();
			}
			catch(err){
				WidSets.trace("Exception in callback " + /([$_\w\d]+)/.exec(callback)[1] + ": " + err);
			}
		}
	};
	
	this._onCreateMenu = function(parent) {
		if(typeof this.onCreateMenu == "function") {
			try{
				this.onCreateMenu(parent);
			}
			catch(err) {
				WidSets.trace("An error occured during onCreateMenu: " + err);
			}
		}
	};
	
	this.showWidSetsMenu = true;  				
	this.showTOSDialog = true;    				
	this.loadWidSetsMini = true;  								
	this.isShowMini = null; 	 				    							
	this.miniView = null ;       				
	this.onShowMini = null;      				
	this.onShowMain = null;      								
	this.fromView = 0;           				
	//this.onPageMenu = null; 
	this.focusControl = null;     				
	this.showView = function(){	
		WidSets.isShowMini = window.innerHeight<150?true:false; 
		if(WidSets.isShowMini){
			if(WidSets.miniView.style.display != 'block')
				WidSets.miniView.style.display = 'block';
			if(document.getElementById('tosDiv'))
				document.body.removeChild(document.getElementById('tosDiv'));
			if(WidSets.openPanel){
				document.body.removeChild(WidSets.openPanel.element);
				WidSets.openPanel = null;
			}
			WidSets.fromView = 0;
			if(widget.preferenceForKey("WidSets_ToS_accepted") == "true"){
				if(typeof WidSets.onShowMini == "function") {
					WidSets.onShowMini();
				}
			}
		}
		else if (WidSets.fromView == 0){
			if(WidSets.miniView.style.display != 'none')
				WidSets.miniView.style.display = 'none';
			if(WidSets.tosAccepted){
				if(WidSets.fromView == 0)
					WidSets.doFirstLogin(null);
			}
			else
				WidSets.configLoaded();
			if(typeof WidSets.onShowMain == "function") {
				WidSets.onShowMain();
			}
			WidSets.fromView = 1;
		}
	}
	
	this.initialize = function() {
		if(WidSets.loadWidSetsMini){
			WidSets.isShowMini = window.innerHeight<150?true:false; 
			if(WidSets.isShowMini){
				if(!WidSets.miniView)
					WidSets.miniView = new WidSets.miniElement;
				WidSets.local.newversion_mandatory_content = "发现有此Widget的新版本。要想继续使用，您必须升级。您需要首先将Widget从主屏幕中删除，然后重新运行Widget，才能进行升级。";
				WidSets.local.newversion_content = "发现有此Widget的新版本，您想现在就安装吗? 您需要首先将Widget从主屏幕中删除，然后重新运行Widget，才能进行升级。";
				window.setTimeout(WidSets.showView.ws_bind(this),500);
				window.addEventListener("resize", WidSets.showView.ws_bind(this), false);
			}
		}
	
		if(typeof addBrowserWRTEmulation == "function") {
			addBrowserWRTEmulation();
		}
		
		//widget.setNavigationEnabled(false);
		widget.setNavigationEnabled(WidSets.navigationEnabled);
		
		this.preloadImages(WidSets.imagesToPreload);
		
		WidSets.sysinfo = document.embeds["ws_system_api"];
		if(WidSets.sysinfo) {
			var si = document.getElementById("ws_system_api");
			WidSets.languageCode = WidSets.sysinfo.language;
			if(si) {
				si.style.display = "none";
			}
		}
		
		if(WidSets.config && WidSets.config.apiUrl) {
			this.apiURL = WidSets.config.apiUrl;
		}
		if(WidSets.config && WidSets.config.mobiUrl) {
			this.mobiURL = WidSets.config.mobiUrl;
		}
		
		if(this.apiURL[this.apiURL.length - 1] != "/") {
			this.apiURL += "/";
		}
		if(this.mobiURL[this.mobiURL.length - 1] != "/") {
			this.mobiURL += "/";
		}
		
		if(WidSets.developerMode) {
			new WidSets.request(
				"config.xml", null, this.configLoaded.ws_bind(this), this.configLoaded.ws_bind(this)
			);
		}
		else {
			this.configLoaded(null);
		}
	};
	this.loggedIn = function() {
		window.setTimeout(
			this.delayedInitialization.ws_bind(this), 1
		);
	};
	
	this.delayedInitialization = function() {
		this.initialized = true;
		this.parseSharedPreferences();
		if(!this.offline) {
			this.sessionPinger = new WidSets.ping();
		}
		if(typeof WidSets.onInitialize == "function") {
			try{
				WidSets.onInitialize();
			}
			catch(err){
				WidSets.trace("An error occured during onInitialize: " + err);
			}
		}
		
		//if(typeof WidSets.onPageMenu == "function") {
		//		WidSets.onPageMenu();
		//}
	};
	
	this.username = function() {
		return widget.preferenceForKey("ws_uid") || (WidSets.config ? WidSets.config.uid : null);
	};
	
	this.password = function() {
		return widget.preferenceForKey("ws_pwd") || (WidSets.config ? WidSets.config.pwd : null);
	};
	
	this.invalidateMenu = function() {
		menu.clear();
		
		if(this.developerMode) {
			var m = new MenuItem(WidSets.i18n("menu_reload"), 50001);
			menu.append(m);
			m.onSelect = function() {
				location.reload();
			};
		}
		
		var ws_menu = new MenuItem(WidSets.i18n("menu_widsets"), 50002);
		var ws_help = new MenuItem(WidSets.i18n("menu_help"), 50006);
		var ws_about = new MenuItem(WidSets.i18n("menu_about"), 50007);
		var ws_share = new MenuItem(WidSets.i18n("menu_share"), 50005);
		var ws_more = new MenuItem(WidSets.i18n("menu_getmore"), 50004);
		var ws_about_service = new MenuItem(WidSets.i18n("menu_about_service"), 50003);
		
		//CHANGE: read initialized status to prevent Back-menu issue in dialogs
		if(WidSets.initialized) {
			if(WidSets.showWidSetsMenu)
			{
				menu.append(ws_menu);
				WidSets._onCreateMenu(ws_menu);
			}
		}
		if(WidSets.showWidSetsMenu)
			menu.append(ws_more);
		
		//REMOVE: remove share menu due to malfunction
		//menu.append(ws_share);
		
		if(typeof WidSets.onShowHelp == "function") {
			ws_menu.append(ws_help);
		}
		
		if(typeof WidSets.onShowAbout == "function") {
			ws_menu.append(ws_about);
		}
		
		if(WidSets.showWidSetsMenu)
			menu.append(ws_about_service);
		
		ws_about.onSelect = function() {
			WidSets.tryInvokeCallback(WidSets.onShowAbout);
		};
		
		ws_help.onSelect = function(){
			WidSets.tryInvokeCallback(WidSets.onShowHelp);
		};
		
		ws_share.onSelect = this.shareWidget.ws_bind(this);
		
		ws_about_service.onSelect = function() {
			//CHANGE: add special logic for About page in Chinese
			var message = WidSets.local["about_msg"];
			if(message) {
				new WidSets.dialog(message);
			}
			else {
				widget.openURL(WidSets.mobiURL+"widgets/about.html");
			}
		};
		
		ws_more.onSelect = function() {
			var extras = "", uid = WidSets.username(), pwd = WidSets.password();
			if(uid && pwd) {
				extras = "?username=" + encodeURIComponent(uid) + "&password=" + encodeURIComponent(pwd);
			}
			widget.openURL(WidSets.mobiURL);
		};
		menu.showSoftkeys();
	};
	
	this.setRightSoftkeyLabel = function(label, handler) {
		var old = this.softkeyData;
		this.softkeyData = {
			label: label,
			handler: handler
		};
		menu.setRightSoftkeyLabel(label, handler);
		return old;
	};
	
	this.resetRightSoftkeyLabel = function() {
		if(this.softkeyData) {
			menu.setRightSoftkeyLabel(this.softkeyData.label, this.softkeyData.handler);
		}
		else {
			menu.setRightSoftkeyLabel("", null);
		}
	};
	
	this.makeBaseUrl = function(command, includeSessionID) {
		return WidSets.apiURL + command + (includeSessionID ? ";jsessionid=" + WidSets.sessionID : "");
	};
	
	this.makeMobiBaseUrl = function(command, includeSessionID) {
		return WidSets.mobiURL + command + (includeSessionID ? ";jsessionid=" + WidSets.sessionID:"");
	};
	
	this.setNavigationEnabled = function(navigationMode) {
		this.navigationEnabled = !!navigationMode;
		if(!WidSets.openPanel) {
			widget.setNavigationEnabled(navigationMode);
		}
	};
	
	this.shareWidget = function() {
		new WidSets.shareWidgetDialog();
	};
	
	this.setSharedPreferences = function(arr) {
		if(typeof arr != "object") {
			throw "WidSets.setSharedPreferences only accepts arrays.";
		}
		
		this.sharedPreferences = arr;
	};
	
	this.setBannerContainers = function(arr) {
		if(!arr) {
			throw"Expected an array";
		}
		
		for(var e, i = 0; i < arr.length; i++) {
			if((e = document.getElementById(arr[i])) != null) {
				new WidSets.banner(e, arr[i]);
			}
		}
	};
	
	this.parseSharedPreferences = function() {
		if(!widget.preferenceForKey("ws_shared_preferences_saved")) {
			widget.setPreferenceForKey("true", "ws_shared_preferences_saved");
			var prefs = WidSets.config.shared_preferences;
			if(prefs) {
				for(var pref in prefs) {
					widget.setPreferenceForKey(prefs[pref], pref);
				}
			}
		}
	};
	
	this.trace = function(text) {
		if(!text || !WidSets.developerMode) {
			return false;
		}
		
		var box = document.getElementById("___pewpewlasors___");
		var msg = document.createElement("DIV");
		
		if(!box) {
			box = document.createElement("DIV");
			box.setAttribute("id", "___pewpewlasors___");
			box.setAttribute("style", "z-index:500; position:fixed; top:0; left:0; right:0; background-color:#000; color:#FFF; font-size:12px;");
			document.body.appendChild(box);
		}
		else{
			box.appendChild(document.createElement("HR"));
		}
		
		msg.appendChild(document.createTextNode(text));
		box.appendChild(msg);
		
		window.setTimeout(
			function() {
				box.removeChild(msg);
				if(box.firstChild) {
					box.removeChild(box.firstChild);
				}
				else {
					box.parentNode.removeChild(box);
				}
			},
			4000
		);
		
		return true;
	};
	
	this.exit = function() {
		menu.setRightSoftkeyLabel("", null);
		menu.showSoftkeys();
		menu.clear();
		window.close();
	};
	
	this.isAnonymous = function() {
		return widget.preferenceForKey("ws_anon") == "true" || !WidSets.username() || WidSets.config.anonymous_user == "true";
	};
	
	this.configLoaded = function(res) {
		/* * * *
		 * *  for miniView
		 * *   update by  zmy
		 * * * */
		try{
			if(WidSets.showTOSDialog)
			{
				if(widget.preferenceForKey("WidSets_ToS_accepted") != "true" && WidSets.isAnonymous()) {
					var instance=this;
					if(!WidSets.openPanel && !WidSets.isShowMini)
						new WidSets.termsOfServiceDialog(
							function() {
								instance.doFirstLogin(res);
							}
						);
				}
				else{
					if(!WidSets.isShowMini)
						window.setTimeout(this.doFirstLogin(res),1500);
				}
			}
			else{
				widget.setPreferenceForKey("true","WidSets_ToS_accepted");
				WidSets.tosAccepted = true;
			}
		}catch(e){
		//alert("WidSets.configLoaded Error: "+ e);
		}
	};
	
	this.doFirstLogin = function(confFile) {
		new WidSets.login(
			WidSets.username(),
			WidSets.password(),
			typeof confFile == "string" ? confFile : null
		);
	};
	
	this.preloadImages = function(sources) {
		if(!this.preloadedImages) {
			this.preloadedImages = [];
		}
		
		if(!sources || sources.length == 0) {
			return;
		}
		
		for(var i = 0; i<sources.length; i++) {
			var img = new Image();
			img.src = sources[i];
			this.preloadedImages.push(img);
		}
	};
	
	this.i18n = function(key) {
		return this.local && this.local[key] ? this.local[key] : key;
	};
	
	this.focus = function(element) {
		if(!element || element.nodeType != 1) {
			return;
		}
		
		element.focus();
		element.blur();
		element.focus();
	};
	
	if(/Series[6-9]0\/[3-9]/.exec(navigator.userAgent)) {
		this.keyMode = "charCode";
		this.keys = {
			UP: 63497,
			LEFT: 63495,
			RIGHT: 63496,
			DOWN: 63498,
			CENTER: 63557,
			//for N97 return key
			RETURN_KEY: 13,
			GREEN: 63586
		};
	}
	else {
		this.keyMode = "keyCode";
		this.keys = {
			UP: 38,
			LEFT: 37,
			RIGHT: 39,
			DOWN: 40,
			CENTER: 13,
			GREEN: 32
		};
	}
	
	window.addEventListener("load", this.initialize.ws_bind(this), false);
};
/**miniView module**/
WidSets.miniElement = function(){
	this.miniView = document.createElement("div");
	this.miniView.id = this.id;
	this.miniView.add =function(node){
		if(!node)
			return;
		if(typeof node == "string")
			this.innerHTML = node;
		else if(typeof node == "object")
			this.appendChild(node);
	};
	document.body.appendChild(this.miniView);
	with(this.miniView.style) {
		position=this.position; 
		zIndex=this.zIndex; 
		top=this.top; 
		right=this.right; 
		left=this.left; 
		bottom=this.bottom; 
		height=this.height; 
		width=this.width; 
		background=this.background;
	}
	return this.miniView ;
}
WidSets.miniElement.prototype = {id: "MiniView",position: "absolute",zIndex: "8000",display: "none",top: "0",bottom: "0",left: "0",right: "0",width: "313px",height: "85px",background: "#000000 url(miniview_banner.png) no-repeat"};
/** end **/

WidSets.termsOfServiceDialog = function(cb) {
	var tos = WidSets.i18n("disclaimer").replace(/\{0\}/g,WidSets.languageCode || "en");
	var html =
		"<h3>"+ WidSets.i18n("tos_header") + "</h3><p>"+ tos + "</p><p id=\"wsdlg_controls\"><a>" +
		WidSets.i18n("btn_accept") + "</a><a>" + WidSets.i18n("btn_reject") + "</a></p>"
	;
	this.cb = typeof cb == "function" ? cb : null;
	new WidSets.dialog(html, this.response.ws_bind(this));
};

WidSets.termsOfServiceDialog.prototype = {
	response: function(num, inputs, controls) {
		switch(num) 
		{
			case 3: 
			{
				widget.setPreferenceForKey("true","WidSets_ToS_accepted");
				WidSets.tosAccepted = true;
				this.cb && this.cb();
				break;
			}
			default: 
			{
				WidSets.exit();
			}
		}
	}
};


WidSets.shareWidgetDialog = function() {
	var name = WidSets.isAnonymous() ? "" : WidSets.username();
	var html = "\
<h3>" + WidSets.i18n("share_header") + "</h3>\
<p>" + WidSets.i18n("share_content") + "</p>\
<form method=\"post\" action=\"?\">\
<table>\
<tr>\
<td class=\"right\"><strong>" + WidSets.i18n("share_name") + "</strong></td>\
<td class=\"left\"><input name=\"ws_sender\" type=\"text\" id=\"ws_sender\" value=\"" + escape(name) + "\"/>\
</td>\
</tr>\
<tr>\
<td class=\"right\"><strong>" + WidSets.i18n("share_phonenumber") + "</strong></td>\
<td class=\"left\"><input name=\"ws_phonenumber\" type=\"text\" id=\"ws_phonenumber\" value=\"\"/></td></tr>\
<tr>\
<td></td>\
<td class=\"left pad\">\
<p id=\"wsdlg_controls\"><a>" + WidSets.i18n("share_share") + "</a><a>" + WidSets.i18n("btn_cancel") + "</a></p>\
</td>\
</tr>\
</table>\
</form>";
	new WidSets.dialog(html, this.shareWidgetResponse.ws_bind(this));
};

WidSets.shareWidgetDialog.prototype = {
	shareWidgetResponse: function(num,inputs) {
		if(num == 1 && inputs.length >= 2) {
			var url, params = {
				ws_wid: widget.identifier,
				ws_msisdn: inputs[1],
				ws_sender: inputs[0]
			};
			
			if(WidSets.sharedPreferences) {
				for(var i = 0; i < WidSets.sharedPreferences.length; i++) {
					params[WidSets.sharedPreferences[i]] =
						widget.preferenceForKey(WidSets.sharedPreferences[i])
					;
				}
			}
			
			this.progressBar = new WidSets.progressBarDialog(
				WidSets.i18n("share_in_progress"), true
			);
			
			var url = WidSets.request.addParameters(
				WidSets.makeBaseUrl("share", true), params
			);
			
			new WidSets.request(
				url, null,
				this.result.ws_bind(this),
				this.error.ws_bind(this)
			);
		}
	},
	result: function() {
		this.progressBar.close();
		new WidSets.dialog(
			"<h3>" + WidSets.i18n("share_header_success") + "</h3><p>" + WidSets.i18n("share_error_200") + "</p>"
		);
	},
	error: function(code) {
		this.progressBar.close();
		new WidSets.dialog(
			"<h3>" + WidSets.i18n("share_header_failure") + "</h3><p>" + WidSets.i18n("share_error_" + code) + "</p>"
		);
	}
};


WidSets.ping = function() {
	window.setInterval(
		function() {
			new WidSets.request(
				WidSets.makeBaseUrl("ping", true), null, null
			);
		},
		1000 * 60 * 5
	);
};
WidSets.login = function(uid, pwd, configFile, timeout) {
	this.sentParams = {
		ws_lang: WidSets.languageCode || "en",
		ws_resx: screen.availWidth,
		ws_resy: screen.availHeight,
		ws_apiver: WidSets.apiVersion,
		ws_timeout: 25 * 60
	};
	
	if(WidSets.tosAccepted) {
		this.sentParams.ws_tosaccepted = new Date().getTime();
	}
	
	if(widget.preferenceForKey("ws_identity")) {
		this.sentParams.ws_identity = widget.preferenceForKey("ws_identity");
	}
	
	if(uid) {
		this.sentParams.ws_uid = uid;
	}
	
	if(WidSets.developerMode) {
		this.sentParams.ws_pwd = pwd;
	}
	else{
		this.sentParams.ws_wid = widget.identifier;
		if(WidSets.config.widget_version) {
			this.sentParams.ws_version = WidSets.config.widget_version;
		}
		else if(!WidSets.triedToFetchWidgetVersion) {
			WidSets.triedToFetchWidgetVersion = true;
			var cb = function(res) {
				var plist = document.createElement("div");
				plist.innerHTML = res;
				var keys = plist.getElementsByTagName("key");
				for(var i = 0, c = keys.length; i < c; i++) {
					if(keys[i].innerHTML == "Version") {
						var node = keys[i].nextSibling;
						if(node.nodeType != 1) {
							node = node.nextSibling;
							WidSets.config.widget_version = node.innerHTML;
							break;
						}
					}
				}
				new WidSets.login(uid, pwd, configFile, timeout);
			};
			new WidSets.request("Info.plist", null, cb.ws_bind(this));
			return;
		}
		else{
			new WidSets.dialog("FATAL: Version not specified in config.xml or info.plist.", WidSets.exit);
		}
	}
	
	if(WidSets.developerMode && configFile){
		this.sentParams.ws_config = configFile;
	}
	
	this.timeoutId = window.setTimeout(
		this.timeout.ws_bind(this), parseInt(timeout) || 120000
	);
	
	setTimeout(
		function() {
			this.req = new WidSets.request(
				WidSets.makeBaseUrl("login"), this.sentParams, this.result.ws_bind(this), this.error.ws_bind(this)
			);
		}.ws_bind(this),
		1000
	);
};


WidSets.login.prototype = {
	result: function(result) {
		window.clearTimeout(this.timeoutId);
		widget.setPreferenceForKey(null, "ws_disabled");
		var res = null;
		try {
			this.loginResponse = res = JSON.parse(result);
		}
		catch(err) {
			this.error(-1);
			return;
		}
		if(typeof res == "object") {
			if(this.sentParams.ws_uid && this.sentParams.ws_pwd) {
				widget.setPreferenceForKey(this.sentParams.ws_uid, "ws_uid");
				widget.setPreferenceForKey(this.sentParams.ws_pwd, "ws_pwd");
			}
			WidSets.sessionID = res.sid;
			WidSets.country = res.country;
			if(res.identity) {
				widget.setPreferenceForKey(res.identity, "ws_identity");
			}
			if(res.msgexit) {
				new WidSets.dialog(res.msgexit, WidSets.exit);
			}
			else if(res.msg) {
				WidSets.offline = false;
				new WidSets.dialog(res.msg, WidSets.loggedIn.ws_bind(WidSets))
			}
			else if(res.mandatorynewversion) {
				if(WidSets.miniView)
					new WidSets.dialog(
						"<h3>" + WidSets.i18n("newversion_header") + "</h3><p>" +
						WidSets.i18n("newversion_mandatory_content") + "</p><p id=\"wsdlg_controls\"><a>" +
						"</a><a>" + WidSets.i18n("newversion_exit") + "</a></p>",
						this.mandatoryUpgradeResponse.ws_bind(this)
					);
				else
					new WidSets.dialog(
						"<h3>" + WidSets.i18n("newversion_header") + "</h3><p>" +
						WidSets.i18n("newversion_mandatory_content") + "</p><p id=\"wsdlg_controls\"><a>" +
						WidSets.i18n("newversion_update") + "</a><a>" +
						WidSets.i18n("newversion_exit") + "</a></p>",
						this.mandatoryUpgradeResponse.ws_bind(this)
					);
			}
			else if(res.newversion) {
				if(WidSets.miniView)
					new WidSets.dialog(
						"<h3>" + WidSets.i18n("newversion_header") + "</h3><p>" +
						WidSets.i18n("newversion_content") + "</p><p id=\"wsdlg_controls\"><a>" +
						"</a><a>" + WidSets.i18n("newversion_cancel") + "</a></p>",
						this.upgradeResponse.ws_bind(this)
					);
				else
					new WidSets.dialog(
						"<h3>" + WidSets.i18n("newversion_header") + "</h3><p>" +
						WidSets.i18n("newversion_content") + "</p><p id=\"wsdlg_controls\"><a>" +
						WidSets.i18n("newversion_update") + "</a><a>" +
						WidSets.i18n("newversion_cancel") + "</a></p>",
						this.upgradeResponse.ws_bind(this)
					);
			}
			else {
				WidSets.offline = false;
				WidSets.loggedIn();
			}
		}
		else {
			this.error(503);
		}
	},
	error: function(errorCode, statusText, responseBody){
		window.clearTimeout(this.timeoutId);
		
		switch(errorCode) {
			case 400:
			{
				new WidSets.dialog(WidSets.i18n("login_api_old"), WidSets.exit);
				break;
			}
			
			case 403:
			{
				new WidSets.dialog(WidSets.i18n("login_devmode_not_regd"), WidSets.exit);
				break;
			}
			
			case 404:
			{
				WidSets.offline = false;
				WidSets.loggedIn();
				break;
			}
			
			case 410:
			{
				new WidSets.dialog(WidSets.i18n("login_widget_expired"), WidSets.exit);
				break;
			}
			
			case 417:
			{
				var msg = responseBody.length > 0 ? responseBody : WidSets.i18n("login_widget_disabled");
				widget.setPreferenceForKey(msg, "ws_disabled");
				new WidSets.dialog(msg, WidSets.exit);
				break;
			}
			
			case 503:
			{
				new WidSets.dialog(WidSets.i18n("login_server_error"), WidSets.exit);
				break;
			}
			
			default:
			{
				var msg = widget.preferenceForKey("ws_disabled") || "";
				if(msg.length > 0) {
					new WidSets.dialog(msg, WidSets.exit);
				}
				
				if(WidSets.allowOfflineUse) {
					WidSets.offline = true;
					WidSets.loggedIn();
				}
				else{
					/*if(!WidSets.miniView)
						new WidSets.dialog(
							"<h3>" + WidSets.i18n("login_canceled_header") + "</h3><p>"+
							WidSets.i18n("login_canceled_msg") + "</p><p id=\"wsdlg_controls\"><a>"+
							WidSets.i18n("btn_exit") + "</a></p>",
							WidSets.exit
						);*/
					WidSets.offline = true;
					WidSets.loggedIn();
				}
				break;
			}
		}
	},
	timeout: function() {
		this.req.abort();
		var offline = !!WidSets.allowOfflineUse ? "<a>" + WidSets.i18n("login_timeout_offline") + "</a>" : "";
		new WidSets.dialog(
			"<h3>" + WidSets.i18n("login_timeout_header") + "</h3><p>" +
			WidSets.i18n("login_timeout_msg") + "</p><p id=\"wsdlg_controls\"><a>" +
			WidSets.i18n("login_timeout_wait") + "</a>" + offline + "</p>",
			WidSets.exit
		);
	},
	timeoutResponse: function(num, inputs) {
		if(num == 1) {
			new WidSets.login(
				this.sentParams.ws_uid,
				this.sentParams.ws_pwd,
				this.sentParams.ws_config,
				120000
			);
		}
		else{
			WidSets.offline = true;
			WidSets.loggedIn();
		}
	},
	mandatoryUpgradeResponse: function(selection) {
		window.clearTimeout(this.timeoutId);
		if(!WidSets.miniView){
			if(selection == 1) {
				widget.openURL(this.loginResponse.newversion);
			}
		}
		WidSets.exit();
		return 0;
	},
	upgradeResponse: function(selection) {
		window.clearTimeout(this.timeoutId);
		if(selection == 1) {
			widget.openURL(this.loginResponse.newversion);
			WidSets.exit();
			return 0;
		}
		else {
			WidSets.offline=false;
			WidSets.loggedIn();
		}
	}
};


WidSets.http = {
	urlPrefix: "http://",
	constructUrl: function(action, url, filter, reset) {
		var options = {ws_url: url, ws_reset: !!reset ? "1" : "0"};
		var u = WidSets.makeBaseUrl(action, true);
		if(filter) {
			options.ws_filter = filter;
		}
		if(this.urlPrefix) {
			u = u.replace(/^https?:\/\//i, this.urlPrefix);
		}
		return WidSets.request.addParameters(u,options);
	}
};


WidSets.https = {
	urlPrefix: "https://",
	constructUrl: WidSets.http.constructUrl
};


WidSets.http.get = function(url, resultHandler, errorHandler, filter, reset) {
	if(WidSets.offline) {
		if(typeof errorHandler == "function") {
			errorHandler(-1);
		}
		return null;
	}
	
	if(!/^({|(file|https?):\/\/)/.exec(url)) {
			throw "Absolute URL required";
	}
	
	return new WidSets.request(
		WidSets.http.constructUrl("http/get", url, filter, reset),
		null, resultHandler, errorHandler
	);
};


WidSets.http.post = function(url, parameters, resultHandler, errorHandler, filter, reset) {
	if(WidSets.offline) {
		if(typeof errorHandler == "function") {
			errorHandler(-1);
		}
		return null;
	}
	
	if(!/^({|(file|https?):\/\/)/.exec(url)) {
		throw "Absolute URL required";
	}
	
	return new WidSets.request(
		WidSets.http.constructUrl("http/post", url, filter, reset),
		parameters, resultHandler, errorHandler
	);
};


WidSets.https.get = function(url, resultHandler, errorHandler, filter, reset) {
	if(WidSets.offline){
		if(typeof errorHandler == "function") {
			errorHandler(-1);
		}
		return null;
	}
	
	if(!/^({|(file|https?):\/\/)/.exec(url)) {
		throw "Absolute HTTPS URL required";
	}
	
	return new WidSets.request(
		WidSets.http.constructUrl("https/get", url, filter, reset),
		null, resultHandler, errorHandler
	);
};


WidSets.https.post = function(url, parameters, resultHandler, errorHandler, filter, reset) {
	if(WidSets.offline) {
		if(typeof errorHandler == "function") {
			errorHandler(-1);
		}
		return null;
	}
	
	if(!/^({|(file|https?):\/\/)/.exec(url)) {
		throw "Absolute HTTPS URL required";
	}
	
	return new WidSets.request(
		WidSets.http.constructUrl("https/post", url, filter, reset),
		parameters, resultHandler, errorHandler
	);
};


WidSets.makeDialogFrame = function(withScroller) {
	var classes = [
		["tl", "t", "tr"],
		["ml", "c", "mr"],
		["bl", "b", "br"]
	];
	
	var div = document.createElement("DIV");
	var table = document.createElement("TABLE");
	var tbody = document.createElement("TBODY");
	div.id = "wsdlg_frame";
	table.cellSpacing = "0";
	table.cellPadding = "0";
	table.border = "0";
	table.appendChild(tbody);
	div.appendChild(table);
	for(var y =0; y < classes.length; y++) {
		var row = document.createElement("TR");
		for(var x = 0; x < classes[y].length; x++) {
			var cell = document.createElement(x==1 && y==1 ? "TH" : "TD");
			cell.className = classes[y][x];
			row.appendChild(cell);
		}
		tbody.appendChild(row);
	}
	return div;
};


WidSets.progressBarDialog = function(text, initiallyVisible) {
	var dialog = WidSets.makeDialogFrame();
	var contentCell = dialog.getElementsByTagName("TH")[0];
	var shade = document.createElement("DIV");
	var para = document.createElement("P");
	var bar = document.createElement("IMG");
	var isVisible = false;
	dialog.style.zIndex=1001;
	para.setAttribute("style", "font-weight:normal; font-size:12px; margin:10px 0 4px 0; padding: 0");
	shade.setAttribute(
		"style",
		"z-index:1000; position:fixed; top:0; left:0; right:0; bottom:0;  background-image:url(widsets/assets/bkg_black.png)"
	);
	para.appendChild(document.createTextNode(text));
	bar.setAttribute("src", "widsets/assets/loading_animation.gif");
	contentCell.appendChild(para);
	contentCell.appendChild(bar);
	var resize = function() {
		dialog.firstChild.style.width = window.innerWidth <= 280 ? "100%" : "280px";
	};
	this.show=function(){document.body.appendChild(shade);document.body.appendChild(dialog);document.addEventListener("resize",resize,false);resize();menu.clear();WidSets.tryInvokeCallback(WidSets.onDialogOpened);isVisible=true;};this.close=function(){if(!isVisible)
return;document.removeEventListener("resize",resize,false);document.body.removeChild(dialog);document.body.removeChild(shade);WidSets.invalidateMenu();WidSets.tryInvokeCallback(WidSets.onDialogClosed);isVisible=false;};this.visible=function(){return isVisible;};initiallyVisible&&this.show();};

WidSets.dialog = function(content, cb, omitButtons) {
	/*------- join*/
	if(WidSets.openPanel){
		document.body.removeChild(WidSets.openPanel.element);
		WidSets.openPanel = null;
	}
	/**/
	var frame = "<div id=\"wsdlg_frame\" style=\"word-break:break-all;\"><table border=\"0\" cellSpacing=\"0\" cellPadding=\"0\"><tr><td class=\"tl\"></td><td class=\"t\" colspan=\"2\"></td><td class=\"tr\"></td></tr><tr><td class=\"ml\"></td><td id=\"wsdlg_content\" class=\"c\" style=\"padding-left: 4px\"><div style=\"overflow: hidden; padding: 8px\">{0}</div></td><td id=\"wsdlg_vscroller\"><div><div></div><div></div><div></div></div></td><td class=\"mr\"></td></tr><tr><td class=\"bl\"></td><td class=\"b\" colspan=\"2\"></td><td class=\"br\"></td></tr></table></div>";
	WidSets.openPanel = this;
	this.widgetKeyHandlers = {
		down: document.onkeydown,
		up: document.onkeyup,
		press: document.onkeypress
	};
	document.onkeydown = null;
	document.onkeyup = null;
	document.onkeypress = null;
	this.listeners = {
		down: this.keyDown.ws_bind(this),
		up: this.keyUp.ws_bind(this),
		press: this.keyPress.ws_bind(this),
		resize: this.resize.ws_bind(this)
	};
	document.addEventListener("resize", this.listeners.resize, true);
  document.addEventListener("keydown", this.listeners.down, true);
	document.addEventListener("keyup", this.listeners.up, true);
	document.addEventListener("keypress", this.listeners.press, true);
	this.cb = typeof cb == "function" ? cb : null;
	this.element = document.createElement("DIV");
	this.element.setAttribute("id", "wsdlg");
	this.element.innerHTML = frame.replace("{0}", content);
	this.controls = [];
	this.buttons = [];
	var elements = this.element.getElementsByTagName("*");
	for(var i = 0; i < elements.length; i++) {
		switch(elements[i].tagName) {
			case "A":
			this.buttons.push(elements[i]);
			
			case "INPUT":
			this.controls.push(elements[i]);
		}
	}
	if(screen.availWidth > 600 || screen.availHeight > 600) {
		this.element.className = "big";
	}
	if(this.buttons.length == 0 && !omitButtons) {
		var wrapper = null, cells = this.element.getElementsByTagName("TD");
		for(var i = 0; i < cells.length; i++) {
			if(cells[i].id == "wsdlg_content") {
				wrapper=cells[i];
				break;
			}
		}
		wrapper.getElementsByTagName("DIV")[0].innerHTML +=
			"<p id=\"wsdlg_controls\"><a>" + WidSets.i18n("btn_ok") + "</a></p>"
		;
		this.buttons.push(wrapper.getElementsByTagName("A")[0]);
		this.controls.push(this.buttons[0]);
	}
	if(navigator.userAgent.indexOf("Samsung") >= 0) {
		this.element.firstChild.style.marginBottom = "25px";
	}
	var hasBigScreen = screen.availWidth > 400 || screen.availHeight > 400;
	var maxDialogWidth = hasBigScreen ? 400 : screen.availWidth;
	var table = this.element.getElementsByTagName("TABLE")[0];
	table.style.width = window.innerWidth > maxDialogWidth ? (maxDialogWidth - 20) + "px" : "100%";
	if(navigator.userAgent.indexOf("NokiaN97") >= 0) {
		table.style.width = "100%";
	}
	widget.prepareForTransition();
	document.body.appendChild(this.element);
	widget.performTransition();
	this.content = document.getElementById("wsdlg_content").firstChild;
	this.vscroller = document.getElementById("wsdlg_vscroller");
	this.vknob = this.vscroller.firstChild;
	if(this.contentHeight() > window.innerHeight - 32) {
		this.content.style.height = (window.innerHeight - 32) + "px";
	}
	this.updateVScroller();
	if(this.buttons.length > 0) {
		this.selectedControl = 0;
		this.setActiveControl(0);
		for(var i = 0; i < this.controls.length; i++) {
			this.controls[i].buttonIndex = i;
			this.controls[i].onclick = function(evt) {
				if(WidSets.openPanel.DO_NOTHING) {
					delete WidSets.openPanel.DO_NOTHING;
					return false;
				}
				WidSets.openPanel.setActiveControl(evt.target.buttonIndex);
				return WidSets.openPanel.selectControl(evt);
			};
			
		}
	}
	menu.clear();
	if(WidSets.initialized) {
		menu.setRightSoftkeyLabel(
			WidSets.i18n("btn_back"),
			function() {
				WidSets.openPanel.close();
			}
		);
	}
	else {
		menu.setRightSoftkeyLabel("", null);
	}
	widget.setNavigationEnabled(true);
	if(this.controls.length > 0) {
		WidSets.focus(this.controls[this.controls.length - 1]);
	}
	WidSets.tryInvokeCallback(WidSets.onDialogOpened);
	
	//Add mouseover logic, select the current focus control
  var wp = document.getElementById('wsdlg_content').getElementsByTagName("A");
  for(var i=0;i<wp.length;i++){        
    wp[i].style.cursor = "pointer";
    wp[i].onmouseover = (function(o){return function(){WidSets.focusControl = o};})(wp[i]);
    wp[i].onmouseout = function(){WidSets.focusControl = null};
  };
    
    
};

WidSets.dialog.prototype = {
	close: function(btn,inputs,controls) {
		WidSets.focus(window);
		WidSets.openPanel.isClosing = true;
		if(arguments.length < 2 || parseInt(btn) == NaN) {
			btn = -1;
			inputs=[];
			controls=[];
		}
		var closeActual = function() {
			widget.setNavigationEnabled(WidSets.navigationEnabled);
			document.removeEventListener("resize", WidSets.openPanel.listeners.resize, true);
			document.removeEventListener("keydown", WidSets.openPanel.listeners.down, true);
			document.removeEventListener("keyup", WidSets.openPanel.listeners.up, true);
			document.removeEventListener("keypress", WidSets.openPanel.listeners.press, false);
			document.body.removeChild(WidSets.openPanel.element);
			if(WidSets.initialized) {
				if(WidSets.openPanel.widgetKeyHandlers) {
					document.onkeydown = WidSets.openPanel.widgetKeyHandlers.down;
					document.onkeyup = WidSets.openPanel.widgetKeyHandlers.up;
					document.onkeypress = WidSets.openPanel.widgetKeyHandlers.press;
					WidSets.openPanel.widgetKeyHandlers = null;
				}
				WidSets.invalidateMenu();
				WidSets.resetRightSoftkeyLabel();
				/*---join*/	
				//if(typeof WidSets.onPageMenu == "function") {
				//	WidSets.onPageMenu();
				//}
			}
			WidSets.openPanel = null;
		};
		var callback = this.cb;
		if(btn == -1) {
			closeActual();
			callback && callback(btn,inputs,controls);
			WidSets.tryInvokeCallback(WidSets.onDialogClosed);
		}
		this.controls[this.selectedControl].className = this.controls[this.selectedControl].className.replace(/\bactive\b/,"");
		window.setTimeout(
			function() {
				WidSets.openPanel.controls[WidSets.openPanel.selectedControl].className += " active";
				window.setTimeout(
					function() {
						WidSets.openPanel.controls[WidSets.openPanel.selectedControl].className =
							WidSets.openPanel.controls[WidSets.openPanel.selectedControl].className.replace(/\bactive\b/, "")
						;
						window.setTimeout(
							function() {
								closeActual();
								try {
									callback && callback(btn,inputs,controls);
								}
								catch(err){}
								WidSets.tryInvokeCallback(WidSets.onDialogClosed);
							},
							100
						);
					},
					100
				);
			},
			100
		);
	},
	keyPress: function(e) {
		if(WidSets.openPanel.isClosing) {
			e.preventDefault();
			e.stopPropagation();
			return false;
		}
		
		//var ctl = this.controls[this.selectedControl];
		var ctl = WidSets.focusControl;
		switch(WidSets.keyMode == "keyCode" ? e.keyCode : e.charCode) {
			case WidSets.keys.GREEN:
			case WidSets.keys.CENTER:
			{
				if(ctl.tagName == "INPUT") {
					WidSets.openPanel.DO_NOTHING = true;
					WidSets.focus(ctl);
					break;
				}
				
				ctl.onclick({target:ctl});
				
				break;
			}
			case WidSets.keys.RETURN_KEY:
			{
				if(ctl.tagName == "INPUT") {
					WidSets.openPanel.DO_NOTHING = true;
					WidSets.focus(ctl);
					break;
				}
				
				ctl.onclick({target:ctl});
				
				break;
			}
			
			case WidSets.keys.LEFT:
			case WidSets.keys.UP:
			{
				this.setActiveControl(this.selectedControl - 1);
				break;
			}
			
			case WidSets.keys.RIGHT:
			case WidSets.keys.DOWN:
			{
				this.setActiveControl(this.selectedControl + 1);
				break;
			}
			
			default:
			{
				if(ctl.tagName=="INPUT")
				return true;
			}
		}
		
		e.preventDefault();
		e.stopPropagation();
		return false;
	},
	keyUp: function(e) {
		if(WidSets.openPanel.isClosing) {
			e.preventDefault();
			e.stopPropagation();
			return false;
		}
		
		if(this.controls[this.selectedControl].tagName == "INPUT") {
			return true;
		}
		
		e.preventDefault();
		e.stopPropagation();
		return false;
	},
	keyDown: function(e) {
		if(WidSets.openPanel.isClosing) {
			e.preventDefault();
			e.stopPropagation();
			return false;
		}
		
		if(this.controls[this.selectedControl].tagName == "INPUT") {
			return true;
		}
		
		e.preventDefault();
		e.stopPropagation();
		return false;
	},
	resize: function(e) {
		var hasBigScreen = screen.availWidth > 600 || screen.availHeight > 600;
		var maxDialogWidth = hasBigScreen ? 400 : 300;
		var table = WidSets.openPanel.element.getElementsByTagName("TABLE")[0];
		if(WidSets.openPanel.previousInnerHeight != window.innerHeight) {
			WidSets.openPanel.previousInnerHeight = window.innerHeight;
			widget.prepareForTransition();
			WidSets.openPanel.vscroller.style.width = "0px";
			WidSets.openPanel.vknob.style.display = "none";
			WidSets.openPanel.content.style.height = "";
			table.style.width = window.innerWidth > maxDialogWidth ? (maxDialogWidth - 10) + "px" : "100%";
			widget.performTransition();
			if(WidSets.openPanel.contentHeight() > window.innerHeight - 32) {
				WidSets.openPanel.content.style.height = (window.innerHeight - 32) + "px";
			}
			WidSets.openPanel.updateVScroller();
		}
		return true;
	},
	ensureElementIsVisible: function(node) {
		var y = 0, h = this.viewHeight();
		while(node.parentNode.parentNode.id != "wsdlg_content") {
			y += node.offsetTop;
			node = node.parentNode;
		}
		node.parentNode.scrollTop = y - (h / 2);
	},
	contentHeight: function() {
		return this.content.scrollHeight;
	},
	viewHeight: function() {
		return this.content.parentNode.offsetHeight;
	},
	scrollY: function() {
		return this.content.scrollTop;
	},
	updateVScroller: function() {
		if(!this.vscroller) {
			return;
		}
		var cHeight = this.contentHeight();
		var vHeight = this.viewHeight();
		var yScroll = this.scrollY();
		if(this.vknob.style.display == "none" && cHeight <= vHeight) {
			this.content.paddingLeft = "4px";
			return;
		}
		this.vknob.style.display = "none";
		if(cHeight > vHeight) {
			this.content.paddingLeft = "0px";
			this.vknob.firstChild.style.paddingTop = (yScroll / cHeight * vHeight) + "px";
			this.vknob.firstChild.nextSibling.style.height = (vHeight / cHeight * vHeight - 7) + "px";
			this.vknob.style.display = "block";
			this.vscroller.firstChild.style.width = "8px";
			this.vscroller.firstChild.style.height = vHeight + "px";
		}
	},
	selectControl: function(e) {
		if(this.controls.length == 0) {
			return false;
		}
		
		var ctl = this.controls[this.selectedControl];
		if(ctl.tagName == "INPUT") {
			this.focusedControl = ctl;
			WidSets.focus(ctl);
			return true;
		}
		else if(ctl.tagName == "A") {
			if(href = ctl.getAttribute("href")) {
				if(/^javascript:/.test(href)) {
					var exp = href.substr(11);
					eval(exp);
					return false;
				}
				else {
					widget.openURL(ctl.href);
					return false;
				}
			}
		}
		
		var inputs = this.element.getElementsByTagName("INPUT");
		var values = [];
		for(var i = 0; i<inputs.length; i++) {
			switch(inputs[i].type) {
				case "checkbox":
				{
					values.push(inputs[i].checked ? inputs[i].value : "");
					break;
				}
				
				default:
				{
					values.push(inputs[i].value);
				}
			}
		}
		
		this.close(
			this.selectedControl - (this.controls.length - this.buttons.length) + 1,
			values, this.controls
		);
		return true;
	},
	setActiveControl: function(index) {
		if(this.controls.length == 0) {
			return false;
		}
		
		if(index < 0 || index >= this.controls.length) {
			return;
		}
		
		index = index % this.controls.length;
		if(index < 0) {
			index = this.controls.length - 1;
		}
		
		for(var i = 0; i < this.controls.length; i++) {
			this.controls[i].blur();
		}
		this.focusedControl = null;
		
		this.controls[this.selectedControl].className = 
			this.controls[this.selectedControl].className.replace(/\bactive\b/, "")
		;
		//this.controls[index].className += " active";
		this.selectedControl = index;
		this.ensureElementIsVisible(this.controls[index]);
		this.updateVScroller();
		
		return false;
	}
};

WidSets.request = function(url, postParams, resultHandler, errorHandler) {
	//ADD: change FireFox priviledge setting
	if(window.netscape) {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
	}
	
	this.resultHandler = typeof resultHandler == "function" ? resultHandler : null;
	this.errorHandler = typeof errorHandler == "function" ? errorHandler: null;
	this.httpRequest = new XMLHttpRequest();
	this.httpRequest.onreadystatechange = this.readyState.ws_bind(this);
	if(WidSets.proxy && url.indexOf("http") == 0 && navigator.userAgent.indexOf("Series") == -1) {
		url = WidSets.proxy.replace("{url}", escape(url));
	}
	if(!postParams) {
		postParams = "";
		this.httpRequest.open("GET", url, true);
	}
	else{
		postParams = WidSets.request.toParamString(postParams);
		this.httpRequest.open("POST", url, true);
		this.httpRequest.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		this.httpRequest.setRequestHeader("Content-length", postParams.length);
		this.httpRequest.setRequestHeader("Connection", "close");
	}
	
	try{
		this.httpRequest.send(postParams);
	}
	catch(err) {
		if(this.errorHandler) {
			this.errorHandler(-1,err);
		}
	}
	
	return true;
};

WidSets.request.prototype = {
	readyState: function() {
		if(this.httpRequest.readyState != 4) {
			return;
		}
		
		var status = -1;
		try{
			status = parseInt(this.httpRequest.status);
		}
		catch(err) {
			WidSets.trace("Exception when parsing status code in WidSets.request: " + err);
		}
		
		if(status == 0 || status == 200 || isNaN(status)) {
			if(this.resultHandler) {
				try{
					this.resultHandler(this.httpRequest.responseText);
				}
				catch(err) {
					WidSets.trace("Exception in the resultHandler: "+err);
				}
			}
		}
		else {
			if(this.errorHandler) {
				try {
					this.errorHandler(status, this.httpRequest.statusText, this.httpRequest.responseText);
				}
				catch(err) {
					WidSets.trace("Exception in the errorHandler: "+err);
				}
			}
		}
	},
	abort: function(evt) {
		this.httpRequest.abort();
		delete this.httpRequest;
	}
};

WidSets.request.addParameters = function(url,params) {
	if(url.indexOf("?") == -1) {
		url += "?";
	}
	else {
		if(url.lastIndexOf("&") != url.length - 1) {
			url += "&";
		}
	}
	return url + WidSets.request.toParamString(params);
}

WidSets.request.toParamString = function(obj) {
	var params = [];
	for(var attr in obj) {
		params.push(attr + "=" + encodeURIComponent(obj[attr]));
	}
	return params.join("&");
}

JSON=function(){function f(n){return n<10?'0'+n:n;}
Date.prototype.toJSON=function(){return this.getUTCFullYear()+'-'+
f(this.getUTCMonth()+1)+'-'+
f(this.getUTCDate())+'T'+
f(this.getUTCHours())+':'+
f(this.getUTCMinutes())+':'+
f(this.getUTCSeconds())+'Z';};var m={'\b':'\\b','\t':'\\t','\n':'\\n','\f':'\\f','\r':'\\r','"':'\\"','\\':'\\\\'};function stringify(value,whitelist){var a,i,k,l,r=/["\\\x00-\x1f\x7f-\x9f]/g,v;switch(typeof value){case'string':return r.test(value)?'"'+value.replace(r,function(a){var c=m[a];if(c){return c;}
c=a.charCodeAt();return'\\u00'+Math.floor(c/16).toString(16)+
(c%16).toString(16);})+'"':'"'+value+'"';case'number':return isFinite(value)?String(value):'null';case'boolean':case'null':return String(value);case'object':if(!value){return'null';}
if(typeof value.toJSON==='function'){return stringify(value.toJSON());}
a=[];if(typeof value.length==='number'){l=value.length;for(i=0;i<l;i+=1){a.push(stringify(value[i],whitelist)||'null');}
return'['+a.join(',')+']';}
if(whitelist){l=whitelist.length;for(i=0;i<l;i+=1){k=whitelist[i];if(typeof k==='string'){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+':'+v);}}}}else{for(k in value){if(typeof k==='string'){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+':'+v);}}}}
return'{'+a.join(',')+'}';}}
return{stringify:stringify,parse:function(text,filter){var j;function walk(k,v){var i,n;if(v&&typeof v==='object'){for(i in v){if(Object.prototype.hasOwnProperty.apply(v,[i])){n=walk(i,v[i]);if(n!==undefined){v[i]=n;}}}}
return filter(k,v);}
if(/^[\],:{}\s]*$/.test(text.replace(/\\./g,'@').replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(:?[eE][+\-]?\d+)?/g,']').replace(/(?:^|:|,)(?:\s*\[)+/g,''))){j=eval('('+text+')');return typeof filter==='function'?walk('',j):j;}
throw new SyntaxError('parseJSON');}};}();

WidSets.image = function(url, scaleMode, width, height, cacheTimeout, resetHttpState, format) {
	this.toString = function() {
		return this.getUrl();
	};
	
	this.scaleMode = "fit";
	this.format = "png24";
	this.boundx = 0;
	this.boundy = 0;
	this.cacheTimeout = 0;
	this.url = url;
	this.reset = !!resetHttpState;
	
	if(scaleMode) {
		this.setScaleMode(scaleMode);
	}
	if(format) {
		this.setFormat(format);
	}
	if(width && height) {
		this.setBounds(width,height);
	}
};

WidSets.image.prototype = {
	setScaleMode: function(mode) {
		if(!mode || !/^(centered|fit|scaledcrop|crop)$/.exec(mode)) {
			throw "Invalid scale mode. Should be one of centered, fit, scaledcrop and crop.";
		}
		
		this.scaleMode=mode;
	},
	setFormat: function(format) {
		if(!format || !/^(png8|png24|jpeg|gif)$/.exec(format)) {
			throw "Invalid format string. Should be one of png8, png24, jpeg and gif.";
		}
		this.format = format;
	},
	setUrl: function(url) {
		if(!url) {
			throw "First argument cannot be a null.";
		}
		this.url = url;
	},
	setBounds: function(width, height) {
		if(!parseInt(width) || !parseInt(height)) {
			throw "One of the arguments is not a number.";
		}
		
		this.boundx = parseInt(width);
		this.boundy = parseInt(height);
	},
	setResetHttpState: function(reset) {
		this.reset = !!reset;
	},
	setCacheTimeout: function(seconds) {
		seconds = parseInt(seconds);
		if(!seconds || seconds < 0) {
			throw "Argument seconds must be a positive number.";
		}
		
		this.cacheTimeout = seconds;
	},
	getUrl: function() {
		var params = {
			ws_url: escape(this.url),
			ws_format: escape(this.format),
			ws_mode: escape(this.scaleMode),
			ws_boundx: parseInt(this.boundx),
			ws_boundy: parseInt(this.boundy),
			ws_refresh: parseInt(this.cacheTimeout),
			ws_reset: this.reset ? 1 : 0
		};
		return WidSets.request.addParameters(WidSets.makeBaseUrl("image", true), params);
	}
};

WidSets.syndication = function(feedUrl) {
	if(arguments.length != 1 || !feedUrl) {
		throw "Expecting feed URL as the first argument";
	}
	this.feedUrl = feedUrl;
};

WidSets.syndication._preferenceKey = "WidSets.syndication <(\"<) <(\")> (>\")>";

WidSets.syndication.prototype = {
	getItems: function(resultHandler, errorHandler, timestamp, includeInfo, includeContent, resetHttpState) {
		if(WidSets.offline) {
			if(typeof errorHandler == "function") {
				errorHandler(-1);
			}
			return false;
		}
		
		var params = {
			ws_url: escape(this.feedUrl),
			ws_info: arguments.length < 4 || includeInfo ? 1 : 0,
			ws_content: arguments.length < 5 || includeContent ? 1 : 0,
			ws_reset: resetHttpState ? 1 : 0
		};
		params.ws_timestamp = timestamp && timestamp.constructor == Date ? timestamp.valueOf() : 0;
		var url = WidSets.request.addParameters(WidSets.makeBaseUrl("syndication/getitems", true), params);
		var result = function(res) {
			var data = eval("(\" + res + \")");
			if(!data.info) {
				for(var attr in data.info) {
					this[attr] = data.info[attr];
				}
				if(this.created) {
					this.created = new Date(this.created);
				}
			}
			this.items = data.items;
			for(var i = 0; i < this.items.length; i++) {
				this.items[i].created = new Date(this.items[i].created);
				this.items[i].modified = new Date(this.items[i].modified);
				this.items[i].feedUrl = this.feedUrl;
			}
			this.lastRetrievedOn = new Date();
			if(typeof resultHandler == "function") {
				resultHandler(this.items);
			}
		};
		var error = errorHandler || function() {};
		new WidSets.request(url, null, result.ws_bind(this), error.ws_bind(this));
		return true;
	},
	update: function(resultHandler, errorHandler) {
		return this.getItems(resultHandler, errorHandler, this.lastRetrievedOn);
	},
	getItemContent: function(id, resultHandler, errorHandler, resetHttpState) {
		if(WidSets.offline) {
			if(typeof errorHandler == "function") {
				errorHandler(-1);
			}
			return false;
		}
		
		if(typeof id != "string") {
			throw "Expecting item id as first argument.";
		}
		
		var params = {
			ws_url: this.feedUrl,
			ws_iid: itemId,
			ws_reset: resetHttpState ? 1 : 0
		};
		var url = WidSets.request.addParameters(WidSets.makeBaseUrl("syndication/getitem", true), params);
		var result = function(res) {
			if(typeof resultHandler == "function") {
				resultHandler(JSON.parse(res).content);
			}
		};
		var error = errorHandler || function() {};
		new WidSets.request(url, null, result.ws_bind(this), error.ws_bind(this));
		return true;
	},
	getFeedInfo: function(resultHandler, errorHandler, resetHttpState) {
		if(WidSets.offline) {
			if(typeof errorHandler == "function") {
				errorHandler(-1);
			}
			return false;
		}
		
		var params = {
			ws_url: this.feedUrl,
			ws_reset: resetHttpState ? 1 : 0
		};
		var url = WidSets.request.addParameters(WidSets.makeBaseUrl("syndication/getitem", true), params);
		var result = function(res) {
			var data = JSON.parse(res);
			data.created = new Date(data.created);
			for(var attr in data) {
				this[attr] = data[attr];
			}
			if(typeof resultHandler == "function") {
				resultHandler(this);
			}
		};
		var error = errorHandler || function() {};
		new WidSets.request(url, null, result.ws_bind(this), error.ws_bind(this));
		return true;
	},
	store: function(alternateKey) {
		var bag = widget.preferenceForKey(WidSets.syndication._preferenceKey);
		if(!bag) {
			bag = {};
			widget.setPreferenceForKey(bag, WidSets.syndication._preferenceKey);
		}
		bag[alternateKey || this.feedUrl] = JSON.stringify(this);
	},
	loadFromStore: function(alternateKey) {
		var bag = widget.preferenceForKey(WidSets.syndication._preferenceKey) || {};
		var obj = bag[alternateKey || this.feedUrl];
		if(!obj) {
			return false;
		}
		for(var attr in JSON.parse(obj)) {
			this[attr] = obj[attr];
		}
		return true;
	},
	toString: function() {
		return "[WidSets.syndication object]";
	}
};

WidSets.banner = function(element, spot, interval) {
	this.element = element;
	this.spot = spot;
	this.getNextBanner();
	if(parseInt(interval) > 0) {
		this.interval = window.setInterval(this.getNextBanner.ws_bind(this), parseInt(interval) * 1000);
	}
};

WidSets.banner.prototype = {
	performRotation: function(result) {
		if(!this.element) {
			return;
		}
		
		var banner = JSON.parse(result);
		if(!banner || banner.length == 0) {
			return;
		}
		
		var img = document.createElement("img");
		if(banner.action == "link") {
			this.bannerUrl = banner.link.url;
			this.description = banner.link.desc;
		}
		else if(banner.action == "call") {
			this.bannerUrl = "tel:" + banner.call.number;
			this.description = banner.call.desc;
		}
		else{
			return;
		}
		
		img.src = banner.image;
		img.onclick = this.onBannerClicked.ws_bind(this);
		while(this.element.lastChild) {
			this.element.removeChild(this.element.lastChild);
		}
		this.element.appendChild(img);
	},
	bannerNotFound: function() {
		if(this.element && this.element.className.indexOf("ws-hideable-banner") >= 0) {
			this.element.parentNode.removeChild(this.element);
			this.element = null;
		}
	},
	getNextBanner: function() {
		if(WidSets.offline) {
			return;
		}
		
		var url = WidSets.request.addParameters(
			WidSets.makeBaseUrl("banner/get", true),
			{
				ws_wid: widget ? widget.identifier : "",
				ws_spot: this.spot
			}
		);
		
		new WidSets.request(url, null, this.performRotation.ws_bind(this), this.bannerNotFound.ws_bind(this));
	},
	onBannerClicked: function(e) {
		this.dialog = new WidSets.dialog(
			"<p>" + this.description + "</p><p id=\"wsdlg_controls\"><a>" +
			WidSets.i18n("btn_ok") + "</a> <a>" + WidSets.i18n("btn_cancel") + "</a></p>",
			this.onCloseBannerDialog.ws_bind(this)
		);
	},
	onCloseBannerDialog: function(button) {
		switch(button) {
			case 1:
			{
				if(this.bannerUrl.substr(0, 4) == "tel:") {
					document.location = this.bannerUrl;
				}
				else {
					widget.openURL(this.bannerUrl);
				}
				break;
			}
			
			case 2:
			{
				break;
			}
		}
	},
	toString: function() {
		return "[WidSets.banner object]";
	}
};

WidSets.inspect = function(obj, withValues, ofType) {
	var attrs = [];
	for(var attr in obj) {
		if(withValues) {
			if(!ofType || typeof obj[attr] == ofType) {
				attrs.push(attr + " = " + (typeof obj[attr] == "function" ? "FUNCTION" : obj[attr]));
			}
		}
		else{
			attrs.push(attr);
		}
	}
	if(typeof console!="undefined") {
		console.log(attrs.sort().join(", "));
	}
	else {
		alert(attrs.sort().join(", "));
	}
};

WidSets.apiVersion += ".200811170941";/* They say, Midas knows Shoes */



