/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import de.enough.polish.util.IdentityArrayList;
import de.enough.polish.util.IntList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class WrappedText
implements Externalizable {
    private static final int VERSION = 100;
    private String[] lines;
    private final IdentityArrayList linesList;
    private int[] lineWidths;
    private final IntList lineWidthsList;
    private int maxLineWidth;

    public WrappedText() {
        this.linesList = new IdentityArrayList();
        this.lineWidthsList = new IntList();
    }

    public WrappedText(WrappedText original) {
        int size = original.size();
        this.linesList = new IdentityArrayList(size);
        this.lineWidthsList = new IntList(size);
        this.addAll(original);
    }

    public void addAll(WrappedText original) {
        Object[] originalLines = original.getLinesInternalArray();
        int[] originalWidths = original.getLineWidthsInternalArray();
        int size = original.size();
        for (int i = 0; i < size; ++i) {
            this.linesList.add(originalLines[i]);
            this.lineWidthsList.add(originalWidths[i]);
        }
        if (original.maxLineWidth > this.maxLineWidth) {
            this.maxLineWidth = original.maxLineWidth;
        }
    }

    public void addLine(String line, int width) {
        this.lines = null;
        this.lineWidths = null;
        this.linesList.add(line);
        this.lineWidthsList.add(width);
        if (width > this.maxLineWidth) {
            this.maxLineWidth = width;
        }
    }

    public void setLine(int index, String line) {
        this.lines = null;
        this.lineWidths = null;
        this.linesList.set(index, line);
    }

    public void setLine(int index, String line, int width) {
        this.lines = null;
        this.lineWidths = null;
        this.linesList.set(index, line);
        int prevWidth = this.lineWidthsList.set(index, width);
        if (width > this.maxLineWidth) {
            this.maxLineWidth = width;
        } else if (prevWidth == this.maxLineWidth && prevWidth > width) {
            int[] widths = this.lineWidthsList.getInternalArray();
            int size = this.lineWidthsList.size();
            int max = 0;
            for (int i = 0; i < size; ++i) {
                width = widths[i];
                if (width <= max) continue;
                max = width;
            }
            this.maxLineWidth = width;
        }
    }

    public void clear() {
        this.lines = null;
        this.lineWidths = null;
        this.linesList.clear();
        this.lineWidthsList.clear();
        this.maxLineWidth = 0;
    }

    public String[] getLines() {
        if (this.lines == null) {
            this.lines = (String[])this.linesList.toArray(new String[this.linesList.size()]);
        }
        return this.lines;
    }

    public Object[] getLinesInternalArray() {
        return this.linesList.getInternalArray();
    }

    public int[] getLineWidths() {
        if (this.lineWidths == null) {
            this.lineWidths = this.lineWidthsList.toArray();
        }
        return this.lineWidths;
    }

    public int[] getLineWidthsInternalArray() {
        return this.lineWidthsList.getInternalArray();
    }

    public int size() {
        return this.linesList.size();
    }

    public String getLine(int index) {
        return (String)this.linesList.get(index);
    }

    public int getLineWidth(int index) {
        return this.lineWidthsList.get(index);
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public void setMaxLineWidth(int width) {
        this.maxLineWidth = width;
    }

    public void removeLine(int index) {
        this.lines = null;
        this.lineWidths = null;
        this.linesList.remove(index);
        int width = this.lineWidthsList.removeElementAt(index);
        if (width == this.maxLineWidth) {
            int[] widths = this.lineWidthsList.getInternalArray();
            int size = this.lineWidthsList.size();
            int max = 0;
            for (int i = 0; i < size; ++i) {
                width = widths[i];
                if (width <= max) continue;
                max = width;
            }
            this.maxLineWidth = width;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(100);
        out.writeInt(this.maxLineWidth);
        int size = this.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(this.lineWidthsList.get(i));
            out.writeUTF((String)this.linesList.get(i));
        }
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 100) {
            throw new IOException("for version " + version);
        }
        int max = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int width = in.readInt();
            String line = in.readUTF();
            this.addLine(line, width);
        }
        this.maxLineWidth = max;
    }
}

