/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

public class LongHashMap {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final int DEFAULT_LOAD_FACTOR = 75;
    private final int loadFactor;
    private Element[] buckets;
    private final boolean isPowerOfTwo;
    private int size;

    public LongHashMap() {
        this(16, 75);
    }

    public LongHashMap(int initialCapacity) {
        this(initialCapacity, 75);
    }

    public LongHashMap(int initialCapacity, int loadFactor) {
        int capacity;
        initialCapacity = initialCapacity * 100 / loadFactor;
        for (capacity = 1; initialCapacity > capacity; capacity <<= 1) {
        }
        this.isPowerOfTwo = capacity == initialCapacity;
        this.buckets = new Element[initialCapacity];
        this.loadFactor = loadFactor;
    }

    public Object put(long key, Object value) {
        int index;
        Element element;
        if (value == null) {
            throw new IllegalArgumentException("HashMap cannot accept null key [" + key + "] or value [" + value + "].");
        }
        if (this.size * 100 / this.buckets.length > this.loadFactor) {
            this.increaseSize();
        }
        if ((element = this.buckets[index = this.isPowerOfTwo ? (int)(key & Long.MAX_VALUE & (long)(this.buckets.length - 1)) : (int)((key & Long.MAX_VALUE) % (long)this.buckets.length)]) == null) {
            this.buckets[index] = element = new Element(key, value);
            ++this.size;
            return null;
        }
        Element lastElement = element;
        do {
            if (element.key == key) {
                Object oldValue = element.value;
                element.value = value;
                return oldValue;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        lastElement.next = element = new Element(key, value);
        ++this.size;
        return null;
    }

    public Object get(long key) {
        int index = this.isPowerOfTwo ? (int)(key & Long.MAX_VALUE & (long)(this.buckets.length - 1)) : (int)((key & Long.MAX_VALUE) % (long)this.buckets.length);
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        do {
            if (element.key != key) continue;
            return element.value;
        } while ((element = element.next) != null);
        return null;
    }

    public Object remove(long key) {
        int index = this.isPowerOfTwo ? (int)(key & Long.MAX_VALUE & (long)(this.buckets.length - 1)) : (int)((key & Long.MAX_VALUE) % (long)this.buckets.length);
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        Element lastElement = null;
        do {
            if (element.key == key) {
                if (lastElement == null) {
                    this.buckets[index] = element.next;
                } else {
                    lastElement.next = element.next;
                }
                --this.size;
                return element.value;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            while (element != null) {
                if (element.value == value) {
                    return true;
                }
                element = element.next;
            }
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    public Object[] values() {
        return this.values(new Object[this.size]);
    }

    public Object[] values(Object[] objects) {
        int index = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            while (element != null) {
                objects[index] = element.value;
                ++index;
                element = element.next;
            }
        }
        return objects;
    }

    public long[] keys() {
        long[] keys = new long[this.size];
        int index = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            while (element != null) {
                keys[index] = element.key;
                ++index;
                element = element.next;
            }
        }
        return keys;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.size * 23);
        buffer.append(super.toString()).append("{\n");
        Object[] values = this.values();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]);
            buffer.append('\n');
        }
        buffer.append('}');
        return buffer.toString();
    }

    private void increaseSize() {
        int newCapacity = this.isPowerOfTwo ? this.buckets.length << 1 : (this.buckets.length << 1) - 1;
        Element[] newBuckets = new Element[newCapacity];
        for (int i = 0; i < this.buckets.length; ++i) {
            Element element = this.buckets[i];
            while (element != null) {
                int index = this.isPowerOfTwo ? (int)(element.key & Long.MAX_VALUE & (long)(newCapacity - 1)) : (int)((element.key & Long.MAX_VALUE) % (long)newCapacity);
                Element newElement = newBuckets[index];
                if (newElement == null) {
                    newBuckets[index] = element;
                } else {
                    while (newElement.next != null) {
                        newElement = newElement.next;
                    }
                    newElement.next = element;
                }
                Element lastElement = element;
                element = element.next;
                lastElement.next = null;
            }
        }
        this.buckets = newBuckets;
    }

    private static final class Element {
        public final long key;
        public Object value;
        public Element next;

        public Element(long key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

