/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.RecordingDataInputStream;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TimePoint;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Locale {
    private static short[][] multipleParameterOrders;
    private static String[][] multipleParameterTranslations;
    private static String[] plainTranslations;
    private static String[] singleParameterTranslationsStart;
    private static String[] singleParameterTranslationsEnd;
    private static boolean isLoaded;
    private static boolean isLoadError;
    public static String CURRENCY_CODE;
    public static String CURRENCY_SYMBOL;
    public static String DISPLAY_COUNTRY;
    public static String COUNTRY;
    public static String INFINITY;
    public static char PERMILL;
    public static char PERCENT;
    public static char GROUPING_SEPARATOR;
    public static char MONETARY_DECIMAL_SEPARATOR;
    public static char DECIMAL_SEPARATOR;
    public static char ZERO_DIGIT;
    public static char MINUS_SIGN;
    public static String DISPLAY_LANGUAGE;
    public static String LANGUAGE;
    private static String DATE_FORMAT_PATTERN;
    private static String[] monthNames;
    static /* synthetic */ Class class$de$enough$polish$util$Locale;

    private static void initialize() {
        try {
            String loc = null;
            InputStream in = null;
            String meLocale = System.getProperty("microedition.locale");
            if (meLocale != null && (in = (loc = "/" + meLocale + ".loc").getClass().getResourceAsStream(loc)) == null && meLocale.length() > 2) {
                loc = "/" + meLocale.substring(0, 2) + ".loc";
                in = loc.getClass().getResourceAsStream(loc);
            }
            if (in == null) {
                loc = "/en.loc";
                in = loc.getClass().getResourceAsStream(loc);
            }
            if (in != null) {
                Locale.loadTranslations(new DataInputStream(in));
                isLoaded = true;
                isLoadError = false;
            } else {
                isLoadError = true;
            }
        }
        catch (Exception e) {
            isLoadError = true;
            Debug.debug("error", "de.enough.polish.util.Locale", 262, (Object)"Unable to load localizations ", e);
        }
    }

    public static String get(int keyId) {
        if (!isLoaded) {
            Locale.initialize();
            if (isLoadError) {
                return "";
            }
        }
        try {
            return plainTranslations[keyId];
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.util.Locale", 296, "Locale: no translation for ID " + keyId + " in " + (plainTranslations == null ? "null" : "" + plainTranslations.length));
            return "<unknown>";
        }
    }

    public static String get(int keyId, String parameter) {
        if (!isLoaded) {
            Locale.initialize();
            if (isLoadError) {
                return "";
            }
        }
        return singleParameterTranslationsStart[keyId] + parameter + singleParameterTranslationsEnd[keyId];
    }

    public static String get(int keyId, String[] parameters) {
        int i;
        String[] reorderedParameters;
        short[] reorder;
        if (!isLoaded) {
            Locale.initialize();
            if (isLoadError) {
                return "";
            }
        }
        if ((reorder = multipleParameterOrders[keyId]) != null) {
            reorderedParameters = new String[reorder.length];
            for (int i2 = 0; i2 < reorderedParameters.length; ++i2) {
                reorderedParameters[i2] = parameters[reorder[i2]];
            }
        } else {
            reorderedParameters = parameters;
        }
        String[] valueChunks = multipleParameterTranslations[keyId];
        StringBuffer result = new StringBuffer();
        for (i = 0; i < reorderedParameters.length; ++i) {
            String value = valueChunks[i];
            result.append(value).append(reorderedParameters[i]);
        }
        for (i = reorderedParameters.length; i < valueChunks.length; ++i) {
            result.append(valueChunks[i]);
        }
        return result.toString();
    }

    public static String getDefaultDateFormatPattern() {
        if (DATE_FORMAT_PATTERN == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("dd").append(".").append("MM").append(".").append("yyyy");
            DATE_FORMAT_PATTERN = buffer.toString();
        }
        return DATE_FORMAT_PATTERN;
    }

    public static void setDefaultDateFormatPattern(String pattern) {
        DATE_FORMAT_PATTERN = pattern;
    }

    public static void setMonthNames(String[] names) {
        monthNames = names;
    }

    public static String[] getMonthNames() {
        return monthNames;
    }

    public static String formatDate(long time) {
        return Locale.formatDate(new Date(time));
    }

    public static String formatDate(long time, String dateFormat) {
        return Locale.formatDate(new Date(time), dateFormat);
    }

    public static String formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return Locale.formatDate(calendar);
    }

    public static String formatDate(Date date, String dateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return Locale.formatDate(calendar, dateFormat);
    }

    public static String formatDate(Calendar calendar) {
        StringBuffer buffer = new StringBuffer(10);
        Locale.formatDate(calendar, buffer);
        return buffer.toString();
    }

    public static String formatDate(Calendar calendar, String dateFormat) {
        StringBuffer buffer = new StringBuffer(dateFormat.length());
        Locale.formatDate(calendar, buffer, dateFormat);
        return buffer.toString();
    }

    public static String formatDate(TimePoint tp) {
        return Locale.formatDate(tp, Locale.getDefaultDateFormatPattern());
    }

    public static String formatDate(TimePoint tp, String dateFormat) {
        StringBuffer buffer = new StringBuffer(dateFormat.length());
        Locale.formatDate(tp.getYear(), tp.getMonth() + 1, tp.getDay(), tp.getHour(), tp.getMinute(), dateFormat, buffer);
        return buffer.toString();
    }

    public static void formatDate(TimePoint tp, String dateFormat, StringBuffer buffer) {
        Locale.formatDate(tp.getYear(), tp.getMonth() + 1, tp.getDay(), tp.getHour(), tp.getMinute(), dateFormat, buffer);
    }

    public static void formatDate(Calendar calendar, StringBuffer buffer) {
        Locale.formatDate(calendar, buffer, Locale.getDefaultDateFormatPattern());
    }

    public static void formatDate(Calendar calendar, StringBuffer buffer, String dateFormat) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        Locale.formatDate(year, month, day, hour, minute, dateFormat, buffer);
    }

    private static void formatDate(int year, int month, int day, int hour, int minute, String dateFormat, StringBuffer buffer) {
        int length = dateFormat.length();
        boolean isMonthTextual = dateFormat.indexOf("MMMMM") != -1;
        boolean isMonthNumerical2Digit = !isMonthTextual && dateFormat.indexOf("MM") != -1;
        for (int i = 0; i < length - 1; ++i) {
            char c = dateFormat.charAt(i);
            char nextC = dateFormat.charAt(i + 1);
            if (c == 'y' && i < length - 3 && nextC == 'y' && dateFormat.charAt(i + 2) == 'y' && dateFormat.charAt(i + 3) == 'y') {
                if (year < 10) {
                    buffer.append("000");
                } else if (year < 100) {
                    buffer.append("00");
                } else if (year < 1000) {
                    buffer.append("0");
                }
                buffer.append(year);
                i += 3;
                continue;
            }
            if (c == 'M') {
                if (isMonthTextual) {
                    if (monthNames != null) {
                        String monthName = monthNames[month - 1];
                        buffer.append(monthName);
                    } else {
                        if (month < 10) {
                            buffer.append('0');
                        }
                        buffer.append(month);
                    }
                    i += "MMMMM".length() - 1;
                    continue;
                }
                if (isMonthNumerical2Digit) {
                    if (month < 10) {
                        buffer.append('0');
                    }
                    buffer.append(month);
                    ++i;
                    continue;
                }
                buffer.append(month);
                continue;
            }
            if (c == 'd' && nextC == 'd') {
                if (day < 10) {
                    buffer.append('0');
                }
                buffer.append(day);
                ++i;
                continue;
            }
            if (c == 'H' && nextC == 'H') {
                buffer.append(hour);
                ++i;
                continue;
            }
            if (c == 'm' && nextC == 'm') {
                if (minute < 10) {
                    buffer.append('0');
                }
                buffer.append(minute);
                ++i;
                continue;
            }
            buffer.append(c);
        }
    }

    public static String formatTime(long time) {
        return Locale.formatTime(new Date(time));
    }

    public static String formatTime(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return Locale.formatTime(calendar);
    }

    public static String formatTime(Calendar time) {
        StringBuffer buffer = new StringBuffer();
        Locale.formatTime(time, buffer);
        return buffer.toString();
    }

    public static void formatTime(Calendar time, StringBuffer buffer) {
        int hours = time.get(11);
        buffer.append(hours).append(':');
        int minutes = time.get(12);
        if (minutes < 10) {
            buffer.append('0');
        }
        buffer.append(minutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadAndStoreTranslations(InputStream in) throws IOException {
        block10: {
            RecordStore store;
            block9: {
                RecordingDataInputStream dataIn = new RecordingDataInputStream(in);
                Locale.loadTranslations(dataIn);
                byte[] data = dataIn.getRecordedData();
                store = null;
                store = RecordStore.openRecordStore("_translations", true);
                RecordEnumeration enumeration = store.enumerateRecords(null, null, false);
                if (enumeration.hasNextElement()) {
                    store.setRecord(enumeration.nextRecordId(), data, 0, data.length);
                    break block9;
                }
                store.addRecord(data, 0, data.length);
            }
            Object var6_6 = null;
            try {
                store.closeRecordStore();
            }
            catch (RecordStoreException e2) {}
            break block10;
            {
                catch (RecordStoreException e) {
                    Debug.debug("error", "de.enough.polish.util.Locale", 822, (Object)"Unable to store translations into rms", e);
                    Object var6_7 = null;
                    try {
                        store.closeRecordStore();
                    }
                    catch (RecordStoreException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    store.closeRecordStore();
                }
                catch (RecordStoreException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void loadTranslations(String url) throws IOException {
        InputStream is = (class$de$enough$polish$util$Locale == null ? (class$de$enough$polish$util$Locale = Locale.class$("de.enough.polish.util.Locale")) : class$de$enough$polish$util$Locale).getResourceAsStream(url);
        if (is == null) {
            throw new IOException();
        }
        Locale.loadTranslations(new DataInputStream(is));
    }

    public static void loadTranslations(DataInput in) throws IOException {
        try {
            int numberOfPlainTranslations = in.readInt();
            String[] plainTs = new String[numberOfPlainTranslations];
            for (int i = 0; i < numberOfPlainTranslations; ++i) {
                plainTs[i] = in.readUTF();
            }
            plainTranslations = plainTs;
            int numberOfSingleParameterTranslations = in.readInt();
            String[] singleParamsTsStart = new String[numberOfSingleParameterTranslations];
            String[] singleParamsTsEnd = new String[numberOfSingleParameterTranslations];
            for (int i = 0; i < numberOfSingleParameterTranslations; ++i) {
                singleParamsTsStart[i] = in.readUTF();
                singleParamsTsEnd[i] = in.readUTF();
            }
            singleParameterTranslationsStart = singleParamsTsStart;
            singleParameterTranslationsEnd = singleParamsTsEnd;
            int numberOfMultipleParametersTranslations = in.readInt();
            String[][] translationChunks = new String[numberOfMultipleParametersTranslations][];
            short[][] orders = new short[numberOfMultipleParametersTranslations][];
            for (int i = 0; i < numberOfMultipleParametersTranslations; ++i) {
                int numberOfChunks = in.readUnsignedByte();
                String[] chunkValues = new String[numberOfChunks];
                for (int j = 0; j < numberOfChunks; ++j) {
                    chunkValues[j] = in.readUTF();
                }
                short[] chunkOrders = new short[numberOfChunks - 1];
                for (int j = 0; j < numberOfChunks - 1; ++j) {
                    chunkOrders[j] = (short)in.readUnsignedByte();
                }
                translationChunks[i] = chunkValues;
                orders[i] = chunkOrders;
            }
            multipleParameterOrders = orders;
            multipleParameterTranslations = translationChunks;
            LANGUAGE = in.readUTF();
            DISPLAY_LANGUAGE = in.readUTF();
            MINUS_SIGN = in.readChar();
            ZERO_DIGIT = in.readChar();
            DECIMAL_SEPARATOR = in.readChar();
            MONETARY_DECIMAL_SEPARATOR = in.readChar();
            GROUPING_SEPARATOR = in.readChar();
            PERCENT = in.readChar();
            PERMILL = in.readChar();
            INFINITY = in.readUTF();
            String country = in.readUTF();
            if (country.length() > 0) {
                COUNTRY = country;
                DISPLAY_COUNTRY = in.readUTF();
                CURRENCY_SYMBOL = in.readUTF();
                CURRENCY_CODE = in.readUTF();
            } else {
                COUNTRY = null;
                DISPLAY_COUNTRY = null;
                CURRENCY_SYMBOL = null;
                CURRENCY_CODE = null;
            }
            isLoaded = true;
            isLoadError = false;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.util.Locale", 944, (Object)"error while loading translations: ", e);
            throw new IOException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CURRENCY_CODE = null;
        CURRENCY_SYMBOL = null;
        DISPLAY_COUNTRY = null;
        COUNTRY = null;
        INFINITY = "\u221e";
        PERMILL = (char)8240;
        PERCENT = (char)37;
        GROUPING_SEPARATOR = (char)44;
        MONETARY_DECIMAL_SEPARATOR = (char)46;
        DECIMAL_SEPARATOR = (char)46;
        ZERO_DIGIT = (char)48;
        MINUS_SIGN = (char)45;
        DISPLAY_LANGUAGE = "English";
        LANGUAGE = "en";
    }
}

