/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.BitMapFontViewer;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class BitMapFont {
    private static Hashtable fontsByUrl = new Hashtable();
    private String fontUrl;
    private Image fontImage;
    private boolean hasMixedCase;
    private byte[] characterWidths;
    private short[] xPositions;
    private String characterMap;
    private int fontHeight;
    private int spaceIndex;

    private BitMapFont(String fontUrl) {
        this.fontUrl = fontUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initFont() {
        InputStream in = null;
        in = this.getClass().getResourceAsStream(this.fontUrl);
        if (in == null && !this.fontUrl.endsWith(".bmf")) {
            this.fontUrl = this.fontUrl + ".bmf";
            in = this.getClass().getResourceAsStream(this.fontUrl);
        }
        this.initFont(in);
        Object var4_2 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {
            Debug.debug("error", "de.enough.polish.util.BitMapFont", 125, (Object)"Unable to close bitmap-font stream", e2);
        }
        return;
        {
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.util.BitMapFont", 117, (Object)("Unable to load bitmap-font [" + this.fontUrl + "]"), e);
                Object var4_3 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {
                    Debug.debug("error", "de.enough.polish.util.BitMapFont", 125, (Object)"Unable to close bitmap-font stream", e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                Debug.debug("error", "de.enough.polish.util.BitMapFont", 125, (Object)"Unable to close bitmap-font stream", e2);
            }
            throw throwable;
        }
    }

    private void initFont(InputStream in) throws IOException {
        String map;
        if (in == null) {
            throw new IOException();
        }
        DataInputStream dataIn = new DataInputStream(in);
        this.hasMixedCase = dataIn.readBoolean();
        this.characterMap = map = dataIn.readUTF();
        this.spaceIndex = map.indexOf(32);
        int length = map.length();
        this.characterWidths = new byte[length];
        this.xPositions = new short[length];
        short xPos = 0;
        for (int i = 0; i < length; ++i) {
            byte width;
            this.characterWidths[i] = width = dataIn.readByte();
            this.xPositions[i] = xPos;
            xPos = (short)(xPos + width);
        }
        this.fontImage = Image.createImage(in);
        this.fontHeight = this.fontImage.getHeight();
        this.fontUrl = null;
    }

    public BitMapFontViewer getViewer(String input) {
        return this.getViewer(input, -1);
    }

    public BitMapFontViewer getViewer(String input, int color2) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return null;
            }
        }
        if (!this.hasMixedCase) {
            input = input.toLowerCase();
        }
        int length = input.length();
        int[] indeces = new int[length];
        for (int i = length - 1; i >= 0; --i) {
            char inputCharacter = input.charAt(i);
            indeces[i] = inputCharacter == '\n' ? -2 : this.characterMap.indexOf(inputCharacter);
        }
        if (color2 != -1 && color2 != 0) {
            return new BitMapFontViewer(this.fontImage, color2, indeces, this.xPositions, this.characterWidths, this.fontHeight, this.spaceIndex, 1);
        }
        return new BitMapFontViewer(this.fontImage, indeces, this.xPositions, this.characterWidths, this.fontHeight, this.spaceIndex, 1);
    }

    public static BitMapFont getInstance(String url) {
        return BitMapFont.getInstance(url, null);
    }

    public static BitMapFont getInstance(String url, InputStream in) {
        BitMapFont font = (BitMapFont)fontsByUrl.get(url);
        String originalUrl = null;
        if (font == null) {
            String nextUrl = url;
            if (url.startsWith("url")) {
                int startIndex = url.indexOf(40);
                int endIndex = url.indexOf(41, startIndex);
                if (startIndex != -1 && endIndex != -1) {
                    nextUrl = url.substring(startIndex + 1, endIndex).trim();
                }
                if (nextUrl.charAt(0) != '/') {
                    nextUrl = "/" + nextUrl;
                }
            } else if (url.charAt(0) != '/') {
                nextUrl = "/" + url;
            }
            originalUrl = url;
            url = nextUrl;
            font = new BitMapFont(url);
            fontsByUrl.put(url, font);
            if (originalUrl != null) {
                fontsByUrl.put(originalUrl, font);
            }
            if (in != null) {
                try {
                    font.initFont(in);
                }
                catch (IOException e) {
                    Debug.debug("error", "de.enough.polish.util.BitMapFont", 282, (Object)"Unable to initialize bitmap font from input stream", e);
                }
            }
        }
        return font;
    }

    public static void removeInstance(String url) {
        fontsByUrl.remove(url);
    }

    public int charWidth(char c) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        for (int i = 0; i < this.characterMap.length(); ++i) {
            char cm = this.characterMap.charAt(i);
            if (cm != c) continue;
            return this.characterWidths[i];
        }
        return -1;
    }

    public int stringWidth(String str) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        int width = 0;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (int j = 0; j < this.characterMap.length(); ++j) {
                char cm = this.characterMap.charAt(j);
                if (cm != c) continue;
                width += this.characterWidths[j];
                continue block0;
            }
        }
        return width;
    }

    public int getFontHeight() {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        return this.fontHeight;
    }

    public void drawChar(char c, int x, int y, int anchor, Graphics g) {
        int index;
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return;
            }
        }
        if (!this.hasMixedCase) {
            c = Character.toLowerCase(c);
        }
        if ((index = this.characterMap.indexOf(c)) == -1) {
            return;
        }
        if ((anchor & 0x20) == 32) {
            y -= this.fontHeight;
        } else if ((anchor & 0x40) == 64) {
            y -= this.fontHeight * 2 / 3;
        } else if ((anchor & 2) == 2) {
            y -= this.fontHeight / 2;
        }
        byte width = this.characterWidths[index];
        if ((anchor & 8) == 8) {
            x -= width;
        } else if ((anchor & 1) == 1) {
            x -= width / 2;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.clipRect(x, y, width, this.fontHeight);
        int imageX = x - this.xPositions[index];
        g.drawImage(this.fontImage, imageX, y, 20);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }
}

