/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Comparator;
import java.util.Enumeration;

public final class Arrays
implements Comparator {
    private static final Comparator STRING_COMPARATOR = new Arrays();

    private Arrays() {
    }

    public int compare(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public static boolean byteArrayEquals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static void sort(Object[] obj) {
        Arrays.sort(obj, STRING_COMPARATOR);
    }

    public static void shellSort(Object[] array) {
        Arrays.shellSort(array, STRING_COMPARATOR);
    }

    public static void shellSort(Object[] array, Comparator comparator) {
        int increment = 3;
        while (true) {
            for (int i = 0; i < array.length; ++i) {
                Object temp = array[i];
                for (int j = i; j >= increment && comparator.compare(array[j - increment], temp) > 0; j -= increment) {
                    array[j] = array[j - increment];
                }
                array[j] = temp;
            }
            if (increment == 1) break;
            increment >>= 1;
        }
    }

    public static void quicksort(Object[] obj) {
        Arrays.quicksort(obj, obj.length, STRING_COMPARATOR);
    }

    public static void iQuick(int[] array, int elements) {
        int left = 0;
        int right = elements - 1;
        int top = 0;
        int sSize = elements / 2;
        int[] lStack = new int[sSize];
        int[] rStack = new int[sSize];
        lStack[top] = left;
        rStack[top] = right;
        while (top >= 0) {
            left = lStack[top];
            right = rStack[top];
            --top;
            while (left < right) {
                int i = left;
                int j = right;
                int x = array[(left + right) / 2];
                while (i <= j) {
                    while (array[i] < x) {
                        ++i;
                    }
                    while (array[j] > x) {
                        --j;
                    }
                    if (i > j) continue;
                    int tmp = array[i];
                    array[i] = array[j];
                    array[j] = tmp;
                    ++i;
                    --j;
                }
                if (j - left < right - i) {
                    if (i < right) {
                        lStack[++top] = i;
                        rStack[top] = right;
                    }
                    right = j;
                    continue;
                }
                if (left < j) {
                    lStack[++top] = left;
                    rStack[top] = j;
                }
                left = i;
            }
        }
    }

    public static void quicksort(Object[] obj, int elements, Comparator comparator) {
        if (elements <= 1) {
            return;
        }
        int left = 0;
        int right = elements - 1;
        int top = 0;
        int sSize = elements / 2;
        int[] lStack = new int[sSize];
        int[] rStack = new int[sSize];
        lStack[top] = left;
        rStack[top] = right;
        while (top >= 0) {
            left = lStack[top];
            right = rStack[top];
            --top;
            while (left < right) {
                int i = left;
                int j = right;
                Object pivot = obj[(left + right) / 2];
                while (i < j) {
                    while (comparator.compare(pivot, obj[i]) > 0) {
                        ++i;
                    }
                    while (comparator.compare(pivot, obj[j]) < 0) {
                        --j;
                    }
                    if (i > j) continue;
                    Object tmp = obj[i];
                    obj[i] = obj[j];
                    obj[j] = tmp;
                    ++i;
                    --j;
                }
                if (j - left < right - i) {
                    if (i < right) {
                        lStack[++top] = i;
                        rStack[top] = right;
                    }
                    right = j;
                    continue;
                }
                if (left < j) {
                    lStack[++top] = left;
                    rStack[top] = j;
                }
                left = i;
            }
        }
    }

    public static void sort(Object[] obj, Comparator comparator) {
        Arrays.shellSort(obj, comparator);
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 instanceof byte[]) {
            byte[] pa1 = (byte[])array1;
            byte[] pa2 = (byte[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                byte p1 = pa1[i];
                byte p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof short[]) {
            short[] pa1 = (short[])array1;
            short[] pa2 = (short[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                short p1 = pa1[i];
                short p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof int[]) {
            int[] pa1 = (int[])array1;
            int[] pa2 = (int[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                int p1 = pa1[i];
                int p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof long[]) {
            long[] pa1 = (long[])array1;
            long[] pa2 = (long[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                long p1 = pa1[i];
                long p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof boolean[]) {
            boolean[] pa1 = (boolean[])array1;
            boolean[] pa2 = (boolean[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                boolean p1 = pa1[i];
                boolean p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof float[]) {
            float[] pa1 = (float[])array1;
            float[] pa2 = (float[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                float p1 = pa1[i];
                float p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof double[]) {
            double[] pa1 = (double[])array1;
            double[] pa2 = (double[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i = 0; i < pa1.length; ++i) {
                double p1 = pa1[i];
                double p2 = pa2[i];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof Object[]) {
            Object[] oa1 = (Object[])array1;
            Object[] oa2 = (Object[])array2;
            if (oa1.length != oa2.length) {
                return false;
            }
            for (int i = 0; i < oa1.length; ++i) {
                Object o1 = oa1[i];
                Object o2 = oa2[i];
                if ((o1 != null || o2 == null) && o1.equals(o2)) continue;
                return false;
            }
        } else {
            return array1.equals(array2);
        }
        return true;
    }

    public static Object[] cast(Object[] input, Object[] output) {
        if (input == null) {
            return null;
        }
        System.arraycopy(input, 0, output, 0, Math.min(input.length, output.length));
        return output;
    }

    public static void arraycopy(Object source, int sourceOffset, Object destination, int destinationOffset, int length) {
        if (source instanceof byte[]) {
            Arrays.arraycopyImpl((byte[])source, sourceOffset, (byte[])destination, destinationOffset, length);
        } else if (source instanceof int[]) {
            Arrays.arraycopyImpl((int[])source, sourceOffset, (int[])destination, destinationOffset, length);
        } else if (source instanceof Object[]) {
            Arrays.arraycopyImpl((Object[])source, sourceOffset, (Object[])destination, destinationOffset, length);
        } else if (source instanceof short[]) {
            Arrays.arraycopyImpl((short[])source, sourceOffset, (short[])destination, destinationOffset, length);
        } else if (source instanceof long[]) {
            Arrays.arraycopyImpl((long[])source, sourceOffset, (long[])destination, destinationOffset, length);
        } else if (source instanceof boolean[]) {
            Arrays.arraycopyImpl((boolean[])source, sourceOffset, (boolean[])destination, destinationOffset, length);
        } else if (source instanceof char[]) {
            Arrays.arraycopyImpl((char[])source, sourceOffset, (char[])destination, destinationOffset, length);
        } else if (source instanceof float[]) {
            Arrays.arraycopyImpl((float[])source, sourceOffset, (float[])destination, destinationOffset, length);
        } else if (source instanceof double[]) {
            Arrays.arraycopyImpl((double[])source, sourceOffset, (double[])destination, destinationOffset, length);
        }
    }

    private static void arraycopyImpl(char[] source, int sourceOffset, char[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(double[] source, int sourceOffset, double[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(float[] source, int sourceOffset, float[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(boolean[] source, int sourceOffset, boolean[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(long[] source, int sourceOffset, long[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(short[] source, int sourceOffset, short[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(Object[] source, int sourceOffset, Object[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(int[] source, int sourceOffset, int[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    private static void arraycopyImpl(byte[] source, int sourceOffset, byte[] destination, int destinationOffset, int length) {
        if (source == destination && destinationOffset > sourceOffset && sourceOffset + length > destinationOffset) {
            int i = length;
            while (--i >= 0) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        } else {
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    public static Object[] toArray(Enumeration enumeration) {
        ArrayList list = new ArrayList();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list.toArray();
    }

    public static Object[] toArray(Enumeration enumeration, Object[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = enumeration.nextElement();
        }
        return target;
    }
}

