/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.WrappedText;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class VerticalScrollTextEffect
extends TextEffect {
    public static final int STAGE_SHOW = 0;
    public static final int STAGE_SCROLL = 1;
    int stageInterval = 2000;
    int maxLines = 1;
    int lines = 1;
    int lineHeight = 0;
    int drawCount = 0;
    WrappedText textLines = null;
    WrappedText drawLines = null;
    long stageTime = 0L;
    int stageCurrent = 0;
    int lineIndex = 0;
    int lineOffset = 0;
    int lastLineWidth = -1;
    boolean needsAnimation = false;
    private WrappedText originalWrappedText;

    public VerticalScrollTextEffect() {
        this.isTextSensitive = true;
    }

    public void animate(Item parent, long currentTime, ClippingRegion repaintRegion) {
        if (this.animate()) {
            parent.addRelativeToContentRegion(repaintRegion, 0, 0, parent.itemWidth, parent.itemHeight);
        }
    }

    public boolean animate() {
        if (this.textLines != null && this.textLines.size() != 1) {
            long currentTime = System.currentTimeMillis();
            if (this.stageTime == 0L) {
                this.stageTime = currentTime;
                return true;
            }
            long timePassed = currentTime - this.stageTime;
            switch (this.stageCurrent) {
                case 0: {
                    if (timePassed > (long)this.stageInterval) {
                        this.stageCurrent = 1;
                        this.stageTime = currentTime;
                    }
                    return false;
                }
                case 1: {
                    this.lineOffset = this.getLineOffset(timePassed, this.lineHeight);
                    if (timePassed > (long)this.stageInterval) {
                        this.lineIndex = (this.lineIndex + 1) % this.originalWrappedText.size();
                        this.lineOffset = 0;
                        this.stageCurrent = 0;
                        this.stageTime = currentTime;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int getLineOffset(long timePassed, int lineHeight) {
        int progress = (int)(timePassed * 1000L / (long)this.stageInterval) * 100 / 1000;
        return lineHeight * 1000 / 100 * progress / 1000;
    }

    public void drawStrings(WrappedText wrappedText, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        if (this.originalWrappedText == null) {
            super.drawStrings(wrappedText, textColor, x, y, leftBorder, rightBorder, lineHeight, maxWidth, layout, g);
            return;
        }
        int textLinesSize = this.originalWrappedText.size();
        this.lineHeight = lineHeight;
        int index = this.lineIndex;
        for (int i = 0; i < this.drawLines.size(); ++i) {
            int textLinesIndex = (index + i) % textLinesSize;
            this.drawLines.setLine(i, this.originalWrappedText.getLine(textLinesIndex), this.originalWrappedText.getLineWidth(textLinesIndex));
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int linesHeight = lineHeight * this.lines;
        g.clipRect(x, y, rightBorder - leftBorder, linesHeight);
        leftBorder = x;
        super.drawStrings(this.drawLines, textColor, x, y - this.lineOffset, leftBorder, rightBorder, lineHeight, maxWidth, layout, g);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void wrap(StringItem parent, String text, int textColor, Font font, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition, WrappedText wrappedTextResult) {
        super.wrap(parent, text, textColor, font, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, wrappedTextResult);
        this.textLines = wrappedTextResult;
        if (wrappedTextResult.size() > this.maxLines) {
            this.originalWrappedText = new WrappedText(wrappedTextResult);
            this.drawLines = new WrappedText();
            for (int i = 0; i < this.maxLines + 1; ++i) {
                this.drawLines.addLine(wrappedTextResult.getLine(i), wrappedTextResult.getLineWidth(i));
            }
            this.lines = this.maxLines;
            this.needsAnimation = true;
            AnimationThread.addAnimationItem(parent);
            wrappedTextResult.clear();
            wrappedTextResult.addAll(this.drawLines);
        } else {
            this.originalWrappedText = null;
            this.drawLines = this.textLines;
            this.lines = wrappedTextResult.size();
            this.needsAnimation = false;
            AnimationThread.removeAnimationItem(parent);
        }
    }

    public void onAttach(Item parent) {
        if (parent.isInitialized() && this.needsAnimation) {
            AnimationThread.addAnimationItem(parent);
        }
    }

    public void onDetach(Item parent) {
        this.lineOffset = 0;
        AnimationThread.removeAnimationItem(parent);
    }

    public void drawString(String text, int textColor, int x, int y, int anchor, Graphics g) {
        g.setColor(textColor);
        g.drawString(text, x, y, anchor);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public int calculateLinesHeight(WrappedText lines, int lineHeight, int paddingVertical) {
        if (this.maxLines > lines.size()) {
            return lines.size() * lineHeight - paddingVertical;
        }
        return this.maxLines * lineHeight - paddingVertical;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.drawCount = dataInputStream.readInt();
        this.drawLines = (WrappedText)Serializer.deserialize(dataInputStream);
        this.lastLineWidth = dataInputStream.readInt();
        this.lineHeight = dataInputStream.readInt();
        this.lineIndex = dataInputStream.readInt();
        this.lineOffset = dataInputStream.readInt();
        this.lines = dataInputStream.readInt();
        this.maxLines = dataInputStream.readInt();
        this.needsAnimation = dataInputStream.readBoolean();
        this.originalWrappedText = (WrappedText)Serializer.deserialize(dataInputStream);
        this.stageCurrent = dataInputStream.readInt();
        this.stageInterval = dataInputStream.readInt();
        this.stageTime = dataInputStream.readLong();
        this.textLines = (WrappedText)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.drawCount);
        Serializer.serialize(this.drawLines, dataOutputStream);
        dataOutputStream.writeInt(this.lastLineWidth);
        dataOutputStream.writeInt(this.lineHeight);
        dataOutputStream.writeInt(this.lineIndex);
        dataOutputStream.writeInt(this.lineOffset);
        dataOutputStream.writeInt(this.lines);
        dataOutputStream.writeInt(this.maxLines);
        dataOutputStream.writeBoolean(this.needsAnimation);
        Serializer.serialize(this.originalWrappedText, dataOutputStream);
        dataOutputStream.writeInt(this.stageCurrent);
        dataOutputStream.writeInt(this.stageInterval);
        dataOutputStream.writeLong(this.stageTime);
        Serializer.serialize(this.textLines, dataOutputStream);
    }
}

