/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.ui.TextEffect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ShadowTextEffect
extends TextEffect {
    public static final int ORIENTATION_BOTTOM_RIGHT = 0;
    public static final int ORIENTATION_BOTTOM_LEFT = 1;
    public static final int ORIENTATION_TOP_RIGHT = 2;
    public static final int ORIENTATION_TOP_LEFT = 3;
    public static final int ORIENTATION_BOTTOM = 4;
    public static final int ORIENTATION_TOP = 5;
    public static final int ORIENTATION_RIGHT = 6;
    public static final int ORIENTATION_LEFT = 7;
    public int shadowColor;
    public int xOffset = 1;
    public int yOffset = 1;

    public ShadowTextEffect() {
    }

    public ShadowTextEffect(int shadowColor, int xOffset, int yOffset) {
        this.shadowColor = shadowColor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        g.setColor(this.shadowColor);
        g.drawString(text, x + this.xOffset, y + this.yOffset, orientation);
        g.setColor(textColor);
        g.drawString(text, x, y, orientation);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.shadowColor = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.shadowColor);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

