/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.TextEffect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LighthouseTextEffect
extends TextEffect {
    private static final int MODE_LEFT_TO_RIGHT = 1;
    private static final int MODE_RIGHT_TO_LEFT = 2;
    private static final int MODE_BACK_AND_FORTH_ONCE = 3;
    private static final int MODE_LEFT_TO_RIGHT_ONCE = 4;
    private static final int MODE_RIGHT_TO_LEFT_ONCE = 5;
    private static final int DIRECTION_RIGHT = 0;
    private static final int DIRECTION_LEFT = 1;
    private String lastText;
    private boolean animationRunning = true;
    private int currentPos;
    private int direction;
    private int mainColor = 4502784;
    private int neighborColor = 3641600;
    private int mode;

    public boolean animate() {
        boolean animated = super.animate();
        String text = this.lastText;
        if (!this.animationRunning || text == null) {
            return animated;
        }
        int pos = this.currentPos;
        if (this.direction == 0) {
            if (++pos >= text.length()) {
                if (this.mode == 4) {
                    this.animationRunning = false;
                } else if (this.mode == 1) {
                    pos = -1;
                } else {
                    this.direction = 1;
                }
            }
        } else if (--pos < 0) {
            if (this.mode == 3 || this.mode == 5) {
                this.animationRunning = false;
            } else if (this.mode == 2) {
                pos = text.length();
            } else {
                this.direction = 0;
            }
        }
        this.currentPos = pos;
        return true;
    }

    public void hideNotify() {
        this.lastText = null;
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        int length = text.length();
        if (text != this.lastText) {
            this.lastText = text;
            this.animationRunning = true;
            if (this.mode == 2 || this.mode == 5) {
                this.currentPos = length;
            } else {
                this.direction = 0;
                this.currentPos = -1;
            }
        }
        if (!this.animationRunning) {
            g.drawString(text, x, y, orientation);
        } else {
            char c;
            int pos = this.currentPos;
            if (pos < -1) {
                pos = -1;
            }
            Font font = g.getFont();
            x = this.getLeftX(x, orientation, font.stringWidth(text));
            y = this.getTopY(y, orientation, font.getHeight(), font.getBaselinePosition());
            int neighbor = pos - 1;
            if (neighbor >= 0) {
                if (neighbor != 0) {
                    g.drawSubstring(text, 0, neighbor, x, y, 20);
                    x += font.substringWidth(text, 0, neighbor);
                }
                g.setColor(this.neighborColor);
                c = text.charAt(neighbor);
                g.drawChar(c, x, y, 20);
                x += font.charWidth(c);
            }
            if (pos >= 0 && pos < length) {
                g.setColor(this.mainColor);
                c = text.charAt(pos);
                g.drawChar(c, x, y, 20);
                x += font.charWidth(c);
            }
            if ((neighbor = pos + 1) < length) {
                g.setColor(this.neighborColor);
                c = text.charAt(neighbor);
                g.drawChar(c, x, y, 20);
                if (++neighbor < length) {
                    g.setColor(textColor);
                    g.drawSubstring(text, neighbor, length - neighbor, x += font.charWidth(c), y, 20);
                }
            }
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationRunning = dataInputStream.readBoolean();
        this.currentPos = dataInputStream.readInt();
        this.direction = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.mainColor = dataInputStream.readInt();
        this.mode = dataInputStream.readInt();
        this.neighborColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationRunning);
        dataOutputStream.writeInt(this.currentPos);
        dataOutputStream.writeInt(this.direction);
        Serializer.serialize(this.lastText, dataOutputStream);
        dataOutputStream.writeInt(this.mainColor);
        dataOutputStream.writeInt(this.mode);
        dataOutputStream.writeInt(this.neighborColor);
    }
}

