/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.BitMapFont;
import de.enough.polish.util.BitMapFontViewer;
import de.enough.polish.util.WrappedText;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BitmapFontTextEffect
extends TextEffect {
    protected transient BitMapFont font;
    protected transient BitMapFontViewer viewer;

    public BitmapFontTextEffect() {
        this.isTextSensitive = true;
    }

    public int getFontHeight() {
        if (this.font == null) {
            return super.getFontHeight();
        }
        return this.font.getFontHeight();
    }

    public int stringWidth(String str) {
        if (this.font == null) {
            return super.stringWidth(str);
        }
        return this.font.stringWidth(str);
    }

    public int charWidth(char c) {
        if (this.font == null) {
            return super.charWidth(c);
        }
        return this.font.charWidth(c);
    }

    public void wrap(StringItem parent, String text, int textColor, Font meFont, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition, WrappedText wrappedText) {
        if (this.font == null) {
            super.wrap(parent, text, textColor, meFont, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, wrappedText);
            return;
        }
        this.viewer = this.font.getViewer(text, textColor);
        if (this.viewer == null) {
            super.wrap(parent, text, textColor, meFont, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, wrappedText);
            return;
        }
        int pv = 1;
        int anchor = 4;
        if (this.style != null) {
            pv = this.style.getPaddingVertical(lineWidth);
            anchor = this.style.getAnchorHorizontal();
        }
        this.viewer.layout(firstLineWidth, lineWidth, pv, anchor, maxLines, maxLinesAppendix, this.font);
        this.viewer.wrap(text, wrappedText);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public void setFont(BitMapFont font) {
        this.font = font;
    }

    public void drawStrings(WrappedText textLines, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        if (this.viewer == null) {
            super.drawStrings(textLines, textColor, x, y, leftBorder, rightBorder, lineHeight, maxWidth, layout, g);
        } else {
            if ((layout & 3) == 3) {
                x = leftBorder + (rightBorder - leftBorder) / 2;
            } else if ((layout & 2) == 2) {
                x = rightBorder;
            }
            if ((layout & 0x20) == 32) {
                int fontHeight = this.font.getFontHeight();
                y = (layout & 0x30) == 48 ? (y -= fontHeight / 2) : (y -= fontHeight);
            }
            this.viewer.paint(x, y, g);
        }
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        g.drawString(text, x, y, orientation);
    }

    public void drawChar(char c, int x, int y, int anchor, Graphics g) {
        if (this.font == null) {
            super.drawChar(c, x, y, anchor, g);
        }
        this.font.drawChar(c, x, y, anchor, g);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }
}

