/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.splash2;

import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.splash2.ApplicationInitializer;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class InitializerSplashScreen
extends Canvas
implements Runnable {
    private final ApplicationInitializer initializer;
    private final Image image;
    private final int backgroundColor;
    private String message;
    private int messageColor;
    private boolean isStarted;

    public InitializerSplashScreen(Image image, ApplicationInitializer initializer) {
        this(image, 0xFFFFFF, initializer);
    }

    public InitializerSplashScreen(Image image, int backgroundColor, ApplicationInitializer initializer) {
        this.image = image;
        this.backgroundColor = backgroundColor;
        this.initializer = initializer;
    }

    public void setMessage(String message, int color2) {
        this.messageColor = color2;
        this.message = message;
        this.repaint();
    }

    public void paint(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
        if (this.image != null) {
            g.drawImage(this.image, width / 2, height / 2, 3);
        }
        if (this.message != null) {
            g.setColor(this.messageColor);
            Font font = Font.getDefaultFont();
            String[] lines = TextUtil.wrap(this.message, font, width - 10, width - 10);
            int y = height - lines.length * (font.getHeight() + 1);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                g.drawString(line, width / 2, y, 17);
                y += font.getHeight() + 1;
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.initializer.initApp();
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.splash2.InitializerSplashScreen", 147, (Object)"Unable to call initApp()", e);
            this.message = "Error: " + e.toString();
            this.repaint();
        }
    }

    public void sizeChanged(int width, int height) {
        this.repaint();
    }

    public void showNotify() {
        super.setFullScreenMode(true);
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        Thread thread = new Thread(this);
        thread.start();
    }
}

