/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ZoomOutScreenChangeAnimation
extends ScreenChangeAnimation {
    private int scaleFactor = 800;
    private int[] scaledScreenRgb;

    public ZoomOutScreenChangeAnimation() {
        this.animationForwardFunction = 5;
        this.animationBackwardFunction = 4;
    }

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
        } else {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
        }
        this.scaledScreenRgb = new int[width * height];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int[] rgb;
        int endOpacity;
        int startOpacity;
        int endFactor;
        int startFactor;
        if (passedTime > duration) {
            this.scaledScreenRgb = null;
            return false;
        }
        if (this.isForwardAnimation) {
            startFactor = this.scaleFactor;
            endFactor = 100;
            startOpacity = 10;
            endOpacity = 255;
            rgb = this.nextCanvasRgb;
        } else {
            startFactor = 100;
            endFactor = this.scaleFactor;
            startOpacity = 255;
            endOpacity = 10;
            rgb = this.lastCanvasRgb;
        }
        int promille = this.calculateAnimationPoint(0, 1000, passedTime, duration);
        int factor = startFactor + (endFactor - startFactor) * promille / 1000;
        int opacity = startOpacity + (endOpacity - startOpacity) * promille / 1000;
        ImageUtil.scale(opacity, factor, this.screenWidth, this.screenHeight, rgb, this.scaledScreenRgb);
        return true;
    }

    public void paintAnimation(Graphics g) {
        Image canvasImage = this.isForwardAnimation ? this.lastCanvasImage : this.nextCanvasImage;
        g.drawImage(canvasImage, 0, 0, 20);
        g.drawRGB(this.scaledScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

