/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class VerticalDoorsScreenChangeAnimation
extends ScreenChangeAnimation {
    private static final int DOOR_BOTH = 0;
    private static final int DOOR_TOP = 1;
    private static final int DOOR_BOTTOM = 2;
    private int currentY;
    private int door = 0;

    protected void setStyle(Style style) {
        super.setStyle(style);
        this.currentY = this.screenHeight / 2;
    }

    protected boolean animate(long passedTime, long duration) {
        int nextY = this.calculateAnimationPoint(this.screenHeight / 2, 0, passedTime, duration);
        if (nextY > 0) {
            this.currentY = nextY;
            return true;
        }
        return false;
    }

    public void paintAnimation(Graphics g) {
        int height;
        Image second;
        Image first;
        if (this.isForwardAnimation) {
            first = this.lastCanvasImage;
            second = this.nextCanvasImage;
            height = this.screenHeight / 2 - this.currentY;
        } else {
            first = this.nextCanvasImage;
            second = this.lastCanvasImage;
            height = this.currentY;
        }
        g.drawImage(first, 0, 0, 20);
        g.setClip(0, 0, this.screenWidth, height);
        g.drawImage(second, 0, height - this.screenHeight / 2, 20);
        g.setClip(0, this.screenHeight - height, this.screenWidth, height);
        g.drawImage(second, 0, this.screenHeight / 2 - height, 20);
    }
}

