/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;

public class ParticleScreenChangeAnimation
extends ScreenChangeAnimation {
    private int scaleFactor = 460;
    private int[] scaledScreenRgb;

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
        } else {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
        }
        this.scaledScreenRgb = new int[width * height];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int[] originalRgb;
        int endFactor;
        int startFactor;
        if (passedTime > duration) {
            this.scaledScreenRgb = null;
            return false;
        }
        if (this.isForwardAnimation) {
            startFactor = 100;
            endFactor = this.scaleFactor;
            originalRgb = this.lastCanvasRgb;
        } else {
            startFactor = this.scaleFactor;
            endFactor = 100;
            originalRgb = this.nextCanvasRgb;
        }
        int factor = this.calculateAnimationPoint(startFactor, endFactor, passedTime, duration);
        ImageUtil.particleScale(factor, this.screenWidth, this.screenHeight, originalRgb, this.scaledScreenRgb);
        return true;
    }

    public void paintAnimation(Graphics g) {
        if (this.isForwardAnimation) {
            g.drawImage(this.nextCanvasImage, 0, 0, 20);
        } else {
            g.drawImage(this.lastCanvasImage, 0, 0, 20);
        }
        g.drawRGB(this.scaledScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

