/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class FadeOutFadeInScreenChangeAnimation
extends ScreenChangeAnimation {
    private int backgroundColor = 0;
    private int[] shownScreenRgb;
    private boolean isFadingPreviousScreen;
    private int currentOpacity;

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        if (this.shownScreenRgb == null) {
            this.shownScreenRgb = new int[width * height];
        }
        this.isFadingPreviousScreen = true;
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
        this.lastCanvasImage.getRGB(this.shownScreenRgb, 0, width, 0, 0, width, height);
    }

    protected boolean animate(long passedTime, long duration) {
        if (passedTime > duration) {
            return false;
        }
        if (this.isFadingPreviousScreen) {
            if (passedTime <= duration / 2L) {
                this.currentOpacity = this.calculateAnimationPoint(255, 0, passedTime, duration / 2L);
            } else {
                this.isFadingPreviousScreen = false;
                this.nextCanvasImage.getRGB(this.shownScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight);
                this.currentOpacity = this.calculateAnimationPoint(0, 255, passedTime - duration / 2L, duration / 2L);
            }
        } else {
            this.currentOpacity = this.calculateAnimationPoint(0, 255, passedTime - duration / 2L, duration / 2L);
        }
        this.addOpacity(this.currentOpacity, this.shownScreenRgb);
        return true;
    }

    private void addOpacity(int opacity, int[] data) {
        opacity = opacity << 24 | 0xFFFFFF;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] | 0xFF000000) & opacity;
        }
    }

    public void paintAnimation(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.drawRGB(this.shownScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

