/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class DisplayScreenChangeAnimation
extends ScreenChangeAnimation {
    private boolean stillRun = true;
    private int row = 0;
    private int[] rgbData;
    private int[] scaler;
    private int lstScale = 0;
    private int width;
    private int height;

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        this.height = height;
        this.width = width;
        this.lstScale = width;
        this.scaler = new int[width];
        for (int i = 0; i < this.scaler.length; ++i) {
            this.scaler[i] = height;
        }
        this.rgbData = new int[width * height];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int row = 0;
        int column = 5;
        for (int i = 0; i < this.rgbData.length; ++i) {
            this.rgbData[i] = row < this.row ? (this.scaler[row] < column || this.height - this.scaler[row] > column ? 0 : this.nextCanvasRgb[i]) : (this.scaler[row] < column || this.height - this.scaler[row] > column ? 0 : this.lastCanvasRgb[i]);
            row = (row + 1) % this.width;
            if (row != 0) continue;
            ++column;
        }
        --this.lstScale;
        this.cubeEffect();
        return this.stillRun;
    }

    private void cubeEffect() {
        for (int i = this.width - 1; i > this.lstScale; --i) {
            if (this.scaler[i] > this.height - 60) {
                int n = i;
                this.scaler[n] = this.scaler[n] - 1;
                continue;
            }
            this.scaler[i] = 0;
        }
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.rgbData, 0, this.width, 0, 0, this.width, this.height, false);
    }
}

