/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.rgbfilters;

import de.enough.polish.ui.Graphics;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DropShadowRgbFilter
extends RgbFilter {
    private int innerColor = -1601138544;
    private int outerColor = 0x20909090;
    private int size = 6;
    private int xOffset = 1;
    private int yOffset = 2;

    public int getSize() {
        return this.size;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public RgbImage process(RgbImage input) {
        int imgHeight = input.getHeight();
        int imgWidth = input.getWidth();
        int newWidth = imgWidth + this.size * 2 + Math.abs(this.xOffset);
        int newHeight = imgHeight + this.size * 2 + Math.abs(this.yOffset);
        int iLeft = this.size - this.xOffset < 0 ? 0 : this.size - this.xOffset;
        int iTop = this.size - this.yOffset < 0 ? 0 : this.size - this.yOffset;
        RgbImage newImage = new RgbImage(newWidth, newHeight);
        ImageUtil.drawRgbImageOntoOther(newImage, input, iLeft, iTop);
        Graphics.dropShadow(newImage.getRgbData(), newWidth, newHeight, this.xOffset, this.yOffset, this.size, this.innerColor, this.outerColor);
        return newImage;
    }

    public boolean isActive() {
        return this.size != 0;
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.innerColor = dataInputStream.readInt();
        this.outerColor = dataInputStream.readInt();
        this.size = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.innerColor);
        dataOutputStream.writeInt(this.outerColor);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

