/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.remotescreen;

import de.enough.polish.bluetooth.DiscoveryHelper;
import de.enough.polish.bluetooth.L2CapOutputStream;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.RemoteScreen;
import de.enough.polish.ui.remotescreen.ScreenUpdate;
import de.enough.polish.util.Debug;
import de.enough.polish.util.ZipUtil;
import java.io.DataOutputStream;
import javax.bluetooth.L2CAPConnection;

public class BluetoothRemoteScreen
implements RemoteScreen,
Runnable {
    private static final int VERSION = 80;
    private static final int MAX_RGB_CHUNK = 10922;
    private final ScreenUpdate screenUpdate = new ScreenUpdate();
    private boolean isConnected;
    private int screenWidth;
    private int screenHeight;
    private int degrees;

    public BluetoothRemoteScreen() {
        new Thread(this).start();
    }

    public void init(int width, int height, int degrees) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.degrees = degrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScreen(int x, int y, int width, int height, int[] rgb) {
        ScreenUpdate update;
        if (!this.isConnected) {
            return;
        }
        ScreenUpdate screenUpdate = update = this.screenUpdate;
        synchronized (screenUpdate) {
            ++update.refreshCounter;
            if (update.refreshCounter == Integer.MAX_VALUE) {
                update.refreshCounter = Integer.MIN_VALUE;
            }
            update.x = x;
            update.y = y;
            update.width = width;
            update.height = height;
            update.rgb = rgb;
            update.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block22: {
            con = null;
            try {
                try {
                    storeAndReuseConnectionUrl = true;
                    con = (L2CAPConnection)DiscoveryHelper.findAndConnectService("5ab90370a64d11ddad8b0800200c9a66", 10390323, 256, storeAndReuseConnectionUrl);
                    if (con == null) {
                        var24_4 = null;
                        this.isConnected = false;
                        if (con == null) return;
                        break block22;
                    }
                    if (this.screenWidth == 0) {
                        this.screenWidth = Display.getScreenWidth();
                        this.screenHeight = Display.getScreenHeight();
                    }
                    this.isConnected = true;
                    l2CapOut = new L2CapOutputStream(con);
                    out = new DataOutputStream(l2CapOut);
                    out.writeInt(80);
                    out.writeUTF(Display.getInstance().getMidlet().getClass().getName());
                    out.writeInt(this.screenWidth);
                    out.writeInt(this.screenHeight);
                    out.writeInt(this.degrees);
                    out.flush();
                    update = this.screenUpdate;
                    lastDuration = 0L;
                    lastError = null;
                    while (true) {
                        var18_23 = update;
                        synchronized (var18_23) {
                            refreshCounter = update.refreshCounter;
                            x = update.x;
                            y = update.y;
                            width = update.width;
                            height = update.height;
                            rgb = update.rgb;
                            ** if (rgb == null) goto lbl63
                        }
lbl-1000:
                        // 1 sources

                        {
                            transferStart = System.currentTimeMillis();
                            try {
                                out.writeUTF("lastDuration=" + lastDuration + ", error=" + lastError);
                                out.writeShort(x);
                                out.writeShort(y);
                                out.writeShort(width);
                                out.writeShort(height);
                                numberOfChunks = rgb.length / 10922;
                                if (rgb.length % 10922 != 0) {
                                    ++numberOfChunks;
                                }
                                out.writeShort(numberOfChunks);
                                offset = 0;
                                len = 10922;
                                for (i = 0; i < numberOfChunks; offset += len, ++i) {
                                    if (offset + len > rgb.length) {
                                        len = rgb.length - offset;
                                    }
                                    rgbData = ZipUtil.convertRgbToByteArray(rgb, offset, len);
                                    out.writeShort(rgbData.length);
                                    out.write(rgbData);
                                }
                                out.flush();
                            }
                            catch (Throwable t) {
                                lastError = t.toString();
                            }
                            lastDuration = System.currentTimeMillis() - transferStart;
                            var11_20 = null;
                        }
lbl63:
                        // 2 sources

                        var18_23 = update;
                        synchronized (var18_23) {
                            if (update.refreshCounter == refreshCounter) {
                                update.rgb = null;
                                update.wait();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.remotescreen.BluetoothRemoteScreen", 190, (Object)"Unable to find or access bluetooth service", e);
                    var24_5 = null;
                    this.isConnected = false;
                    if (con == null) return;
                    try {
                        con.close();
                        return;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            }
            catch (Throwable var23_29) {
                var24_6 = null;
                this.isConnected = false;
                if (con == null) throw var23_29;
                ** try [egrp 5[TRYBLOCK] [10 : 491->500)] { 
lbl86:
                // 1 sources

                con.close();
                throw var23_29;
lbl88:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                throw var23_29;
            }
        }
        ** try [egrp 5[TRYBLOCK] [10 : 491->500)] { 
lbl93:
        // 1 sources

        con.close();
        return;
lbl95:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
    }
}

