/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.itemviews;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ExplodingParticlesItemView
extends ItemView {
    private int scaleFactor = 260;
    private int steps = 10;
    private int currentStep;
    private int[] originalRgb;
    private int[] scaledRgb;
    private boolean isDirectionUp;
    private int paintWidth;
    private int paintHeight;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.initContentByParent(parent, firstLineWidth, availWidth, availHeight);
        int width = this.contentWidth * this.scaleFactor / 100;
        int height = this.contentHeight * this.scaleFactor / 100;
        int[] rgbData = new int[width * height];
        int x = width - this.contentWidth >> 1;
        int y = height - this.contentHeight >> 1;
        UiAccess.getRgbDataOfContent(parent, rgbData, x, y, width);
        int[] target = new int[rgbData.length];
        System.arraycopy(rgbData, 0, target, 0, rgbData.length);
        this.paintWidth = width;
        this.paintHeight = height;
        this.isDirectionUp = true;
        this.originalRgb = rgbData;
        this.scaledRgb = target;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.scaledRgb == null) {
            return;
        }
        super.animate(currentTime, repaintRegion);
        int step = this.currentStep;
        if (this.isDirectionUp) {
            if (++step >= this.steps) {
                this.isDirectionUp = false;
            }
        } else if (--step <= 0) {
            step = 0;
            this.isDirectionUp = true;
        }
        this.currentStep = step;
        int factor = 100 + (this.scaleFactor - 100) * (step * step) / ((this.steps - 1) * (this.steps - 1));
        ImageUtil.particleScale(factor, this.paintWidth, this.paintHeight, this.originalRgb, this.scaledRgb);
        Item item = this.parentItem;
        repaintRegion.addRegion(item.getAbsoluteX() - (this.paintWidth - item.itemWidth >> 1), item.getAbsoluteY() - (this.paintHeight - item.itemHeight >> 1), this.paintWidth, this.paintHeight);
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.scaledRgb == null) {
            super.paintContentByParent(parent, x, y, leftBorder, rightBorder, g);
            return;
        }
        DrawUtil.drawRgb(this.scaledRgb, x - (this.paintWidth - this.contentWidth >> 1), y - (this.paintHeight - this.contentHeight >> 1), this.paintWidth, this.paintHeight, true, g);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.currentStep = dataInputStream.readInt();
        this.isDirectionUp = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.originalRgb = new int[n2];
            n = 0;
            while (n < n2) {
                this.originalRgb[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.paintHeight = dataInputStream.readInt();
        this.paintWidth = dataInputStream.readInt();
        this.scaleFactor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.scaledRgb = new int[n2];
            n = 0;
            while (n < n2) {
                this.scaledRgb[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.steps = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.currentStep);
        dataOutputStream.writeBoolean(this.isDirectionUp);
        if (this.originalRgb == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.originalRgb.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.originalRgb[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.paintHeight);
        dataOutputStream.writeInt(this.paintWidth);
        dataOutputStream.writeInt(this.scaleFactor);
        if (this.scaledRgb == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.scaledRgb.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.scaledRgb[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.steps);
    }
}

