/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.game;

import de.enough.polish.ui.game.Layer;
import javax.microedition.lcdui.Graphics;

public class LayerManager {
    private Layer[] layers = new Layer[5];
    private int size;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private boolean isViewWindowSet;

    public void append(Layer l) {
        if (this.size == this.layers.length) {
            Layer[] newLayers = new Layer[this.size + 4];
            System.arraycopy(this.layers, 0, newLayers, 0, this.size);
            this.layers = newLayers;
        }
        this.layers[this.size] = l;
        ++this.size;
    }

    public void insert(Layer l, int index) {
        Layer[] source;
        this.remove(l);
        if (index > this.size) {
            index = this.size;
        }
        if (this.size == (source = this.layers).length || index == source.length) {
            Layer[] newLayers = new Layer[this.size + 4];
            System.arraycopy(this.layers, 0, newLayers, 0, this.size);
            source = newLayers;
        }
        for (int i = this.size; i > index; --i) {
            source[i] = source[i - 1];
        }
        source[index] = l;
        this.layers = source;
        ++this.size;
    }

    public Layer getLayerAt(int index) {
        return this.layers[index];
    }

    public int getSize() {
        return this.size;
    }

    public void remove(Layer l) {
        Layer[] source = this.layers;
        boolean layerFound = false;
        for (int i = 0; i < this.size; ++i) {
            Layer layer = source[i];
            if (layerFound) {
                source[i] = source[i + 1];
                continue;
            }
            if (layer != l) continue;
            layerFound = true;
            --this.size;
            if (i == this.size) continue;
            source[i] = source[i + 1];
        }
        if (layerFound) {
            source[this.size] = null;
        }
    }

    public void paint(Graphics g, int x, int y) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (this.isViewWindowSet) {
            g.setClip(x, y, this.viewWidth, this.viewHeight);
            minX = this.viewX;
            maxX = minX + this.viewWidth;
            minY = this.viewY;
            maxY = minY + this.viewHeight;
        } else {
            minX = x;
            maxX = x + clipWidth;
            minY = y;
            maxY = y + clipHeight;
        }
        g.translate(x - this.viewX, y - this.viewY);
        for (int i = this.size - 1; i >= 0; --i) {
            Layer layer = this.layers[i];
            if (!layer.isVisible) continue;
            int layerX = layer.getX();
            int layerY = layer.getY();
            int layerWidth = layer.getWidth();
            int layerHeight = layer.getHeight();
            if (layerX + layerWidth < minX || layerX > maxX || layerY + layerHeight < minY || layerY > maxY) continue;
            layer.paint(g);
        }
        g.translate(-(x - this.viewX), -(y - this.viewY));
        if (this.isViewWindowSet) {
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public void setViewWindow(int x, int y, int width, int height) {
        this.isViewWindowSet = true;
        this.viewX = x;
        this.viewY = y;
        this.viewWidth = width;
        this.viewHeight = height;
    }
}

