/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.game;

import de.enough.polish.ui.Screen;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GameCanvas
extends Screen {
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    private int keyStates;
    private int releasedKeys;
    private Image bufferedImage;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;
    private boolean setClip;

    protected GameCanvas(boolean suppressKeyEvents) {
        super(null, null, false);
        int width = 240;
        int height = 320;
        this.bufferedImage = Image.createImage(width, height);
    }

    protected Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public int getKeyStates() {
        int states = this.keyStates;
        this.keyStates &= ~this.releasedKeys;
        this.releasedKeys = 0;
        return states;
    }

    public void paintScreen(Graphics g) {
        g.setClip(0, 0, 240, 320);
        if (this.setClip) {
            g.clipRect(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.setClip = false;
        }
        g.drawImage(this.bufferedImage, 0, 0, 20);
    }

    public void flushGraphics(int x, int y, int width, int height) {
        this.setClip = true;
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        this.repaint();
        this.serviceRepaints();
    }

    public void flushGraphics() {
        this.repaint();
        this.serviceRepaints();
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (gameAction != 0) {
            int bit = 1 << gameAction;
            this.keyStates |= bit;
            this.releasedKeys &= ~bit;
        }
        return false;
    }

    public boolean handleKeyReleased(int keyCode, int gameAction) {
        if (gameAction != 0) {
            this.releasedKeys |= 1 << gameAction;
        }
        return false;
    }

    protected String createCssSelector() {
        return "gamecanvas";
    }
}

