/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalGrayOutContainerView
extends ContainerView {
    private int targetOffset;
    private int offset = -1;
    private boolean animateItems;
    private transient int[][] inactiveIcons = null;
    private int[] inactivateIconWidhts;
    private int[] inactivateIconHeights;
    private boolean isInitialized;

    public HorizontalGrayOutContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        Container parent = (Container)parentItm;
        int height = 0;
        int completeWidth = 0;
        Item[] items = parent.getItems();
        this.inactiveIcons = new int[items.length][];
        this.inactivateIconWidhts = new int[items.length];
        this.inactivateIconHeights = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int itemHeight = item.getItemHeight(availWidth, availWidth, availHeight);
            int itemWidth = item.itemWidth;
            if (itemWidth == 0) {
                this.inactiveIcons[i] = new int[0];
                this.inactivateIconWidhts[i] = 0;
                this.inactivateIconHeights[i] = 0;
                continue;
            }
            int[] rgbData = UiAccess.getRgbData(item);
            this.convertToGrayScale(rgbData);
            this.inactiveIcons[i] = rgbData;
            this.inactivateIconWidhts[i] = itemWidth;
            this.inactivateIconHeights[i] = itemHeight;
            if (itemHeight > height) {
                height = itemHeight;
            }
            item.relativeX = completeWidth;
            item.relativeY = 0;
            completeWidth += itemWidth + this.paddingHorizontal;
            if (item.appearanceMode == 0) continue;
            this.appearanceMode = 3;
        }
        this.contentHeight = height;
        this.contentWidth = availWidth;
        this.animateItems = true;
        this.isInitialized = true;
        if (this.focusedItem == null && items.length > 0) {
            Item item = items[0];
            this.focusItem(0, item, 5, item.getFocusedStyle());
        }
    }

    public Style focusItem(int index, Item item, int direction, Style focusedStyle) {
        if (this.isInitialized) {
            int focusOffset;
            this.targetOffset = focusOffset = (this.contentWidth >> 1) - (item.itemWidth >> 1);
            for (int i = 0; i < index; ++i) {
                this.targetOffset -= this.parentContainer.get((int)i).itemWidth;
            }
            if (this.offset == -1) {
                this.offset = this.targetOffset;
            }
            this.animateItems = true;
        }
        return super.focusItem(index, item, direction, focusedStyle);
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.animateItems) {
            int delta = Math.abs(this.targetOffset - this.offset) / 3;
            if (delta < 1) {
                delta = 1;
            }
            if (this.targetOffset > this.offset) {
                this.offset += delta;
            } else if (this.targetOffset < this.offset) {
                this.offset -= delta;
            } else if (this.targetOffset == this.offset) {
                this.animateItems = false;
            }
            animated = true;
        }
        return animated;
    }

    protected void convertToGrayScale(int[] rgbData) {
        for (int i = 0; i < rgbData.length; ++i) {
            int color2 = rgbData[i];
            int alpha = 0xFF000000 & color2;
            int red = 0xFF & color2 >>> 16;
            int green = 0xFF & color2 >>> 8;
            int blue = color2 & 0xFF;
            int brightness = (red + green + blue) / 3 & 0xFF;
            color2 = brightness << 0 | brightness << 8 | brightness << 16;
            rgbData[i] = color2 |= alpha;
        }
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int itemOffset = this.offset;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            int[] rgbData = this.inactiveIcons[i];
            int itemWidth = this.inactivateIconWidhts[i];
            int itemHeight = this.inactivateIconHeights[i];
            DrawUtil.drawRgb(rgbData, x + itemOffset, y, itemWidth, itemHeight, true, g);
            itemOffset += item.itemWidth;
        }
        if (this.focusedItem != null) {
            int focusOffset = x + (this.contentWidth >> 1) - (this.focusedItem.itemWidth >> 1);
            g.clipRect(focusOffset, y, this.focusedItem.itemWidth, this.contentHeight);
            itemOffset = this.offset;
            for (int i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                item.paint(x + itemOffset, y, x + itemOffset, x + itemOffset + item.itemWidth, g);
                itemOffset += item.itemWidth;
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    protected boolean isValid(Item parent, Style style) {
        return super.isValid(parent, style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.animateItems = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.inactivateIconHeights = new int[n2];
            n = 0;
            while (n < n2) {
                this.inactivateIconHeights[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.inactivateIconWidhts = new int[n2];
            n = 0;
            while (n < n2) {
                this.inactivateIconWidhts[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.isInitialized = dataInputStream.readBoolean();
        this.offset = dataInputStream.readInt();
        this.targetOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animateItems);
        if (this.inactivateIconHeights == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.inactivateIconHeights.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.inactivateIconHeights[n]);
                ++n;
            }
        }
        if (this.inactivateIconWidhts == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.inactivateIconWidhts.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.inactivateIconWidhts[n]);
                ++n;
            }
        }
        dataOutputStream.writeBoolean(this.isInitialized);
        dataOutputStream.writeInt(this.offset);
        dataOutputStream.writeInt(this.targetOffset);
    }
}

