/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CenterNavigationContainerView
extends ContainerView {
    static transient ImageItem leftItem;
    static transient ImageItem rightItem;
    int grayOffset = 0;
    private transient int[][] inactiveIcons = null;
    private int itemMaxWidth;
    private int leftItemWidth;
    private int rightItemWidth;
    boolean animateItems = false;
    Style originalStyle;

    public CenterNavigationContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        Integer grayOffsetObj = style.getIntProperty(347);
        if (grayOffsetObj != null) {
            this.grayOffset = grayOffsetObj;
        }
    }

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        this.parentContainer = (Container)parentItm;
        int height = 0;
        Item[] items = this.parentContainer.getItems();
        this.inactiveIcons = new int[items.length][];
        int maxWidth = 0;
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int itemHeight = item.getItemHeight(availWidth, availWidth, availHeight);
            int itemWidth = item.itemWidth;
            if (itemWidth > maxWidth) {
                maxWidth = itemWidth;
            }
            item.relativeX = (availWidth - maxWidth) / 2;
            if (itemWidth == 0) {
                this.inactiveIcons[i] = new int[0];
                continue;
            }
            if (itemHeight > height) {
                height = itemHeight;
            }
            if (item.isFocused) {
                item.setStyle(this.originalStyle);
            }
            int[] rgbData = UiAccess.getRgbData(item);
            if (item.isFocused) {
                item.setStyle(item.getFocusedStyle());
            }
            this.convertToGrayScale(rgbData, this.grayOffset);
            this.inactiveIcons[i] = rgbData;
        }
        this.leftItemWidth = leftItem.getItemWidth(availWidth, availWidth, availHeight);
        this.rightItemWidth = rightItem.getItemWidth(availWidth, availWidth, availHeight);
        CenterNavigationContainerView.rightItem.relativeX = availWidth - this.rightItemWidth;
        rightItem.setParent(parentItm);
        leftItem.setParent(parentItm);
        this.itemMaxWidth = maxWidth;
        this.contentHeight = height;
        this.contentWidth = availWidth;
    }

    public Style focusItem(int index, Item item, int direction, Style focusedStyle) {
        this.originalStyle = super.focusItem(index, item, direction, focusedStyle);
        return this.originalStyle;
    }

    protected void convertToGrayScale(int[] rgbData, int grayOffset) {
        for (int i = 0; i < rgbData.length; ++i) {
            int color2 = rgbData[i];
            int alpha = 0xFF000000 & color2;
            int red = 0xFF & color2 >>> 16;
            int green = 0xFF & color2 >>> 8;
            int blue = color2 & 0xFF;
            int brightness = (red + green + blue) / 3 & 0xFF;
            if ((brightness += grayOffset) > 255) {
                brightness = 255;
            }
            color2 = brightness << 0 | brightness << 8 | brightness << 16;
            rgbData[i] = color2 |= alpha;
        }
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int originalLeftBorder = leftBorder;
        int originalRightBorder = rightBorder;
        int width = rightBorder - leftBorder;
        leftBorder += this.leftItemWidth;
        rightBorder -= this.rightItemWidth;
        int center = width / 2;
        int itemWidth = this.itemMaxWidth;
        int offset = center - this.focusedIndex * itemWidth - itemWidth / 2;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            int myXOffset = x + offset;
            if (myXOffset > leftBorder && myXOffset + itemWidth < rightBorder) {
                if (item == this.focusedItem) {
                    item.paint(myXOffset, y, leftBorder, rightBorder, g);
                } else {
                    int[] rgbData = this.inactiveIcons[i];
                    if (rgbData != null) {
                        DrawUtil.drawRgb(rgbData, myXOffset, y, item.itemWidth, item.itemHeight, true, g);
                    } else {
                        item.paint(myXOffset, y, leftBorder, rightBorder, g);
                    }
                }
            }
            offset += itemWidth;
        }
        leftBorder = originalLeftBorder;
        rightBorder = originalRightBorder;
        if (myItems.length != 0) {
            if (this.focusedIndex != 0) {
                leftItem.paint(leftBorder, y, leftBorder, rightBorder, g);
            }
            if (this.focusedIndex != myItems.length - 1) {
                x = rightBorder - this.rightItemWidth;
                rightItem.paint(x, y, x, rightBorder, g);
            }
        }
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Container;
    }

    public boolean handlePointerPressed(int x, int y) {
        if (y < 0 || y > this.contentHeight) {
            return false;
        }
        if (x < this.leftItemWidth) {
            UiAccess.notifyItemPressedStart(leftItem);
            return true;
        }
        if (x > this.contentWidth - this.rightItemWidth) {
            UiAccess.notifyItemPressedStart(rightItem);
            return true;
        }
        return super.handlePointerPressed(x, y);
    }

    public boolean handlePointerReleased(int x, int y) {
        if (y < 0 || y > this.contentHeight) {
            return false;
        }
        if (x < this.leftItemWidth) {
            UiAccess.notifyItemPressedEnd(leftItem);
            int nextIndex = this.focusedIndex - 1;
            if (nextIndex >= 0) {
                this.parentContainer.focusChild(nextIndex);
            }
            return true;
        }
        if (x > this.contentWidth - this.rightItemWidth) {
            UiAccess.notifyItemPressedEnd(rightItem);
            int nextIndex = this.focusedIndex + 1;
            if (nextIndex < this.parentContainer.size()) {
                this.parentContainer.focusChild(nextIndex);
            }
            return true;
        }
        int focusedX = (this.contentWidth - this.itemMaxWidth) / 2;
        int relativeX = x - focusedX;
        int relativeIndex = relativeX / this.itemMaxWidth;
        int nextIndex = this.focusedIndex + relativeIndex;
        if (relativeX < 0) {
            --nextIndex;
        }
        if (nextIndex >= 0 && nextIndex < this.parentContainer.size()) {
            this.parentContainer.focusChild(nextIndex);
            return true;
        }
        return super.handlePointerReleased(x, y);
    }

    static {
        try {
            leftItem = new ImageItem(null, Image.createImage("/arrow_left.png"), 1, null);
            rightItem = new ImageItem(null, Image.createImage("/arrow_right.png"), 2, null);
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.containerviews.CenterNavigationContainerView", 42, (Object)"Unable to load arrow resource ", e);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animateItems = dataInputStream.readBoolean();
        this.grayOffset = dataInputStream.readInt();
        this.itemMaxWidth = dataInputStream.readInt();
        this.leftItemWidth = dataInputStream.readInt();
        this.originalStyle = (Style)Serializer.deserialize(dataInputStream);
        this.rightItemWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animateItems);
        dataOutputStream.writeInt(this.grayOffset);
        dataOutputStream.writeInt(this.itemMaxWidth);
        dataOutputStream.writeInt(this.leftItemWidth);
        Serializer.serialize(this.originalStyle, dataOutputStream);
        dataOutputStream.writeInt(this.rightItemWidth);
    }
}

