/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AlignAtContentContainerView
extends ContainerView {
    Dimension contentX;

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(parentContainerItem, firstLineWidth, availWidth, availHeight);
        Item[] items = this.parentContainer.getItems();
        int startX = 0;
        if (this.contentX != null) {
            startX = this.contentX.getValue(availWidth);
        } else {
            int maxLabelWidth = 0;
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                Item label = item.getLabelItem();
                if (label == null || label.itemWidth <= maxLabelWidth) continue;
                maxLabelWidth = label.itemWidth;
            }
            startX = maxLabelWidth;
        }
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            Item label = item.getLabelItem();
            item.relativeX = label == null ? startX : startX - label.itemWidth;
        }
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.contentX = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.contentX, dataOutputStream);
    }
}

