/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.clockviews;

import de.enough.polish.ui.ClockItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Graphics;

public class BinaryTextClockView
extends ItemView {
    protected transient Date date = new Date();
    protected transient Calendar calendar = Calendar.getInstance();
    protected transient StringItem clockText = new StringItem(null, null);
    protected transient long lastTimeUpdate;
    protected transient ClockItem clockItem;

    public boolean animate() {
        boolean animated = super.animate();
        long time = System.currentTimeMillis();
        if (this.clockItem.includeSeconds() && time / 1000L > this.lastTimeUpdate / 1000L || !this.clockItem.includeSeconds() && time / 60000L > this.lastTimeUpdate / 60000L) {
            this.clockText.setText(this.updateTime(time));
            animated = true;
        }
        return animated;
    }

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.clockItem = (ClockItem)parent;
        this.clockText.setText(this.updateTime(System.currentTimeMillis()));
        this.contentWidth = this.clockText.getItemWidth(firstLineWidth, availWidth, availHeight);
        this.contentHeight = this.clockText.getItemHeight(firstLineWidth, availWidth, availHeight);
    }

    protected String updateTime(long time) {
        this.lastTimeUpdate = time;
        this.date.setTime(time);
        this.calendar.setTime(this.date);
        String hour = Integer.toBinaryString(this.calendar.get(11));
        String minute = Integer.toBinaryString(this.calendar.get(12));
        String seconds = null;
        if (this.clockItem.includeSeconds()) {
            seconds = Integer.toBinaryString(this.calendar.get(13));
        }
        return this.clockItem.updateTime(hour, minute, seconds);
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        this.clockText.paint(x, y, leftBorder, rightBorder, g);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof ClockItem;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        this.clockText.setStyle(style);
        this.removeParentBackground();
        this.removeParentBorder();
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }
}

