/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TranslucentRoundRectBorder
extends Border {
    protected int color;
    private int arcWidth;
    private int arcHeight;
    private int[] rgbDataLt;
    private int[] rgbDataRt;
    private int[] rgbDataLb;
    private int[] rgbDataRb;

    public TranslucentRoundRectBorder(int argbColor, int borderWidth, int arcWidth, int arcHeight) {
        super(borderWidth, borderWidth, borderWidth, borderWidth);
        this.color = argbColor;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        boolean isTransparent;
        g.setColor(this.color);
        boolean bl = isTransparent = (this.color & 0xFF000000) != 0;
        if (this.borderWidthLeft == 1 && !isTransparent) {
            g.drawRoundRect(x, y, --width, --height, this.arcWidth, this.arcHeight);
        } else {
            int[] lt = this.rgbDataLt;
            int[] rt = this.rgbDataRt;
            int[] lb = this.rgbDataLb;
            int[] rb = this.rgbDataRb;
            int aw = this.arcWidth;
            int ah = this.arcHeight;
            int bw = this.borderWidthLeft;
            if (lt == null) {
                int bgColor = DrawUtil.getComplementaryColor(this.color);
                if (bgColor == this.color) {
                    bgColor = 0;
                }
                int maxW = Math.max(bw, aw);
                int maxH = Math.max(bw, ah);
                Image img = Image.createImage(maxW, maxH);
                Graphics imgG = img.getGraphics();
                imgG.setColor(bgColor);
                imgG.fillRect(0, 0, maxW, maxH);
                imgG.setColor(this.color);
                imgG.fillRoundRect(0, 0, width, height, aw, ah);
                imgG.setColor(bgColor);
                imgG.fillRoundRect(bw, bw, width - (bw << 1), height - (bw << 1), aw, ah);
                lt = new int[maxW * maxH];
                img.getRGB(lt, 0, maxW, 0, 0, maxW, maxH);
                bgColor = lt[0];
                int transparencyMask = isTransparent ? this.color & 0xFF000000 | 0xFFFFFF & this.color : this.color | 0xFF000000;
                boolean isLastPixelFullyTransparent = true;
                int halfTransparentColor = (this.color >>> 1 | 0xFFFFFF) & (this.color | 0xFF000000);
                for (int row = 0; row < maxH; ++row) {
                    isLastPixelFullyTransparent = true;
                    for (int column = 0; column < maxW; ++column) {
                        int i = column + row * maxW;
                        int pixel = lt[i];
                        if (pixel == bgColor) {
                            lt[i] = 0;
                            if (isLastPixelFullyTransparent) continue;
                            lt[i - 1] = halfTransparentColor;
                            isLastPixelFullyTransparent = true;
                            continue;
                        }
                        if (isLastPixelFullyTransparent) {
                            lt[i] = halfTransparentColor;
                            isLastPixelFullyTransparent = false;
                            continue;
                        }
                        if (!isTransparent) continue;
                        lt[i] = pixel & transparencyMask;
                    }
                }
                rt = new int[lt.length];
                ImageUtil.rotateSimple(lt, rt, maxW, maxH, 90);
                rb = new int[lt.length];
                ImageUtil.rotateSimple(lt, rb, maxW, maxH, 180);
                lb = new int[lt.length];
                ImageUtil.rotateSimple(lt, lb, maxW, maxH, 270);
                this.rgbDataRt = rt;
                this.rgbDataRb = rb;
                this.rgbDataLb = lb;
                this.rgbDataLt = lt;
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            DrawUtil.drawRgb(lt, x, y, aw, ah, true, clipX, clipY, clipW, clipH, g);
            DrawUtil.drawRgb(rt, x + width - aw, y, aw, ah, true, clipX, clipY, clipW, clipH, g);
            DrawUtil.drawRgb(lb, x, y + height - ah, aw, ah, true, clipX, clipY, clipW, clipH, g);
            DrawUtil.drawRgb(rb, x + width - aw, y + height - ah, aw, ah, true, clipX, clipY, clipW, clipH, g);
            for (int i = 0; i < bw; ++i) {
                if (isTransparent) {
                    DrawUtil.drawLine(this.color, x + aw, y + i, x + width - aw, y + i, g);
                    DrawUtil.drawLine(this.color, x + aw, y + height - i, x + width - aw, y + height - i, g);
                    DrawUtil.drawLine(this.color, x + i, y + ah, x + i, y + height - ah, g);
                    DrawUtil.drawLine(this.color, x + width - i, y + ah, x + width - i, y + height - ah, g);
                    continue;
                }
                g.drawLine(x + aw, y + i, x + width - aw, y + i);
                g.drawLine(x + aw, y + height - i, x + width - aw, y + height - i);
                g.drawLine(x + i, y + ah, x + i, y + height - ah);
                g.drawLine(x + width - i, y + ah, x + width - i, y + height - ah);
            }
        }
    }

    public TranslucentRoundRectBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataLb = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataLb[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataLt = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataLt[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataRb = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataRb[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataRt = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataRt[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.color);
        if (this.rgbDataLb == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataLb.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataLb[n]);
                ++n;
            }
        }
        if (this.rgbDataLt == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataLt.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataLt[n]);
                ++n;
            }
        }
        if (this.rgbDataRb == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataRb.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataRb[n]);
                ++n;
            }
        }
        if (this.rgbDataRt == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataRt.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataRt[n]);
                ++n;
            }
        }
    }
}

