/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DropShadowRoundRectBorder
extends Border {
    public static final int BOTTOM_RIGHT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int TOP_LEFT = 3;
    public static final int ALL = 4;
    private int[] shadowColors;
    private int orientation;
    private int arcWidth;
    private int arcHeight;
    private int[] rgbDataLt;
    private int[] rgbDataRt;
    private int[] rgbDataLb;
    private int[] rgbDataRb;
    private int borderWidth;

    public DropShadowRoundRectBorder(int innerColor, int outerColor, int width, int orientation, int arcWidth, int arcHeight) {
        super(0, 0, 0, 0);
        this.borderWidth = width;
        this.orientation = orientation;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.shadowColors = DrawUtil.getGradient(outerColor, innerColor, width);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int[] lt = this.rgbDataLt;
        int[] rt = this.rgbDataRt;
        int[] lb = this.rgbDataLb;
        int[] rb = this.rgbDataRb;
        int aw = this.arcWidth;
        int ah = this.arcHeight;
        int bw = this.borderWidth;
        if (lt == null) {
            int maxW = Math.max(bw, aw);
            int maxH = Math.max(bw, ah);
            Image img = Image.createImage(maxW, maxH);
            Graphics imgG = img.getGraphics();
            imgG.setColor(0);
            imgG.fillRoundRect(0, 0, width, height, aw, ah);
            lt = new int[maxW * maxH];
            img.getRGB(lt, 0, maxW, 0, 0, maxW, maxH);
            int bgColor = lt[0];
            int innerColor = this.shadowColors[bw - 1];
            int[] startRows = new int[maxH];
            for (int i = 0; i < startRows.length; ++i) {
                startRows[i] = -1;
            }
            int startColumn = -1;
            for (int row = 0; row < maxH; ++row) {
                for (int column = 0; column < maxW; ++column) {
                    int min;
                    int startRow;
                    int i = column + row * maxW;
                    int pixel = lt[i];
                    if (pixel == bgColor) {
                        lt[i] = 0;
                        continue;
                    }
                    if (startColumn == -1) {
                        startColumn = column;
                    }
                    if ((startRow = startRows[column]) == -1) {
                        startRows[column] = startRow = row;
                    }
                    lt[i] = (min = Math.min(column - startColumn, row - startRow)) < bw ? this.shadowColors[min] : innerColor;
                }
                startColumn = -1;
            }
            rt = new int[lt.length];
            ImageUtil.rotateSimple(lt, rt, maxW, maxH, 90);
            rb = new int[lt.length];
            ImageUtil.rotateSimple(lt, rb, maxW, maxH, 180);
            lb = new int[lt.length];
            ImageUtil.rotateSimple(lt, lb, maxW, maxH, 270);
            this.rgbDataRt = rt;
            this.rgbDataRb = rb;
            this.rgbDataLb = lb;
            this.rgbDataLt = lt;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        switch (this.orientation) {
            case 0: {
                DrawUtil.drawRgb(rt, x + width - (aw - bw), y + bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(lb, x + bw, y + height - (ah - bw), aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rb, x + width - (aw - bw), y + height - (ah - bw), aw, ah, true, clipX, clipY, clipW, clipH, g);
                break;
            }
            case 1: {
                DrawUtil.drawRgb(lt, x + bw, y - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rt, x + width - aw + bw, y - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rb, x + width - (aw - bw), y + height - ah - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                break;
            }
            case 2: {
                DrawUtil.drawRgb(lt, x - bw, y + bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(lb, x - bw, y + height + bw - ah, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rb, x + width - aw - bw, y + height + bw - ah, aw, ah, true, clipX, clipY, clipW, clipH, g);
                break;
            }
            case 3: {
                DrawUtil.drawRgb(lt, x - bw, y - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rt, x + width - aw - bw, y - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(lb, x - bw, y + height - ah - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                break;
            }
            case 4: {
                DrawUtil.drawRgb(lt, x - bw, y - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rt, x + width - (aw - bw), y - bw, aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(lb, x - bw, y + height - (ah - bw), aw, ah, true, clipX, clipY, clipW, clipH, g);
                DrawUtil.drawRgb(rb, x + width - (aw - bw), y + height - (ah - bw), aw, ah, true, clipX, clipY, clipW, clipH, g);
            }
        }
        int left = x;
        int top = y;
        int right = x + width;
        int bottom = y + height;
        block17: for (int i = 0; i < bw; ++i) {
            int color2 = this.shadowColors[bw - (i + 1)];
            switch (this.orientation) {
                case 0: {
                    DrawUtil.drawLine(color2, right + i, top + ah + bw, right + i, bottom + bw - ah, g);
                    DrawUtil.drawLine(color2, left + bw + aw, bottom + i, right + bw - aw, bottom + i, g);
                    continue block17;
                }
                case 1: {
                    DrawUtil.drawLine(color2, right + i, top - bw + ah, right + i, bottom - bw - ah, g);
                    DrawUtil.drawLine(color2, left + bw + aw, top - i - 1, right + bw - aw, top - i - 1, g);
                    continue block17;
                }
                case 2: {
                    DrawUtil.drawLine(color2, left - i - 1, top + bw + ah, left - i - 1, bottom - ah + bw, g);
                    DrawUtil.drawLine(color2, left - bw + aw, bottom + i, right - bw - aw, bottom + i, g);
                    continue block17;
                }
                case 3: {
                    DrawUtil.drawLine(color2, left - i - 1, top - bw + ah, left - i - 1, bottom - bw - ah, g);
                    DrawUtil.drawLine(color2, left - bw + aw, top - i - 1, right - bw - aw, top - i - 1, g);
                    continue block17;
                }
                case 4: {
                    DrawUtil.drawLine(color2, left - i - 1, top - bw + ah, left - i - 1, bottom + bw - ah, g);
                    DrawUtil.drawLine(color2, right + i, top - bw + ah, right + i, bottom + bw - ah, g);
                    DrawUtil.drawLine(color2, left - bw + aw, bottom + i, right + bw - aw, bottom + i, g);
                    DrawUtil.drawLine(color2, left - bw + aw, top - i - 1, right + bw - aw, top - i - 1, g);
                }
            }
        }
    }

    private int getPixel(int column, int row, int maxW, int maxH, int[] lt, int bgColor) {
        int start;
        for (int i = start = row * maxW; i > start - maxW; --i) {
            int pixel = lt[i];
            if (pixel == bgColor) continue;
            if (column - i < this.borderWidth) {
                return this.shadowColors[column - i];
            }
            if (row < this.borderWidth) {
                return this.shadowColors[row];
            }
            if (maxH - row >= this.borderWidth) continue;
            return this.shadowColors[maxH - row];
        }
        return 0;
    }

    public DropShadowRoundRectBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.borderWidth = dataInputStream.readInt();
        this.orientation = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataLb = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataLb[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataLt = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataLt[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataRb = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataRb[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbDataRt = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbDataRt[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.shadowColors = new int[n2];
            n = 0;
            while (n < n2) {
                this.shadowColors[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.borderWidth);
        dataOutputStream.writeInt(this.orientation);
        if (this.rgbDataLb == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataLb.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataLb[n]);
                ++n;
            }
        }
        if (this.rgbDataLt == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataLt.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataLt[n]);
                ++n;
            }
        }
        if (this.rgbDataRb == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataRb.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataRb[n]);
                ++n;
            }
        }
        if (this.rgbDataRt == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbDataRt.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbDataRt[n]);
                ++n;
            }
        }
        if (this.shadowColors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.shadowColors.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.shadowColors[n]);
                ++n;
            }
        }
    }
}

