/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class DropShadowBorder
extends Border {
    public static final int BOTTOM_RIGHT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int TOP_LEFT = 3;
    public static final int ALL = 4;
    private int[] shadowColors;
    private int orientation;
    private int borderWidth;

    public DropShadowBorder(int innerColor, int outerColor, int width, int offset, int orientation) {
        super(width, width, width, width);
        this.orientation = orientation;
        this.shadowColors = DrawUtil.getGradient(innerColor, outerColor, width);
        this.borderWidth = width;
        switch (orientation) {
            case 0: {
                this.borderWidthLeft = 0;
                this.borderWidthTop = 0;
                break;
            }
            case 1: {
                this.borderWidthLeft = 0;
                this.borderWidthBottom = 0;
                break;
            }
            case 2: {
                this.borderWidthRight = 0;
                this.borderWidthTop = 0;
                break;
            }
            case 3: {
                this.borderWidthRight = 0;
                this.borderWidthBottom = 0;
            }
        }
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int left = x - 1 + this.borderWidthLeft;
        int top = y - 1 + this.borderWidthTop;
        int right = x + width - this.borderWidthRight;
        int bottom = y + height - this.borderWidthBottom;
        block7: for (int i = 0; i < this.borderWidth; ++i) {
            int color2 = this.shadowColors[i];
            switch (this.orientation) {
                case 0: {
                    DrawUtil.drawLine(color2, right + i, top + i, right + i, bottom + i, g);
                    DrawUtil.drawLine(color2, left + i, bottom + i, right + i, bottom + i, g);
                    continue block7;
                }
                case 1: {
                    DrawUtil.drawLine(color2, right + i, top - i, right + i, bottom - i, g);
                    DrawUtil.drawLine(color2, left + i, top - i, right + i, top - i, g);
                    continue block7;
                }
                case 2: {
                    DrawUtil.drawLine(color2, left - i, top + i, left - i, bottom + i, g);
                    DrawUtil.drawLine(color2, left - i, bottom + i, left - i, bottom + i, g);
                    continue block7;
                }
                case 3: {
                    DrawUtil.drawLine(color2, left - i, top - i, left - i, bottom - i, g);
                    DrawUtil.drawLine(color2, left - i, top - i, right - i, top - i, g);
                    continue block7;
                }
                case 4: {
                    DrawUtil.drawLine(color2, left - i, top + 1 + i, left - i, bottom - i, g);
                    DrawUtil.drawLine(color2, right + 1 + i, top + 1 + i, right + i, bottom - i, g);
                    DrawUtil.drawLine(color2, left + 1 + i, bottom + i, right - i, bottom + i, g);
                    DrawUtil.drawLine(color2, left + 1 + i, top - i, right - i, top - i, g);
                }
            }
        }
    }

    public DropShadowBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.borderWidth = dataInputStream.readInt();
        this.orientation = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.shadowColors = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.shadowColors[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.borderWidth);
        dataOutputStream.writeInt(this.orientation);
        if (this.shadowColors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.shadowColors.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.shadowColors[n2]);
                ++n2;
            }
        }
    }
}

