/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Display;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class VideoBackground
extends Background {
    private String url;
    private String mimeType;
    private int loopCount;
    private transient Player player;
    private int anchor;
    private int xOffset;
    private int yOffset;
    private int color;

    public VideoBackground(int color2, String url, String mimeType, int loopCount, int anchor, int xOffset, int yOffset) {
        this.color = color2;
        this.url = url;
        this.mimeType = mimeType;
        this.loopCount = loopCount;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        if (this.player == null) {
            InputStream is = this.openInputStream();
            if (is == null) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.VideoBackground", 98, (Object)"did not find video resource ", this.url);
                return;
            }
            try {
                this.player = Manager.createPlayer(is, this.mimeType);
                this.player.realize();
                this.player.setLoopCount(this.loopCount);
                VideoControl control = (VideoControl)this.player.getControl("VideoControl");
                if (control == null) {
                    Debug.debug("error", "de.enough.polish.ui.backgrounds.VideoBackground", 109, "Unable to retrieve VideoControl");
                    return;
                }
                control.initDisplayMode(1, Display.getInstance());
                int sourceWidth = control.getSourceWidth();
                int sourceHeight = control.getSourceHeight();
                if ((this.anchor & 1) == 1) {
                    x += (width >> 1) - (sourceWidth >> 1);
                } else if ((this.anchor & 8) == 8) {
                    x += width - sourceWidth;
                }
                if ((this.anchor & 2) == 2) {
                    y += (height >> 1) - (sourceHeight >> 1);
                } else if ((this.anchor & 0x20) == 32) {
                    y += height - sourceHeight;
                }
                control.setDisplayLocation(x += this.xOffset, y += this.yOffset);
                control.setVisible(true);
                this.player.start();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.VideoBackground", 136, (Object)"unable to start video ", e);
            }
        }
    }

    protected InputStream openInputStream() {
        return this.getClass().getResourceAsStream(this.url);
    }

    public void releaseResources() {
        super.releaseResources();
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.VideoBackground", 158, "unable to stop player");
            }
            this.player.deallocate();
            this.player = null;
        }
    }

    public void hideNotify() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.VideoBackground", 177, (Object)"unable to stop player ", e);
            }
        }
    }

    public void showNotify() {
        if (this.player != null) {
            try {
                VideoControl control = (VideoControl)this.player.getControl("VideoControl");
                if (control == null) {
                    return;
                }
                this.player.start();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.VideoBackground", 200, (Object)"unable to stop player ", e);
            }
        }
    }

    public VideoBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.loopCount = dataInputStream.readInt();
        this.mimeType = (String)Serializer.deserialize(dataInputStream);
        this.url = (String)Serializer.deserialize(dataInputStream);
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.loopCount);
        Serializer.serialize(this.mimeType, dataOutputStream);
        Serializer.serialize(this.url, dataOutputStream);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

