/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Color;
import de.enough.polish.ui.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class VerticalStripesBackground
extends Background {
    private Color[] stripeColors;
    private Dimension[] stripeWidhs;

    public VerticalStripesBackground(Color[] stripeColors, Dimension[] stripeWidhs) {
        if (stripeColors == null) {
            throw new IllegalArgumentException("vertical-stripes background: no stripe=colors defined.");
        }
        if (stripeWidhs == null) {
            throw new IllegalArgumentException("vertical-stripes background: no stripe=widths defined.");
        }
        if (stripeColors.length != stripeWidhs.length) {
            throw new IllegalArgumentException("vertical-stripes background: stripe-colors and stripe=widths have different number of entries.");
        }
        this.stripeColors = stripeColors;
        this.stripeWidhs = stripeWidhs;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int endX = x + width;
        Color[] colors = this.stripeColors;
        Dimension[] widths = this.stripeWidhs;
        while (x < endX) {
            for (int i = 0; i < colors.length; ++i) {
                int stripeColor = colors[i].getColor();
                int stripeWidth = widths[i].getValue(width);
                if (x + stripeWidth > endX) {
                    stripeWidth = endX - x;
                }
                g.setColor(stripeColor);
                g.fillRect(x, y, stripeWidth, height);
                x += stripeWidth;
            }
        }
    }

    public VerticalStripesBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.stripeColors = new Color[n2];
            n = 0;
            while (n < n2) {
                this.stripeColors[n] = (Color)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.stripeWidhs = new Dimension[n2];
            n = 0;
            while (n < n2) {
                this.stripeWidhs[n] = (Dimension)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        if (this.stripeColors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.stripeColors.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.stripeColors[n], dataOutputStream);
                ++n;
            }
        }
        if (this.stripeWidhs == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.stripeWidhs.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.stripeWidhs[n], dataOutputStream);
                ++n;
            }
        }
    }
}

