/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class VerticalSplitBackground
extends Background {
    private int topColor;
    private int bottomColor;
    private int splitPos;
    private boolean isPercent;

    public VerticalSplitBackground(int topColor, int bottomColor, int splitPos) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.splitPos = splitPos < 0 ? -splitPos : splitPos;
        this.isPercent = splitPos < 0;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int split = this.splitPos;
        if (this.isPercent) {
            split = height * split / 100;
        }
        g.setColor(this.topColor);
        g.fillRect(x, y, width, split + 1);
        g.setColor(this.bottomColor);
        g.fillRect(x, y + split, width, height - split);
    }

    public VerticalSplitBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomColor = dataInputStream.readInt();
        this.isPercent = dataInputStream.readBoolean();
        this.splitPos = dataInputStream.readInt();
        this.topColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomColor);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.splitPos);
        dataOutputStream.writeInt(this.topColor);
    }
}

