/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TriangleBackground
extends Background {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private int color;
    private int orientation;

    public TriangleBackground(int color2, int orientation) {
        this.color = color2;
        this.orientation = orientation;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int y3;
        int x3;
        int y2;
        int x2;
        int y1;
        int x1;
        g.setColor(this.color);
        switch (this.orientation) {
            case 0: {
                x1 = x + (width >>> 1);
                y1 = y;
                x2 = x;
                y2 = y + height;
                x3 = x + width;
                y3 = y2;
                break;
            }
            case 1: {
                x1 = x + (width >>> 1);
                y1 = y + height;
                x2 = x;
                y2 = y;
                x3 = x + width;
                y3 = y2;
                break;
            }
            case 2: {
                x1 = x;
                y1 = y + (height >>> 1);
                x2 = x + width;
                y2 = y;
                x3 = x2;
                y3 = y + height;
                break;
            }
            default: {
                x1 = x + width;
                y1 = y + (height >>> 1);
                x2 = x;
                y2 = y;
                x3 = x;
                y3 = y + height;
            }
        }
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public TriangleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.orientation = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.orientation);
    }
}

