/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DeviceInfo;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TranslucentSimpleBackground
extends Background {
    private int argbColor;
    private transient int[] buffer;
    private transient int lastWidth;
    private int lastHeight;
    private boolean needsFullBuffer;

    public TranslucentSimpleBackground(int argbColor) {
        this.needsFullBuffer = DeviceInfo.requiresFullRgbArrayForDrawRgb();
        this.argbColor = argbColor;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int i;
        int[] newBuffer;
        if (this.needsFullBuffer && (width != this.lastWidth || height != this.lastHeight)) {
            this.lastWidth = width;
            this.lastHeight = height;
            newBuffer = new int[width * height];
            for (i = newBuffer.length - 1; i >= 0; --i) {
                newBuffer[i] = this.argbColor;
            }
            this.buffer = newBuffer;
        }
        if (width != this.lastWidth) {
            this.lastWidth = width;
            newBuffer = new int[width];
            for (i = newBuffer.length - 1; i >= 0; --i) {
                newBuffer[i] = this.argbColor;
            }
            this.buffer = newBuffer;
        }
        if (this.needsFullBuffer) {
            DrawUtil.drawRgb(this.buffer, x, y, width, height, true, g);
            return;
        }
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (width <= 0) {
            return;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (height <= 0) {
            return;
        }
        try {
            g.drawRGB(this.buffer, 0, 0, x, y, width, height, true);
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.backgrounds.TranslucentSimpleBackground", 190, (Object)("problem while rendering RGB array: " + e.toString() + ": "), e.getMessage());
            e.printStackTrace();
            this.needsFullBuffer = true;
            this.lastWidth = width;
            this.lastHeight = height;
            int[] newBuffer2 = new int[width * height];
            for (int i2 = newBuffer2.length - 1; i2 >= 0; --i2) {
                newBuffer2[i2] = this.argbColor;
            }
            this.buffer = newBuffer2;
            DrawUtil.drawRgb(newBuffer2, x, y, width, height, true, g);
        }
    }

    public void releaseResources() {
        this.buffer = null;
        this.lastWidth = 0;
    }

    public TranslucentSimpleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.argbColor = dataInputStream.readInt();
        this.lastHeight = dataInputStream.readInt();
        this.needsFullBuffer = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.argbColor);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeBoolean(this.needsFullBuffer);
    }
}

