/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RoundRectCorneredBackground
extends Background {
    public static final int CORNER_NONE = 0;
    public static final int CORNER_LEFT_TOP = 1;
    public static final int CORNER_RIGHT_TOP = 2;
    public static final int CORNER_LEFT_BOTTOM = 4;
    public static final int CORNER_RIGHT_BOTTOM = 8;
    public static final int CORNER_ALL = 15;
    private int color;
    private int arcWidth;
    private int arcHeight;
    private boolean leftTop;
    private boolean rightTop;
    private boolean leftBottom;
    private boolean rightBottom;

    public RoundRectCorneredBackground(int color2, int arcWidth, int arcHeight, int straightCorners) {
        this.color = color2;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.leftTop = (straightCorners & 1) == 1;
        this.rightTop = (straightCorners & 2) == 2;
        this.leftBottom = (straightCorners & 4) == 4;
        this.rightBottom = (straightCorners & 8) == 8;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.color);
        int aw = this.arcWidth;
        int ah = this.arcHeight;
        g.fillRoundRect(x, y, width, height, aw, ah);
        if (this.leftTop) {
            g.fillRect(x, y, aw, ah);
        }
        if (this.rightTop) {
            g.fillRect(x + width - aw, y, aw, ah);
        }
        if (this.leftBottom) {
            g.fillRect(x, y + height - ah, aw, ah);
        }
        if (this.rightBottom) {
            g.fillRect(x + width - aw, y + height - ah, aw, ah);
        }
    }

    public RoundRectCorneredBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.leftBottom = dataInputStream.readBoolean();
        this.leftTop = dataInputStream.readBoolean();
        this.rightBottom = dataInputStream.readBoolean();
        this.rightTop = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.leftBottom);
        dataOutputStream.writeBoolean(this.leftTop);
        dataOutputStream.writeBoolean(this.rightBottom);
        dataOutputStream.writeBoolean(this.rightTop);
    }
}

